package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

import java.util.Objects;

import static net.covers1624.coffeegrinder.bytecode.InstructionFlag.END_POINT_UNREACHABLE;
import static net.covers1624.coffeegrinder.bytecode.InstructionFlag.MAY_BRANCH;

/**
 * Created by covers1624 on 27/2/21.
 */
public class Leave extends Instruction {

    private static final EnumBitSet<InstructionFlag> flags = EnumBitSet.of(END_POINT_UNREACHABLE, MAY_BRANCH);

    @SuppressWarnings ("NotNullFieldNotInitialized")
    private BlockContainer targetContainer;

    private Leave() {
        super(InsnOpcode.LEAVE);
    }

    public Leave(BlockContainer targetContainer) {
        this();
        this.targetContainer = targetContainer;
    }

    @Override
    protected void onConnected() {
        super.onConnected();
        targetContainer.addLeave(this);
    }

    @Override
    protected void onDisconnected() {
        super.onDisconnected();
        targetContainer.remLeave(this);
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.VOID;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return flags;
    }

    @Override
    public Leave copy() {
        return new Leave(targetContainer).withOffsets(this);
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitLeave(this, ctx);
    }

    public BlockContainer getTargetContainer() {
        return Objects.requireNonNull(targetContainer);
    }
}
