package net.covers1624.coffeegrinder.type;

import com.google.common.collect.ImmutableList;
import net.covers1624.coffeegrinder.bytecode.AccessFlag;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import net.covers1624.quack.collection.FastStream;
import org.objectweb.asm.Type;

import java.util.List;

import static java.util.Objects.requireNonNull;

/**
 * Created by covers1624 on 29/4/22.
 */
public class RawMethod extends Method {

    private final Method decl;
    private final AType returnType;
    private final List<ReferenceType> exceptions;
    private final List<Parameter> parameters;

    public RawMethod(Method decl, AType returnType, List<ReferenceType> exceptions) {
        this.decl = decl;
        parameters = FastStream.of(decl.getParameters())
                .map(p -> new Parameter(
                        p.getName(),
                        this,
                        p.getRawType(),
                        p.getFlags()
                ))
                .toImmutableList();
        this.returnType = returnType;
        this.exceptions = exceptions;
    }

    //@formatter:off
    @Override public Type getDescriptor() { return decl.getDescriptor(); }
    @Override public Object getDefaultAnnotationValue() { throw new UnsupportedOperationException(); }
    @Override public ClassType getDeclaringClass() { return decl.getDeclaringClass(); }
    @Override public List<Parameter> getParameters() { return parameters; }
    @Override public AType getReturnType() { return returnType; }
    @Override public boolean isConstructor() { return decl.isConstructor(); }
    @Override public EnumBitSet<AccessFlag> getAccessFlags() { return decl.getAccessFlags(); }
    @Override public List<ReferenceType> getExceptions() { return exceptions; }
    @Override public Method asRaw() { return this; }
    @Override public String getName() { return decl.getName(); }
    @Override public List<TypeParameter> getTypeParameters() { return ImmutableList.of(); }
    @Override public Method getDeclaration() { return decl; }
    //@formatter:on
}
