/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console.tasks;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.console.tasks.ColorPalette;
import org.junit.platform.console.tasks.DetailsPrintingListener;
import org.junit.platform.console.tasks.Style;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

class TestFeedPrintingListener
implements DetailsPrintingListener {
    private static final String INDENTATION = "\t";
    private static final String STATUS_SEPARATOR = " :: ";
    private final PrintWriter out;
    private final ColorPalette colorPalette;
    private TestPlan testPlan;

    TestFeedPrintingListener(PrintWriter out, ColorPalette colorPalette) {
        this.out = out;
        this.colorPalette = colorPalette;
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.testPlan = testPlan;
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.testPlan = null;
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        if (TestFeedPrintingListener.shouldPrint(testIdentifier)) {
            String msg = this.formatTestIdentifier(testIdentifier);
            String indentedReason = TestFeedPrintingListener.indented(String.format("Reason: %s", reason));
            this.println(Style.SKIPPED, String.format("%s :: SKIPPED%n\t%s", msg, indentedReason));
        }
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        if (TestFeedPrintingListener.shouldPrint(testIdentifier)) {
            String msg = this.formatTestIdentifier(testIdentifier);
            this.println(Style.NONE, String.format("%s :: STARTED", msg));
        }
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        TestExecutionResult.Status status = testExecutionResult.getStatus();
        if (testExecutionResult.getThrowable().isPresent()) {
            Style style = Style.valueOf(testExecutionResult);
            String msg = this.formatTestIdentifier(testIdentifier);
            Throwable throwable = (Throwable)testExecutionResult.getThrowable().get();
            String stacktrace = TestFeedPrintingListener.indented(ExceptionUtils.readStackTrace((Throwable)throwable));
            this.println(style, String.format("%s :: %s%n\t%s", msg, status, stacktrace));
        } else if (TestFeedPrintingListener.shouldPrint(testIdentifier) || testExecutionResult.getStatus() != TestExecutionResult.Status.SUCCESSFUL) {
            Style style = Style.valueOf(testExecutionResult);
            String msg = this.formatTestIdentifier(testIdentifier);
            this.println(style, String.format("%s :: %s", msg, status));
        }
    }

    private String formatTestIdentifier(TestIdentifier testIdentifier) {
        return String.join((CharSequence)" > ", this.collectDisplayNames(testIdentifier.getUniqueIdObject()));
    }

    private void println(Style style, String message) {
        this.out.println(this.colorPalette.paint(style, message));
    }

    private List<String> collectDisplayNames(UniqueId uniqueId) {
        int size = uniqueId.getSegments().size();
        ArrayList<String> displayNames = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            displayNames.add(0, this.testPlan.getTestIdentifier(uniqueId).getDisplayName());
            if (i >= size - 1) continue;
            uniqueId = uniqueId.removeLastSegment();
        }
        return displayNames;
    }

    private static String indented(String message) {
        return DetailsPrintingListener.indented(message, INDENTATION);
    }

    @Override
    public void listTests(TestPlan testPlan) {
        this.testPlan = testPlan;
        try {
            testPlan.accept(new TestPlan.Visitor(){

                public void visit(TestIdentifier testIdentifier) {
                    if (TestFeedPrintingListener.shouldPrint(testIdentifier)) {
                        TestFeedPrintingListener.this.println(Style.NONE, TestFeedPrintingListener.this.formatTestIdentifier(testIdentifier));
                    }
                }
            });
        }
        finally {
            this.testPlan = null;
        }
    }

    private static boolean shouldPrint(TestIdentifier testIdentifier) {
        return testIdentifier.isTest();
    }
}

