/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.Branch;
import net.covers1624.coffeegrinder.bytecode.insns.IfInstruction;
import net.covers1624.coffeegrinder.bytecode.insns.Invoke;
import net.covers1624.coffeegrinder.bytecode.insns.Load;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.Return;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.insns.TryCatch;
import net.covers1624.coffeegrinder.bytecode.insns.TryWithResources;
import net.covers1624.coffeegrinder.bytecode.matching.BlockMatching;
import net.covers1624.coffeegrinder.bytecode.matching.BranchLeaveMatching;
import net.covers1624.coffeegrinder.bytecode.matching.ComparisonMatching;
import net.covers1624.coffeegrinder.bytecode.matching.IfMatching;
import net.covers1624.coffeegrinder.bytecode.matching.InvokeMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.matching.TryCatchMatching;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformer;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.coffeegrinder.type.TypeSystem;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

public class J11TryWithResourcesTransform
implements MethodTransformer {
    private static final Type AUTO_CLOSEABLE = Type.getType(AutoCloseable.class);
    private static final Type THROWABLE = Type.getType(Throwable.class);
    private final ClassType autoCloseableClass;
    private final ClassType throwableClass;

    public J11TryWithResourcesTransform(TypeResolver typeResolver) {
        this.autoCloseableClass = typeResolver.resolveClass(AUTO_CLOSEABLE);
        this.throwableClass = typeResolver.resolveClass(THROWABLE);
    }

    @Override
    public void transform(MethodDecl function, MethodTransformContext ctx) {
        function.descendantsOfType(InsnOpcode.TRY_CATCH).reversed().forEach(tryCatch -> {
            if (tryCatch.isConnected()) {
                this.transformTryWithResources((TryCatch)tryCatch, ctx);
            }
        });
    }

    private void transformTryWithResources(TryCatch tryCatch, MethodTransformContext ctx) {
        TryCatch closeTryCatch;
        boolean hasNullChecks;
        Block tryParent = (Block)tryCatch.getParent();
        Branch preTryBranch = (Branch)tryParent.getBranches().onlyOrDefault();
        if (preTryBranch == null) {
            return;
        }
        Block preTryBlock = BlockMatching.matchBlock(preTryBranch.getParent());
        if (preTryBlock == null) {
            return;
        }
        if (preTryBlock.getNextSiblingOrNull() != tryParent) {
            return;
        }
        Store resourceStore = LoadStoreMatching.matchStoreLocal(preTryBranch.getPrevSiblingOrNull());
        if (resourceStore == null) {
            return;
        }
        if (!TypeSystem.isAssignableTo(resourceStore.getResultType(), (AType)this.autoCloseableClass)) {
            return;
        }
        LocalVariable resourceVariable = resourceStore.getVariable();
        TryCatch.TryCatchHandler primaryCatch = (TryCatch.TryCatchHandler)tryCatch.handlers.onlyOrDefault();
        if (primaryCatch == null) {
            return;
        }
        LocalVariable primaryCatchEx = primaryCatch.getVariable().variable;
        if (!primaryCatchEx.isSynthetic() || primaryCatchEx.getType() != this.throwableClass) {
            return;
        }
        Block primaryCatchExit = (Block)primaryCatch.getBody().blocks.last();
        Store stackStore = LoadStoreMatching.matchStoreLocalLoadLocal(primaryCatchExit.getFirstChildOrNull(), primaryCatchEx);
        if (stackStore == null) {
            return;
        }
        if (BranchLeaveMatching.matchThrow(stackStore.getNextSiblingOrNull(), stackStore.getVariable()) == null) {
            return;
        }
        Block maybeNullcheckBlock = J11TryWithResourcesTransform.getNextBlockFromBranchBlock(primaryCatch.getBody().getEntryPoint());
        if (maybeNullcheckBlock == null || maybeNullcheckBlock == primaryCatchExit) {
            return;
        }
        Block closeTryCatchBlock = maybeNullcheckBlock;
        Store nullCheckStoreLoad = LoadStoreMatching.matchStoreLocalLoadLocal(maybeNullcheckBlock.getFirstChildOrNull(), resourceVariable);
        boolean bl = hasNullChecks = nullCheckStoreLoad != null;
        if (hasNullChecks) {
            IfInstruction nullCheckIf = IfMatching.matchNopFalseIf(nullCheckStoreLoad.getNextSiblingOrNull());
            if (nullCheckIf == null) {
                return;
            }
            if (ComparisonMatching.matchEqualNull(nullCheckIf.getCondition(), nullCheckStoreLoad.getVariable()) == null) {
                return;
            }
            if (BranchLeaveMatching.matchBranch(nullCheckIf.getTrueInsn(), primaryCatchExit) == null) {
                return;
            }
            Block nextBlock = J11TryWithResourcesTransform.matchBranchToNextSiblingBlock(nullCheckIf.getNextSiblingOrNull());
            if (nextBlock == null) {
                return;
            }
            closeTryCatchBlock = J11TryWithResourcesTransform.getNextBlockFromBranchBlock(nextBlock);
            if (closeTryCatchBlock == null) {
                return;
            }
        }
        if ((closeTryCatch = TryCatchMatching.matchTryCatch((Instruction)closeTryCatchBlock.instructions.onlyOrDefault())) == null) {
            return;
        }
        Block first = (Block)closeTryCatch.getTryBody().blocks.firstOrDefault();
        if (first == null) {
            return;
        }
        Store store = LoadStoreMatching.matchStoreLocalLoadLocal(first.getFirstChildOrNull(), resourceVariable);
        if (store == null) {
            return;
        }
        Instruction invoke = store.getNextSiblingOrNull();
        if (invoke == null) {
            return;
        }
        if (!J11TryWithResourcesTransform.matchAutoCloseableCloseInvoke(invoke, store.getVariable())) {
            return;
        }
        Block next = J11TryWithResourcesTransform.matchBranchToNextSiblingBlock(invoke.getNextSiblingOrNull());
        if (next == null) {
            return;
        }
        if (BranchLeaveMatching.matchBranch((Instruction)next.instructions.onlyOrDefault(), primaryCatchExit) == null) {
            return;
        }
        TryCatch.TryCatchHandler closeCatchHandler = (TryCatch.TryCatchHandler)closeTryCatch.handlers.onlyOrDefault();
        if (closeCatchHandler == null) {
            return;
        }
        Block suppressedBlock = J11TryWithResourcesTransform.getNextBlockFromBranchBlock(closeCatchHandler.getBody().getEntryPointOrNull());
        if (suppressedBlock == null) {
            return;
        }
        Store s1 = LoadStoreMatching.matchStoreLocalLoadLocal(suppressedBlock.getFirstChildOrNull(), primaryCatchEx);
        if (s1 == null) {
            return;
        }
        Store s2 = LoadStoreMatching.matchStoreLocalLoadLocal(s1.getNextSiblingOrNull(), closeCatchHandler.getVariable().variable);
        if (s2 == null) {
            return;
        }
        Invoke invoke2 = InvokeMatching.matchInvoke(s2.getNextSiblingOrNull(), Invoke.InvokeKind.VIRTUAL, "addSuppressed");
        if (invoke2 == null) {
            return;
        }
        if (invoke2.getArguments().size() != 1) {
            return;
        }
        if (LoadStoreMatching.matchLoadLocal(invoke2.getTarget(), s1.getVariable()) == null) {
            return;
        }
        if (LoadStoreMatching.matchLoadLocal((Instruction)invoke2.getArguments().firstOrDefault(), s2.getVariable()) == null) {
            return;
        }
        if (BranchLeaveMatching.matchBranch(invoke2.getNextSiblingOrNull(), primaryCatchExit) == null) {
            return;
        }
        ctx.pushStep("produce try-with-resources");
        TryWithResources twr = tryCatch.replaceWith((TryWithResources)new TryWithResources(resourceStore, tryCatch.getTryBody()).withOffsets(tryCatch));
        ctx.popStep();
        twr.getTryBody().descendantsOfType(InsnOpcode.BRANCH).filter(e -> !e.getTargetBlock().isDescendantOf(twr)).forEach(exit -> {
            ctx.pushStep("process exit " + exit.getTargetBlock().getName());
            J11TryWithResourcesTransform.processExit(exit, hasNullChecks, resourceVariable, ctx);
            ctx.popStep();
        });
        if (resourceVariable.isSynthetic() && resourceVariable.getLoadCount() == 0) {
            ctx.pushStep("simplify to resource reference");
            resourceStore.replaceWith(resourceStore.getValue());
            ctx.popStep();
        }
    }

    private static void processExit(Branch exitBranch, boolean hasNullChecks, LocalVariable variable, MethodTransformContext ctx) {
        Instruction invoke;
        Block exit = exitBranch.getTargetBlock();
        Store stackStore = LoadStoreMatching.matchStoreLocalLoadLocal(exit.getFirstChildOrNull(), variable);
        if (stackStore == null) {
            return;
        }
        if (hasNullChecks) {
            IfInstruction nullCheckIf = IfMatching.matchNopFalseIf(stackStore.getNextSiblingOrNull());
            if (nullCheckIf == null) {
                return;
            }
            if (ComparisonMatching.matchEqualNull(nullCheckIf.getCondition(), stackStore.getVariable()) == null) {
                return;
            }
            Block next = J11TryWithResourcesTransform.matchBranchToNextSiblingBlock(nullCheckIf.getNextSiblingOrNull());
            if (next == null) {
                return;
            }
            if (next.getIncomingEdgeCount() != 1) {
                return;
            }
            Branch nextBranchToRealExit = BranchLeaveMatching.matchBranch(next.getLastChild());
            Branch realExitBranch = BranchLeaveMatching.matchBranch(nullCheckIf.getTrueInsn());
            if (realExitBranch == null) {
                return;
            }
            if (nextBranchToRealExit == null || nextBranchToRealExit.getTargetBlock() != realExitBranch.getTargetBlock()) {
                return;
            }
            Store realExitStore = LoadStoreMatching.matchStoreLocalLoadLocal(next.getFirstChild(), variable);
            if (realExitStore == null) {
                return;
            }
            stackStore = realExitStore;
            ctx.pushStep("strip null check from exit");
            exit.instructions.clear();
            exit.instructions.addAll((Iterable<Instruction>)((Object)next.instructions));
            next.remove();
            ctx.popStep();
        }
        if ((invoke = stackStore.getNextSiblingOrNull()) == null) {
            return;
        }
        if (!J11TryWithResourcesTransform.matchAutoCloseableCloseInvoke(invoke, stackStore.getVariable())) {
            return;
        }
        ctx.pushStep("strip resource close from exit");
        stackStore.remove();
        invoke.remove();
        ctx.popStep();
        Branch realExitBranch = BranchLeaveMatching.matchBranch(exit.getFirstChildOrNull());
        if (realExitBranch != null && realExitBranch.getTargetBlock().getIncomingEdgeCount() == 1) {
            ctx.pushStep("remove redundant branch to branch");
            Block realExit = realExitBranch.getTargetBlock();
            exit.instructions.clear();
            exit.instructions.addAll((Iterable<Instruction>)((Object)realExit.instructions));
            realExit.remove();
            ctx.popStep();
        }
        if (exit.getIncomingEdgeCount() != 1) {
            return;
        }
        Store synStore = LoadStoreMatching.matchStoreLocal(exit.getFirstChildOrNull());
        if (synStore == null) {
            return;
        }
        Load loadLocal = LoadStoreMatching.matchLoadLocal(synStore.getValue());
        if (loadLocal == null) {
            return;
        }
        LocalVariable synLocal = loadLocal.getVariable();
        if (!synLocal.isSynthetic()) {
            return;
        }
        if (synLocal.getReferenceCount() != 2) {
            return;
        }
        Return ret = BranchLeaveMatching.matchReturn(synStore.getNextSiblingOrNull());
        if (ret == null) {
            return;
        }
        if (LoadStoreMatching.matchLoadLocal(ret.getValue(), synStore.getVariable()) == null) {
            return;
        }
        Store storeSynLocal = LoadStoreMatching.matchStoreLocal(exitBranch.getPrevSiblingOrNull(), synLocal);
        if (storeSynLocal == null) {
            return;
        }
        ctx.pushStep("inline synthetic local return");
        storeSynLocal.replaceWith(new Return(ret.getMethod(), storeSynLocal.getValue()).withOffsets(ret));
        exitBranch.remove();
        exit.remove();
        ctx.popStep();
    }

    @Nullable
    private static Block getNextBlockFromBranchBlock(@Nullable Block block) {
        if (block == null) {
            return null;
        }
        return J11TryWithResourcesTransform.matchBranchToNextSiblingBlock((Instruction)block.instructions.onlyOrDefault());
    }

    @Nullable
    private static Block matchBranchToNextSiblingBlock(@Nullable Instruction insn) {
        if (insn == null) {
            return null;
        }
        Block parent = BlockMatching.matchBlock(insn.getParent());
        if (parent == null) {
            return null;
        }
        Block next = BlockMatching.matchBlock(parent.getNextSiblingOrNull());
        if (next == null) {
            return null;
        }
        if (BranchLeaveMatching.matchBranch(insn, next) == null) {
            return null;
        }
        return next;
    }

    private static boolean matchAutoCloseableCloseInvoke(@Nullable Instruction insn, LocalVariable autoCloseable) {
        Invoke invoke = InvokeMatching.matchInvoke(insn);
        if (invoke == null) {
            return false;
        }
        if (LoadStoreMatching.matchLoadLocal(invoke.getTarget(), autoCloseable) == null) {
            return false;
        }
        if (invoke.getKind() != Invoke.InvokeKind.VIRTUAL && invoke.getKind() != Invoke.InvokeKind.INTERFACE) {
            return false;
        }
        if (!invoke.getMethod().getName().equals("close")) {
            return false;
        }
        return invoke.getMethod().getParameters().isEmpty();
    }
}

