/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.source;

public class EscapeUtils {
    public static String escapeChars(String string) {
        int i;
        char[] chars = string.toCharArray();
        for (i = 0; i < chars.length && !EscapeUtils.needsEscape(chars[i]); ++i) {
        }
        if (i == chars.length) {
            return string;
        }
        StringBuilder sb = new StringBuilder(string.substring(0, i));
        while (i < chars.length) {
            sb.append(EscapeUtils.escapeChar(chars[i], false));
            ++i;
        }
        return sb.toString();
    }

    public static String escapeChar(char ch) {
        return EscapeUtils.escapeChar(ch, true);
    }

    private static String escapeChar(char ch, boolean charLiteral) {
        switch (ch) {
            case '\t': {
                return "\\t";
            }
            case '\b': {
                return "\\b";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\f': {
                return "\\f";
            }
            case '\'': {
                return charLiteral ? "\\'" : Character.toString(ch);
            }
            case '\"': {
                return "\\\"";
            }
            case '\\': {
                return "\\\\";
            }
        }
        if (EscapeUtils.isAscii(ch)) {
            return Character.toString(ch);
        }
        return String.format("\\u%04X", ch & 0xFFFF);
    }

    private static boolean needsEscape(char ch) {
        if (!EscapeUtils.isAscii(ch)) {
            return true;
        }
        switch (ch) {
            case '\b': 
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case '\"': 
            case '\'': 
            case '\\': {
                return true;
            }
        }
        return false;
    }

    private static boolean isAscii(char ch) {
        return ch >= ' ' && ch < '\u007f';
    }
}

