/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.type;

import com.google.common.collect.ImmutableList;
import java.lang.invoke.CallSite;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.Field;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

public abstract class ReferenceType
extends AType {
    @Nullable
    private List<Method> allMethods = null;

    public abstract ReferenceType getSuperType();

    public ReferenceType getUpperBound() {
        return this;
    }

    public ReferenceType getLowerBound() {
        return this;
    }

    public FastStream<? extends ReferenceType> getDirectSuperTypes() {
        return FastStream.of((Object)this.getSuperType());
    }

    @Nullable
    public Field resolveField(String name, Type desc) {
        return (Field)this.getDirectSuperTypes().flatMap(e -> FastStream.ofNullable((Object)e.resolveField(name, desc))).firstOrDefault();
    }

    @Nullable
    public Method resolveMethod(String name, Type desc) {
        return (Method)this.getDirectSuperTypes().flatMap(e -> FastStream.ofNullable((Object)e.resolveMethod(name, desc))).firstOrDefault();
    }

    public List<Method> getMethods() {
        return ImmutableList.of();
    }

    public List<Method> getAllMethods() {
        if (this.allMethods == null) {
            this.allMethods = this.computeAllMethods();
        }
        return this.allMethods;
    }

    private List<Method> computeAllMethods() {
        String sig;
        int lastBracket;
        String desc;
        LinkedHashSet<Method> methods = new LinkedHashSet<Method>();
        HashSet<CallSite> signatures = new HashSet<CallSite>();
        for (Method m : this.getMethods()) {
            desc = m.getDescriptor().toString();
            lastBracket = desc.indexOf(41);
            sig = m.getName() + desc.substring(0, lastBracket + 1);
            methods.add(m);
            signatures.add((CallSite)((Object)sig));
        }
        for (Method m : this.getDirectSuperTypes().flatMap(ReferenceType::getAllMethods)) {
            desc = m.getDescriptor().toString();
            lastBracket = desc.indexOf(41);
            sig = m.getName() + desc.substring(0, lastBracket + 1);
            if (signatures.contains(sig)) continue;
            methods.add(m);
        }
        return ImmutableList.copyOf(methods);
    }

    @Nullable
    public Method getFunctionalInterfaceMethod() {
        return this.getSuperType().getFunctionalInterfaceMethod();
    }

    @Override
    public boolean mentions(ReferenceType type) {
        return this == type;
    }
}

