/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.Reference;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

public class LocalReference
extends Reference {
    public final LocalVariable variable;

    public LocalReference(LocalVariable variable) {
        super(InsnOpcode.LOCAL_REFERENCE);
        this.variable = variable;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    public AType getType() {
        return this.variable.getType();
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitLocalReference(this, ctx);
    }

    @Override
    public LocalReference copy() {
        return new LocalReference(this.variable);
    }

    @Override
    protected void onConnected() {
        super.onConnected();
        this.variable.addReference(this);
    }

    @Override
    protected void onDisconnected() {
        this.variable.removeReference(this);
        super.onDisconnected();
    }
}

