/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.SimpleInsnVisitor;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.Branch;
import net.covers1624.coffeegrinder.bytecode.insns.IfInstruction;
import net.covers1624.coffeegrinder.bytecode.insns.Invoke;
import net.covers1624.coffeegrinder.bytecode.insns.LdcNumber;
import net.covers1624.coffeegrinder.bytecode.insns.LdcString;
import net.covers1624.coffeegrinder.bytecode.insns.Load;
import net.covers1624.coffeegrinder.bytecode.insns.LocalReference;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.insns.Switch;
import net.covers1624.coffeegrinder.bytecode.insns.SwitchTable;
import net.covers1624.coffeegrinder.bytecode.matching.InvokeMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LdcMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformer;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.SwitchExpressions;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.coffeegrinder.util.None;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;

public class SwitchOnString
extends SimpleInsnVisitor<StatementTransformContext>
implements StatementTransformer {
    @Override
    public void transform(Instruction statement, StatementTransformContext ctx) {
        statement.accept(this, ctx);
    }

    @Override
    public None visitStore(Store store, StatementTransformContext ctx) {
        this.tryProcessSwitchOnString(store, ctx);
        return NONE;
    }

    private void tryProcessSwitchOnString(Store strVarStore, StatementTransformContext ctx) {
        Object section;
        if (!(strVarStore.getReference() instanceof LocalReference)) {
            return;
        }
        LocalVariable strVar = strVarStore.getVariable();
        if (!strVar.isSynthetic()) {
            return;
        }
        Store synVarStore = LoadStoreMatching.matchStoreLocal(strVarStore.getNextSiblingOrNull());
        if (synVarStore == null) {
            return;
        }
        LocalVariable synVar = synVarStore.getVariable();
        if (!synVar.isSynthetic()) {
            return;
        }
        if (LdcMatching.matchLdcInt(synVarStore.getValue(), -1) == null) {
            return;
        }
        Switch synSwitch = SwitchExpressions.matchSwitch(synVarStore.getNextSiblingOrNull());
        if (synSwitch == null) {
            return;
        }
        if (SwitchOnString.matchInvokeStringHashcode(synSwitch.getValue()) == null) {
            return;
        }
        Load realSwitchLoad = (Load)FastStream.of(synVar.getReferences()).map(e -> LoadStoreMatching.matchLoadLocal(e.getParent())).filter(Objects::nonNull).only();
        Switch realSwitch = (Switch)realSwitchLoad.getParent();
        assert (realSwitch.isDescendantOf(synSwitch.getNextSibling()));
        Int2ObjectOpenHashMap stringLookup = new Int2ObjectOpenHashMap();
        Iterator<SwitchTable.SwitchSection> iterator = synSwitch.getSwitchTable().sections.iterator();
        while (iterator.hasNext()) {
            section = iterator.next();
            assert (((SwitchTable.SwitchSection)section).values.size() == 1);
            if (((Instruction)((SwitchTable.SwitchSection)section).values.first()).opcode == InsnOpcode.NOP) continue;
            this.collectSyntheticIds((Int2ObjectMap<LdcString>)stringLookup, synVar, ((Branch)((SwitchTable.SwitchSection)section).getBody()).getTargetBlock());
        }
        ctx.pushStep("Transform switch-on-string");
        SwitchTable.SwitchSection defaultSection = null;
        realSwitch.getValue().replaceWith(strVarStore.getValue());
        section = realSwitch.getSwitchTable().sections.iterator();
        while (section.hasNext()) {
            SwitchTable.SwitchSection section2 = (SwitchTable.SwitchSection)section.next();
            Iterator<Instruction> iterator2 = section2.values.iterator();
            while (iterator2.hasNext()) {
                Instruction value = iterator2.next();
                if (value.opcode == InsnOpcode.NOP) {
                    defaultSection = section2;
                    continue;
                }
                LdcNumber ldc = (LdcNumber)value;
                LdcString stringVal = (LdcString)stringLookup.remove(ldc.intValue());
                assert (stringVal != null) : "Duplicate synthetic switch id.";
                ldc.replaceWith(stringVal);
            }
        }
        if (!stringLookup.isEmpty()) {
            assert (defaultSection != null);
            FastStream toAdd = FastStream.of((Iterable)stringLookup.int2ObjectEntrySet()).sorted(Comparator.comparingInt(Int2ObjectMap.Entry::getIntKey)).map(Map.Entry::getValue);
            defaultSection.values.addAllFirst((Iterable<Instruction>)toAdd);
        }
        synSwitch.remove();
        synVarStore.remove();
        strVarStore.remove();
        ctx.popStep();
    }

    private void collectSyntheticIds(Int2ObjectMap<LdcString> stringLookup, LocalVariable synVar, Block block) {
        IfInstruction ifInsn = (IfInstruction)block.instructions.first();
        Invoke invoke = (Invoke)ifInsn.getCondition();
        LdcString ldcString = (LdcString)invoke.getArguments().first();
        Store sectionStore = (Store)((Block)ifInsn.getTrueInsn()).instructions.first();
        assert (sectionStore.getVariable() == synVar);
        LdcString prev = (LdcString)stringLookup.put(((LdcNumber)sectionStore.getValue()).intValue(), (Object)ldcString);
        assert (prev == null) : "Duplicate synthetic switch id.";
        if (ifInsn.getFalseInsn().opcode != InsnOpcode.NOP) {
            this.collectSyntheticIds(stringLookup, synVar, (Block)ifInsn.getFalseInsn());
        }
    }

    @Nullable
    private static Invoke matchInvokeStringHashcode(Instruction value) {
        Invoke invoke = InvokeMatching.matchInvoke(value, Invoke.InvokeKind.VIRTUAL);
        if (invoke == null) {
            return null;
        }
        Method method = invoke.getMethod();
        if (!TypeSystem.isString(method.getDeclaringClass())) {
            return null;
        }
        if (!method.getName().equals("hashCode")) {
            return null;
        }
        return invoke;
    }
}

