/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import java.util.Objects;
import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.SimpleInsnVisitor;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.Monitor;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.insns.Synchronized;
import net.covers1624.coffeegrinder.bytecode.insns.TryFinally;
import net.covers1624.coffeegrinder.bytecode.matching.BranchLeaveMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformer;
import net.covers1624.coffeegrinder.util.None;
import org.jetbrains.annotations.Nullable;

public class SynchronizedTransform
extends SimpleInsnVisitor<MethodTransformContext>
implements MethodTransformer {
    @Override
    public void transform(MethodDecl function, MethodTransformContext ctx) {
        function.accept(this, ctx);
    }

    @Override
    public None visitTryFinally(TryFinally tryFinally, MethodTransformContext ctx) {
        Monitor monitor = SynchronizedTransform.matchMonitorInsn(tryFinally.getPrevSiblingOrNull(), InsnOpcode.MONITOR_ENTER);
        if (monitor == null) {
            return (None)super.visitTryFinally(tryFinally, ctx);
        }
        ctx.pushStep("Generate Synchronized");
        Store store = Objects.requireNonNull(LoadStoreMatching.matchStore(monitor.getArgument()));
        Block finallyBody = tryFinally.getFinallyBody().getEntryPoint();
        Monitor monitorExit = Objects.requireNonNull(SynchronizedTransform.matchMonitorInsn(finallyBody.getFirstChild(), InsnOpcode.MONITOR_EXIT));
        Objects.requireNonNull(LoadStoreMatching.matchLoadLocal(monitorExit.getArgument(), store.getVariable()));
        Objects.requireNonNull(BranchLeaveMatching.matchLeave(monitorExit.getNextSibling(), tryFinally.getFinallyBody()));
        Synchronized sync = tryFinally.replaceWith((Synchronized)new Synchronized(store.getValue(), tryFinally.getTryBody()).withOffsets(tryFinally));
        assert (store.getVariable().getLoadCount() == 0);
        monitor.remove();
        ctx.popStep();
        sync.accept(this, ctx);
        return NONE;
    }

    @Nullable
    public static Monitor matchMonitorInsn(@Nullable Instruction insn, InsnOpcode opcode) {
        if (insn == null || opcode != insn.opcode) {
            return null;
        }
        return (Monitor)insn;
    }
}

