/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers.statement;

import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.Invoke;
import net.covers1624.coffeegrinder.bytecode.insns.LdcInsn;
import net.covers1624.coffeegrinder.bytecode.insns.Load;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.insns.tags.PotentialConstantLookupTag;
import net.covers1624.coffeegrinder.bytecode.matching.InvokeMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformer;
import net.covers1624.coffeegrinder.type.ClassType;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

public class GeneratedNullChecks
implements StatementTransformer {
    private StatementTransformContext ctx;

    @Override
    public void transform(Instruction statement, StatementTransformContext ctx) {
        this.ctx = ctx;
        Store deadStore = this.matchDeadStore(statement);
        if (deadStore == null) {
            return;
        }
        Instruction value = deadStore.getValue();
        Instruction nullCheckedValue = GeneratedNullChecks.matchNullCheck(value);
        if (nullCheckedValue != null && this.removeSyntheticNullCheck(statement, nullCheckedValue)) {
            return;
        }
        this.tagPotentialConstantLookup(statement, value, nullCheckedValue);
    }

    @Nullable
    private Store matchDeadStore(Instruction statement) {
        Instruction prev = statement.getPrevSiblingOrNull();
        if (prev == null) {
            return null;
        }
        Store deadStore = LoadStoreMatching.matchStoreLocal(prev);
        if (deadStore == null) {
            return null;
        }
        LocalVariable var = deadStore.getVariable();
        if (!var.isSynthetic() || var.getReferenceCount() > 1) {
            return null;
        }
        return deadStore;
    }

    private boolean removeSyntheticNullCheck(Instruction statement, Instruction nullCheckedValue) {
        Load nullChecked = LoadStoreMatching.matchLoadLocal(nullCheckedValue);
        if (nullChecked == null) {
            return false;
        }
        LocalVariable var = nullChecked.getVariable();
        if (var.getKind() != LocalVariable.VariableKind.STACK_SLOT) {
            return false;
        }
        if (var.getLoadCount() < 2) {
            return false;
        }
        this.ctx.pushStep("Remove synthetic null check");
        this.ctx.moveNext();
        statement.getPrevSibling().remove();
        this.ctx.popStep();
        return true;
    }

    private void tagPotentialConstantLookup(Instruction statement, Instruction deadStoreValue, @Nullable Instruction nullCheckedValue) {
        Instruction target;
        Store store = LoadStoreMatching.matchStoreLocal(statement);
        if (store == null) {
            return;
        }
        if (!(store.getValue() instanceof LdcInsn)) {
            return;
        }
        LdcInsn ldc = (LdcInsn)store.getValue();
        if (ldc.opcode == InsnOpcode.LDC_NULL || ldc.opcode == InsnOpcode.LDC_CLASS) {
            return;
        }
        boolean isStatic = nullCheckedValue == null;
        Instruction instruction = target = isStatic ? deadStoreValue : nullCheckedValue;
        if (!(target.getResultType() instanceof ClassType)) {
            return;
        }
        this.ctx.pushStep("Tag ldc: " + String.valueOf(ldc.getRawValue()));
        deadStoreValue.setTag(new PotentialConstantLookupTag(isStatic, ldc));
        this.ctx.popStep();
    }

    @Nullable
    @Contract(value="null->null")
    public static Instruction matchNullCheck(@Nullable Instruction statement) {
        if (statement == null) {
            return null;
        }
        Invoke invoke = InvokeMatching.matchInvoke(statement, Invoke.InvokeKind.VIRTUAL, "getClass", Type.getMethodType((String)"()Ljava/lang/Class;"));
        if (invoke != null) {
            return invoke.getTarget();
        }
        invoke = InvokeMatching.matchInvoke(statement, Invoke.InvokeKind.STATIC, "requireNonNull", Type.getMethodType((String)"(Ljava/lang/Object;)Ljava/lang/Object;"));
        if (invoke != null) {
            return (Instruction)invoke.getArguments().first();
        }
        return null;
    }
}

