/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;

public enum AccessFlag {
    PUBLIC("public"),
    PRIVATE("private"),
    PROTECTED("protected"),
    STATIC("static"),
    FINAL("final"),
    SYNCHRONIZED("synchronized"),
    OPEN("open"),
    TRANSITIVE("transitive"),
    VOLATILE("volatile"),
    BRIDGE("bridge"),
    STATIC_PHASE("static_phase"),
    VARARGS("varargs"),
    TRANSIENT("transient"),
    NATIVE("native"),
    INTERFACE("interface"),
    ABSTRACT("abstract"),
    STRICT("strict-fp"),
    ANNOTATION("annotation"),
    SYNTHETIC("synthetic"),
    ENUM("enum"),
    MANDATED("mandated"),
    MODULE("module"),
    RECORD("record");

    public static final List<AccessFlag> ACCESS_MODIFIERS;
    public final String name;

    private AccessFlag(String name) {
        this.name = name;
    }

    public static EnumBitSet<AccessFlag> unpackClass(int packed) {
        EnumBitSet<AccessFlag> flags = EnumBitSet.noneOf(AccessFlag.class);
        if ((packed & 1) > 0) {
            flags.set(PUBLIC);
        }
        if ((packed & 4) > 0) {
            flags.set(PROTECTED);
        }
        if ((packed & 0x10) > 0) {
            flags.set(FINAL);
        }
        if ((packed & 0x200) > 0) {
            flags.set(INTERFACE);
        }
        if ((packed & 0x400) > 0) {
            flags.set(ABSTRACT);
        }
        if ((packed & 0x1000) > 0) {
            flags.set(SYNTHETIC);
        }
        if ((packed & 0x2000) > 0) {
            flags.set(ANNOTATION);
        }
        if ((packed & 0x4000) > 0) {
            flags.set(ENUM);
        }
        if ((packed & 0x8000) > 0) {
            flags.set(MANDATED);
        }
        if ((packed & 0x8000) > 0) {
            flags.set(MODULE);
        }
        if ((packed & 0x10000) > 0) {
            flags.set(RECORD);
        }
        return flags;
    }

    public static EnumBitSet<AccessFlag> unpackInnerClass(int packed) {
        EnumBitSet<AccessFlag> flags = EnumBitSet.noneOf(AccessFlag.class);
        if ((packed & 2) > 0) {
            flags.set(PRIVATE);
        }
        if ((packed & 8) > 0) {
            flags.set(STATIC);
        }
        return flags;
    }

    public static EnumBitSet<AccessFlag> unpackMethod(int packed) {
        EnumBitSet<AccessFlag> flags = EnumBitSet.noneOf(AccessFlag.class);
        if ((packed & 1) > 0) {
            flags.set(PUBLIC);
        }
        if ((packed & 2) > 0) {
            flags.set(PRIVATE);
        }
        if ((packed & 4) > 0) {
            flags.set(PROTECTED);
        }
        if ((packed & 8) > 0) {
            flags.set(STATIC);
        }
        if ((packed & 0x10) > 0) {
            flags.set(FINAL);
        }
        if ((packed & 0x20) > 0) {
            flags.set(SYNCHRONIZED);
        }
        if ((packed & 0x40) > 0) {
            flags.set(BRIDGE);
        }
        if ((packed & 0x80) > 0) {
            flags.set(VARARGS);
        }
        if ((packed & 0x100) > 0) {
            flags.set(NATIVE);
        }
        if ((packed & 0x400) > 0) {
            flags.set(ABSTRACT);
        }
        if ((packed & 0x800) > 0) {
            flags.set(STRICT);
        }
        if ((packed & 0x1000) > 0) {
            flags.set(SYNTHETIC);
        }
        if ((packed & 0x8000) > 0) {
            flags.set(MANDATED);
        }
        return flags;
    }

    public static EnumBitSet<AccessFlag> unpackParameter(int packed) {
        EnumBitSet<AccessFlag> flags = EnumBitSet.noneOf(AccessFlag.class);
        if ((packed & 0x10) > 0) {
            flags.set(FINAL);
        }
        if ((packed & 0x1000) > 0) {
            flags.set(SYNTHETIC);
        }
        if ((packed & 0x8000) > 0) {
            flags.set(MANDATED);
        }
        return flags;
    }

    public static EnumBitSet<AccessFlag> unpackField(int packed) {
        EnumBitSet<AccessFlag> flags = EnumBitSet.noneOf(AccessFlag.class);
        if ((packed & 1) > 0) {
            flags.set(PUBLIC);
        }
        if ((packed & 2) > 0) {
            flags.set(PRIVATE);
        }
        if ((packed & 4) > 0) {
            flags.set(PROTECTED);
        }
        if ((packed & 8) > 0) {
            flags.set(STATIC);
        }
        if ((packed & 0x10) > 0) {
            flags.set(FINAL);
        }
        if ((packed & 0x40) > 0) {
            flags.set(VOLATILE);
        }
        if ((packed & 0x80) > 0) {
            flags.set(TRANSIENT);
        }
        if ((packed & 0x1000) > 0) {
            flags.set(SYNTHETIC);
        }
        if ((packed & 0x4000) > 0) {
            flags.set(ENUM);
        }
        if ((packed & 0x8000) > 0) {
            flags.set(MANDATED);
        }
        return flags;
    }

    public static String toString(EnumBitSet<AccessFlag> flags) {
        return FastStream.of(flags.toSet()).map(e -> e.name + " ").join("");
    }

    public static String stringRep(EnumBitSet<AccessFlag> flags) {
        String str = AccessFlag.toString(flags);
        if (flags.get(INTERFACE)) {
            str = str.replace(" abstract", "");
            str = str.replace("interface annotation", "@interface");
        }
        if (flags.get(ENUM)) {
            str = str.replace("final ", "");
            str = str.replace("abstract ", "");
        }
        str = str.replace("varargs ", "");
        return str;
    }

    @Nullable
    public static AccessFlag getAccess(EnumBitSet<AccessFlag> accessFlags) {
        for (AccessFlag flag : ACCESS_MODIFIERS) {
            if (!accessFlags.get(flag)) continue;
            return flag;
        }
        return null;
    }

    static {
        ACCESS_MODIFIERS = ImmutableList.of((Object)((Object)PUBLIC), (Object)((Object)PRIVATE), (Object)((Object)PROTECTED));
    }
}

