/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.flow;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.debug.Debugger;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.Nullable;

public class ControlFlowNode {
    public int cfgIndex;
    @Nullable
    public Block block;
    public boolean visited;
    public int postOrderNumber;
    private final List<ControlFlowNode> predecessors = new ArrayList<ControlFlowNode>();
    private final List<ControlFlowNode> successors = new ArrayList<ControlFlowNode>();
    @Nullable
    ControlFlowNode immediateDominator;
    @Nullable
    List<ControlFlowNode> dominatorTreeChildren = null;

    public ControlFlowNode() {
    }

    public ControlFlowNode(int cfgIndex) {
        this.cfgIndex = cfgIndex;
    }

    public ControlFlowNode(ControlFlowNode other) {
        this.cfgIndex = other.cfgIndex;
        this.block = other.block;
    }

    public ControlFlowNode(int cfgIndex, Block block) {
        this.cfgIndex = cfgIndex;
        this.block = block;
    }

    public void addEdgeTo(ControlFlowNode target) {
        this.successors.add(target);
        target.predecessors.add(this);
    }

    public void traversePreOrder(Function<ControlFlowNode, List<ControlFlowNode>> children, Consumer<ControlFlowNode> visitor) {
        if (this.visited) {
            return;
        }
        this.visited = true;
        visitor.accept(this);
        for (ControlFlowNode t : children.apply(this)) {
            t.traversePreOrder(children, visitor);
        }
    }

    public void traversePostOrder(Function<ControlFlowNode, List<ControlFlowNode>> children, Consumer<ControlFlowNode> visitor) {
        if (this.visited) {
            return;
        }
        this.visited = true;
        for (ControlFlowNode t : children.apply(this)) {
            t.traversePostOrder(children, visitor);
        }
        visitor.accept(this);
    }

    public boolean dominates(ControlFlowNode node) {
        ControlFlowNode tmp = node;
        while (tmp != null) {
            if (tmp == this) {
                return true;
            }
            tmp = tmp.immediateDominator;
        }
        return false;
    }

    public FastStream<ControlFlowNode> streamPreOrder(Function<ControlFlowNode, FastStream<ControlFlowNode>> children) {
        return FastStream.of((Object)this).concat((Iterable)children.apply(this).flatMap(e -> e.streamPreOrder(children)));
    }

    public FastStream<ControlFlowNode> streamPostOrder(Function<ControlFlowNode, FastStream<ControlFlowNode>> children) {
        return children.apply(this).flatMap(e -> e.streamPostOrder(children)).concat((Iterable)FastStream.of((Object)this));
    }

    public Block getBlock() {
        return Objects.requireNonNull(this.block);
    }

    public List<ControlFlowNode> getPredecessors() {
        return this.predecessors;
    }

    public List<ControlFlowNode> getSuccessors() {
        return this.successors;
    }

    public ControlFlowNode getImmediateDominator() {
        return Objects.requireNonNull(this.getImmediateDominatorOrNull());
    }

    @Nullable
    public ControlFlowNode getImmediateDominatorOrNull() {
        return this.immediateDominator;
    }

    public List<ControlFlowNode> getDominatorTreeChildren() {
        return Objects.requireNonNull(this.dominatorTreeChildren);
    }

    public boolean isReachable() {
        return this.dominatorTreeChildren != null;
    }

    public String toString() {
        if (this.block == null) {
            return "Block at: UNKNOWN";
        }
        return "Block at: " + this.block.getName();
    }

    private void evalDumpGraph() {
        this.evalDumpGraph("eval_graph");
    }

    private void evalDumpGraph(String name) {
        Debugger.tryIfPresent((SneakyUtils.ThrowingConsumer<Debugger, Throwable>)((SneakyUtils.ThrowingConsumer)e -> e.writeControlFlowGraph(this, Paths.get("./graphs/" + name + ".png", new String[0]))));
    }
}

