/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.covers1624.coffeegrinder.bytecode.IndexedInstructionCollection;
import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionCollection;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.InstructionSlot;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.ClassDecl;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.ParameterVariable;
import net.covers1624.coffeegrinder.bytecode.insns.Return;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.type.ReferenceType;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import org.jetbrains.annotations.Nullable;

public class MethodDecl
extends Instruction {
    public final IndexedInstructionCollection<ParameterVariable> parameters = new IndexedInstructionCollection(this);
    public final InstructionCollection<LocalVariable> variables = new InstructionCollection(this);
    private final Method method;
    private final InstructionSlot<Instruction> body = new InstructionSlot(this);
    private AType returnType;
    @Nullable
    private ReferenceType resultType;
    private final Map<Block, String> blockNames = new HashMap<Block, String>();
    private final List<Return> returns = new LinkedList<Return>();

    public MethodDecl(Method method, Instruction body, List<ParameterVariable> parameters) {
        super(InsnOpcode.METHOD_DECL);
        this.method = method;
        this.parameters.setValues(parameters);
        this.body.set(body);
        this.returnType = method.getReturnType();
    }

    @Override
    public ReferenceType getResultType() {
        return Objects.requireNonNull(this.resultType, "Result type only available for lambdas.");
    }

    @Override
    protected EnumBitSet<InstructionFlag> computeFlags() {
        if (this.getParent() instanceof ClassDecl) {
            return InstructionFlag.NONE;
        }
        return InstructionFlag.MAY_THROW.toSet();
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitMethodDecl(this, ctx);
    }

    public Method getMethod() {
        return this.method;
    }

    public AType getReturnType() {
        return this.returnType;
    }

    public void setBody(Instruction body) {
        this.body.set(body);
    }

    public void setReturnType(AType returnType) {
        this.returnType = returnType;
    }

    void addReturn(Return ret) {
        this.returns.add(ret);
    }

    void removeReturn(Return ret) {
        this.returns.remove(ret);
    }

    public void setResultType(ReferenceType resultType) {
        assert (resultType.getFunctionalInterfaceMethod() != null);
        assert (this.resultType == null || TypeSystem.areErasuresEqual(resultType, this.resultType));
        this.resultType = resultType;
    }

    public List<Return> getReturns() {
        return this.returns;
    }

    public boolean hasBody() {
        return this.body.get().opcode != InsnOpcode.NOP;
    }

    public BlockContainer getBody() {
        if (!this.hasBody()) {
            throw new UnsupportedOperationException("This function has no body.");
        }
        return (BlockContainer)this.body.get();
    }

    String getSynBlockName(Block block) {
        Object name = this.blockNames.get(block);
        if (name == null) {
            name = "SYN_L" + this.blockNames.size();
            this.blockNames.put(block, (String)name);
        }
        return name;
    }
}

