/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import java.util.ArrayList;
import net.covers1624.coffeegrinder.bytecode.AccessFlag;
import net.covers1624.coffeegrinder.bytecode.IndexedInstructionCollection;
import net.covers1624.coffeegrinder.bytecode.InsnOpcode;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.ClassDecl;
import net.covers1624.coffeegrinder.bytecode.insns.FieldDecl;
import net.covers1624.coffeegrinder.bytecode.insns.Invoke;
import net.covers1624.coffeegrinder.bytecode.insns.LdcNumber;
import net.covers1624.coffeegrinder.bytecode.insns.LdcString;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.New;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.bytecode.insns.ParameterVariable;
import net.covers1624.coffeegrinder.bytecode.matching.InvokeMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LdcMatching;
import net.covers1624.coffeegrinder.bytecode.transform.ClassTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.ClassTransformer;
import net.covers1624.coffeegrinder.type.TypeResolver;
import org.objectweb.asm.Type;

public class EnumClasses
implements ClassTransformer {
    @Override
    public void transform(ClassDecl cInsn, ClassTransformContext ctx) {
        if (!cInsn.getClazz().isEnum()) {
            return;
        }
        if (cInsn.getClazz().getSuperClass().getDeclaration() != ctx.getTypeResolver().resolveClassDecl(TypeResolver.ENUM_TYPE)) {
            return;
        }
        ArrayList enumConstants = cInsn.getFieldMembers().filter(e -> e.getField().getAccessFlags().get(AccessFlag.ENUM)).toList();
        ctx.pushStep("Remove implicit constructor params");
        for (int i = 0; i < enumConstants.size(); ++i) {
            FieldDecl enumConstant = (FieldDecl)enumConstants.get(i);
            assert (enumConstant.getValue().opcode == InsnOpcode.NEW);
            New newEnum = (New)enumConstant.getValue();
            assert (newEnum.getTarget() == null);
            IndexedInstructionCollection<Instruction> args = newEnum.getArguments();
            assert (args.size() >= 2);
            assert (args.get((int)0).opcode == InsnOpcode.LDC_STRING);
            assert (LdcMatching.matchLdcInt(args.get(1)) != null);
            assert (enumConstant.getField().getName().equals(((LdcString)args.get(0)).getValue())) : "Enum constant name violation";
            assert (i == ((LdcNumber)args.get(1)).intValue()) : "Enum constant index violation";
            args.get(0).replaceWith(new Nop());
            args.get(1).replaceWith(new Nop());
        }
        Type arrayType = Type.getType((String)("[" + String.valueOf(cInsn.getClazz().getDescriptor())));
        FieldDecl valuesField = cInsn.findField("$VALUES", arrayType);
        if (valuesField == null) {
            valuesField = cInsn.getField("ENUM$VALUES", arrayType);
        }
        valuesField.remove();
        ctx.popStep();
        ctx.pushStep("Remove effectively synthetic methods");
        cInsn.getMethod("values", Type.getMethodType((Type)arrayType, (Type[])new Type[0])).remove();
        cInsn.getMethod("valueOf", Type.getMethodType((Type)cInsn.getClazz().getDescriptor(), (Type[])new Type[]{TypeResolver.STRING_TYPE})).remove();
        ctx.popStep();
        ctx.pushStep("Remove synthetic constructor parameters");
        cInsn.getMethodMembers().filter(e -> e.getMethod().isConstructor()).forEach(m -> {
            Invoke invoke = this.findConstructorChain((MethodDecl)m);
            ((Instruction)invoke.getArguments().first()).replaceWith(new Nop());
            invoke.getArguments().get(1).replaceWith(new Nop());
            ParameterVariable rem1 = m.parameters.get(0);
            ParameterVariable rem2 = m.parameters.get(1);
            rem1.makeImplicit();
            rem2.makeImplicit();
            assert (rem1.getReferenceCount() == 0);
            assert (rem2.getReferenceCount() == 0);
        });
        ctx.popStep();
    }

    private Invoke findConstructorChain(MethodDecl function) {
        return (Invoke)function.getBody().getEntryPoint().instructions.filter(e -> InvokeMatching.matchInvoke(e, Invoke.InvokeKind.SPECIAL, "<init>") != null).only();
    }
}

