/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers.generics;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.covers1624.coffeegrinder.bytecode.insns.AbstractInvoke;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.generics.BoundSet;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.type.ReferenceType;
import net.covers1624.coffeegrinder.type.TypeParameter;
import net.covers1624.coffeegrinder.type.TypeSubstitutions;
import net.covers1624.quack.collection.FastStream;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class InferenceSolution
implements TypeSubstitutions.TypeParamMapper {
    public final Map<TypeParameter, ReferenceType> map;
    public final AType retType;
    public final List<Pair<MethodDecl, ReferenceType>> lambdaTypes;
    public final Map<AbstractInvoke, InferenceSolution> nested;
    @Nullable
    public final String failureReason;
    public final boolean hasRawArgs;
    public final boolean explicit;
    @Nullable
    public final ReferenceType polyFailed;

    private InferenceSolution(Map<TypeParameter, ReferenceType> map, AType retType, List<Pair<MethodDecl, ReferenceType>> lambdaTypes, Map<AbstractInvoke, InferenceSolution> nested, @Nullable String failureReason, boolean hasRawArgs, boolean explicit, @Nullable ReferenceType polyFailed) {
        this.map = map;
        this.retType = retType;
        this.lambdaTypes = lambdaTypes;
        this.nested = nested;
        this.failureReason = failureReason;
        this.hasRawArgs = hasRawArgs;
        this.explicit = explicit;
        this.polyFailed = polyFailed;
    }

    public static InferenceSolution failure(String reason) {
        return new InferenceSolution((Map<TypeParameter, ReferenceType>)ImmutableMap.of(), PrimitiveType.VOID, (List<Pair<MethodDecl, ReferenceType>>)ImmutableList.of(), (Map<AbstractInvoke, InferenceSolution>)ImmutableMap.of(), reason, false, false, null);
    }

    public static InferenceSolution success(Map<TypeParameter, ReferenceType> map, AType retType, Map<AbstractInvoke, InferenceSolution> nested, List<Pair<MethodDecl, ReferenceType>> lambdaTypes, boolean hasRawArgs) {
        return new InferenceSolution(map, retType, lambdaTypes, nested, null, hasRawArgs, false, null);
    }

    @Override
    public ReferenceType mapParam(TypeParameter param) {
        return this.map.getOrDefault(param, param);
    }

    public InferenceSolution makeExplicit() {
        return new InferenceSolution((Map<TypeParameter, ReferenceType>)FastStream.of(this.map.entrySet()).toImmutableMap(Map.Entry::getKey, e -> BoundSet.makeRepresentable((ReferenceType)e.getValue())), this.retType, this.lambdaTypes, this.nested, this.failureReason, this.hasRawArgs, true, null);
    }

    public InferenceSolution polyFailed(ReferenceType targetType) {
        return new InferenceSolution(this.map, this.retType, this.lambdaTypes, this.nested, this.failureReason, false, this.explicit, targetType);
    }

    public boolean hasFailed() {
        return this.failureReason != null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InferenceSolution)) {
            return false;
        }
        InferenceSolution other = (InferenceSolution)obj;
        return Objects.equals(this.failureReason, other.failureReason) && this.map.equals(other.map) && this.nested.equals(other.nested);
    }
}

