/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.covers1624.coffeegrinder.bytecode.SimpleInsnVisitor;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.LocalReference;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.IntegerConstantType;
import net.covers1624.coffeegrinder.type.IntegerConstantUnion;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.type.ReferenceType;
import net.covers1624.coffeegrinder.type.ReferenceUnionType;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.coffeegrinder.util.None;
import net.covers1624.quack.collection.ColUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class VariableLivenessGraph {
    public final int maxLocals;
    public final int firstLocalIndex;
    private final Map<LocalVariable, LocalVariable> equivalentLocals = new HashMap<LocalVariable, LocalVariable>();
    private final HashMap<Block, List<LocalVariable>> branchStacks = new HashMap();
    public final AtomicInteger nodeCounter = new AtomicInteger();
    private final Map<Block, CFNode> blockNodeMap = new HashMap<Block, CFNode>();
    private final List<Pair<LocalVariable, CFNode>> lvLoads = new LinkedList<Pair<LocalVariable, CFNode>>();
    private final List<CFNode> allNodes = new ArrayList<CFNode>();
    private CFNode currentNode;

    public VariableLivenessGraph(int maxLocals, int firstLocalIndex, Block start) {
        this.maxLocals = maxLocals;
        this.firstLocalIndex = firstLocalIndex;
        this.currentNode = this.markBlockStack(start, Collections.emptyList());
    }

    public List<CFNode> getAllNodes() {
        return Collections.unmodifiableList(this.allNodes);
    }

    public List<Pair<LocalVariable, CFNode>> getLVLoads() {
        return Collections.unmodifiableList(this.lvLoads);
    }

    public void addExceptionHandler(Block handler, LocalVariable var) {
        this.markBlockStack(handler, Collections.singletonList(var)).addInfo("eh");
    }

    public LocalReference readLocal(int index) {
        LocalVariable v = this.getEquivalentVar(this.currentNode.readLocal(index));
        this.lvLoads.add((Pair<LocalVariable, CFNode>)Pair.of((Object)v, (Object)this.currentNode));
        return new LocalReference(v);
    }

    public void visitStore(Store store) {
        this.updateCFNode(new CFNode(store));
    }

    public void addExceptionLink(Block handler) {
        this.blockNodeMap.get(handler).addLink(this.currentNode);
    }

    public void addHandlerLink(Block handler) {
        this.blockNodeMap.get(handler).addHandlerLink(this.currentNode);
    }

    public void addCFEdge(Block target, List<LocalVariable> currentStack) {
        this.markBlockStack(target, currentStack).addLink(this.currentNode);
    }

    public void markNode(String name) {
        this.updateCFNode(new CFNode(name));
    }

    public List<LocalVariable> visitBlock(Block block) {
        this.currentNode = Objects.requireNonNull(this.blockNodeMap.get(block));
        return this.branchStacks.get(block);
    }

    public void applyLVInfo(LocalVariable from) {
        this.applyLVInfo(from, Objects.requireNonNull(this.getEquivalentVar(this.currentNode.readLocal(from.getIndex()))));
    }

    public boolean isDead(Block block) {
        return !this.blockNodeMap.containsKey(block);
    }

    public void applyAllReplacements(BlockContainer mainContainer) {
        mainContainer.accept(new SimpleInsnVisitor<None>(){

            @Override
            public None visitStore(Store store, None ctx) {
                super.visitStore(store, ctx);
                LocalReference stLocVar = LoadStoreMatching.matchLocalRef(store.getReference());
                if (stLocVar != null) {
                    VariableLivenessGraph.this.makeVariableCompatibleWithType(stLocVar.variable, store.getValue().getResultType());
                }
                return NONE;
            }
        });
    }

    private void applyLVInfo(LocalVariable from, LocalVariable to) {
        assert (from.getIndex() == to.getIndex());
        if (!from.isSynthetic()) {
            if (!to.isSynthetic()) {
                assert (to.getType().equals(from.getType()));
                assert (to.getName().equals(from.getName()));
            } else {
                to.setGenericSignature(from.getGenericSignature());
                to.setType(from.getType());
                to.setName(from.getName());
                to.setSynthetic(false);
            }
            if (!from.getAnnotationSupplier().isEmpty()) {
                assert (to.getAnnotationSupplier().isEmpty() || to.getAnnotationSupplier().equals(from.getAnnotationSupplier()));
                to.setAnnotationSupplier(from.getAnnotationSupplier());
            }
        }
    }

    public LocalVariable getEquivalentVar(LocalVariable var) {
        LocalVariable equiv = this.equivalentLocals.get(var);
        if (equiv == null) {
            return var;
        }
        if (equiv != var) assert (!var.isConnected());
        LocalVariable equiv2 = this.getEquivalentVar(equiv);
        if (equiv2 != equiv) {
            assert (!equiv.isConnected());
            this.equivalentLocals.put(var, equiv2);
        }
        return equiv2;
    }

    private void makeEquivalent(LocalVariable var1, LocalVariable var2) {
        assert (var1.getIndex() == var2.getIndex());
        if ((var1 = this.getEquivalentVar(var1)) == (var2 = this.getEquivalentVar(var2))) {
            return;
        }
        assert (var1.isConnected() && var2.isConnected());
        this.equivalentLocals.put(var2, var1);
        this.makeVariableCompatibleWithType(var1, var2.getType());
        if (var2.getKind() == LocalVariable.VariableKind.LOCAL) {
            this.applyLVInfo(var2, var1);
        }
        LocalVariable finalVar = var1;
        ImmutableList.copyOf(var2.getReferences()).forEach(e -> e.replaceWith(new LocalReference(finalVar)));
    }

    private CFNode markBlockStack(Block target, List<LocalVariable> currentStack) {
        List<LocalVariable> previousStack = this.branchStacks.get(target);
        if (previousStack != null) {
            assert (currentStack.size() == previousStack.size());
            for (int i = 0; i < currentStack.size(); ++i) {
                LocalVariable currVariable = currentStack.get(i);
                LocalVariable prevVariable = previousStack.get(i);
                this.makeEquivalent(prevVariable, currVariable);
            }
        } else {
            this.branchStacks.put(target, new ArrayList<LocalVariable>(currentStack));
        }
        return this.blockNodeMap.computeIfAbsent(target, l -> new CFNode(target));
    }

    private void makeVariableCompatibleWithType(LocalVariable var, AType type) {
        if (var.isSynthetic()) {
            var.setType(VariableLivenessGraph.combineStackTypes(var.getType(), type));
        }
    }

    private static AType combineStackTypes(AType a, AType b) {
        if (a == b) {
            return a;
        }
        if (a instanceof ReferenceUnionType) {
            assert (ColUtils.anyMatch(((ReferenceUnionType)a).getTypes(), t -> t.equals(b)));
            return a;
        }
        if (TypeSystem.isAssignableTo(a, b)) {
            return b;
        }
        if (TypeSystem.isAssignableTo(b, a)) {
            return a;
        }
        if (a instanceof ReferenceType) {
            return TypeSystem.lub((ReferenceType)a, (ReferenceType)b);
        }
        if (a == PrimitiveType.BOOLEAN || b == PrimitiveType.BOOLEAN) {
            return PrimitiveType.BOOLEAN;
        }
        if (!TypeSystem.isIntegerConstant(a) || !TypeSystem.isIntegerConstant(b)) {
            assert (TypeSystem.isAssignableTo(a, PrimitiveType.INT));
            assert (TypeSystem.isAssignableTo(b, PrimitiveType.INT));
            return PrimitiveType.INT;
        }
        LinkedList<IntegerConstantType> types = new LinkedList<IntegerConstantType>();
        if (a instanceof IntegerConstantUnion) {
            types.addAll(((IntegerConstantUnion)a).getTypes());
        } else {
            types.add((IntegerConstantType)a);
        }
        types.add((IntegerConstantType)b);
        return new IntegerConstantUnion(types);
    }

    private void updateCFNode(CFNode newNode) {
        newNode.addLink(this.currentNode);
        this.currentNode = newNode;
    }

    public class CFNode {
        private String id;
        private final Set<CFNode> parents = new LinkedHashSet<CFNode>();
        private final Set<CFNode> isHandlerLink = new LinkedHashSet<CFNode>();
        private final LocalVariable[] memoTable;
        @Nullable
        private Store store;
        @Nullable
        private Block block;

        private CFNode(Store store) {
            this.memoTable = new LocalVariable[VariableLivenessGraph.this.maxLocals];
            VariableLivenessGraph.this.allNodes.add(this);
            this.store = store;
            this.id = "w" + VariableLivenessGraph.this.nodeCounter.getAndIncrement();
            this.memoTable[store.getVariable().getIndex()] = store.getVariable();
        }

        private CFNode(Block block) {
            this.memoTable = new LocalVariable[VariableLivenessGraph.this.maxLocals];
            VariableLivenessGraph.this.allNodes.add(this);
            this.block = block;
            this.id = block.getName();
        }

        private CFNode(String cfInfo) {
            this.memoTable = new LocalVariable[VariableLivenessGraph.this.maxLocals];
            VariableLivenessGraph.this.allNodes.add(this);
            this.id = cfInfo + " " + VariableLivenessGraph.this.nodeCounter.getAndIncrement();
        }

        private void addInfo(String info) {
            this.id = this.id + " " + info;
        }

        public LocalVariable getWriteVar() {
            assert (this.store != null);
            return this.store.getVariable();
        }

        private void addHandlerLink(CFNode other) {
            this.addLink(other);
            this.isHandlerLink.add(other);
        }

        private void addLink(CFNode pred) {
            this.parents.add(pred);
            for (int i = 0; i < this.memoTable.length; ++i) {
                LocalVariable v = this.memoTable[i];
                if (v == null || this.store != null && this.store.getVariable().getIndex() == i) continue;
                VariableLivenessGraph.this.makeEquivalent(v, pred.readLocal(i));
            }
        }

        private LocalVariable readLocal(int index) {
            LocalVariable v = this.memoTable[index];
            if (v != null) {
                return v;
            }
            HashMultimap pendingReads = HashMultimap.create();
            v = this.readLocal(new LinkedList<CFNode>(), (Multimap<CFNode, CFNode>)pendingReads, index);
            assert (v != null);
            assert (pendingReads.isEmpty());
            return v;
        }

        @Nullable
        private LocalVariable readLocal(LinkedList<CFNode> visiting, Multimap<CFNode, CFNode> pendingReads, int index) {
            LocalVariable v = this.memoTable[index];
            if (v != null || visiting.contains(this)) {
                return v;
            }
            visiting.push(this);
            for (CFNode parent : this.parents) {
                LocalVariable v2 = parent.readLocal(visiting, pendingReads, index);
                if (v2 != null) {
                    this.memoLocal(v2, pendingReads);
                    continue;
                }
                pendingReads.put((Object)parent, (Object)this);
            }
            visiting.pop();
            return this.memoTable[index];
        }

        private void memoLocal(LocalVariable f, Multimap<CFNode, CFNode> pendingReads) {
            LocalVariable v = this.memoTable[f.getIndex()];
            if (v == null) {
                this.memoTable[f.getIndex()] = f;
                for (CFNode cfNode : pendingReads.removeAll((Object)this)) {
                    cfNode.memoLocal(f, pendingReads);
                }
            } else {
                assert (!pendingReads.containsKey((Object)this));
                VariableLivenessGraph.this.makeEquivalent(v, f);
            }
        }

        public String getId() {
            return this.id;
        }

        @Nullable
        public Store getStore() {
            return this.store;
        }

        public Set<CFNode> getParents() {
            return Collections.unmodifiableSet(this.parents);
        }

        @Nullable
        public LocalVariable getMemoEntry(int idx) {
            return this.memoTable[idx];
        }

        public boolean isHandlerLink(CFNode node) {
            return this.isHandlerLink.contains(node);
        }
    }
}

