/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import java.util.Objects;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.SimpleInstruction;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import org.jetbrains.annotations.Nullable;

public final class Branch
extends SimpleInstruction {
    private static final EnumBitSet<InstructionFlag> FLAGS = EnumBitSet.of((Enum[])new InstructionFlag[]{InstructionFlag.END_POINT_UNREACHABLE, InstructionFlag.MAY_BRANCH});
    private Block targetBlock;

    public Branch(Block targetBlock) {
        this.targetBlock = targetBlock;
    }

    @Override
    protected void onConnected() {
        super.onConnected();
        this.targetBlock.addBranch(this);
    }

    @Override
    protected void onDisconnected() {
        super.onDisconnected();
        this.targetBlock.remBranch(this);
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.VOID;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return FLAGS;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitBranch(this, ctx);
    }

    @Override
    public Branch copy() {
        return new Branch(this.targetBlock);
    }

    @Nullable
    public BlockContainer getTargetContainerOrNull() {
        return (BlockContainer)this.targetBlock.getParentOrNull();
    }

    public BlockContainer getTargetContainer() {
        return Objects.requireNonNull(this.getTargetContainerOrNull());
    }

    public Block getTargetBlock() {
        return this.targetBlock;
    }

    public void setTargetBlock(Block targetBlock) {
        if (this.isConnected()) {
            this.targetBlock.remBranch(this);
        }
        this.targetBlock = targetBlock;
        if (this.isConnected()) {
            this.targetBlock.addBranch(this);
        }
    }
}

