/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.InstructionSlot;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

public final class Return
extends Instruction {
    private final InstructionSlot<Instruction> value = new InstructionSlot(this);
    private final MethodDecl method;

    public Return(MethodDecl method) {
        this(method, new Nop());
    }

    public Return(MethodDecl method, Instruction value) {
        this.method = method;
        this.value.set(value);
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.VOID;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.END_POINT_UNREACHABLE.toSet();
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitReturn(this, ctx);
    }

    @Override
    protected void onConnected() {
        super.onConnected();
        this.method.addReturn(this);
    }

    @Override
    protected void onDisconnected() {
        super.onDisconnected();
        this.method.removeReturn(this);
    }

    public Instruction getValue() {
        return this.value.get();
    }

    public MethodDecl getMethod() {
        return this.method;
    }
}

