/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import java.util.LinkedList;
import java.util.List;
import net.covers1624.coffeegrinder.bytecode.AccessFlag;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.ClassDecl;
import net.covers1624.coffeegrinder.bytecode.insns.Invoke;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.bytecode.insns.ParameterVariable;
import net.covers1624.coffeegrinder.bytecode.matching.BranchLeaveMatching;
import net.covers1624.coffeegrinder.bytecode.matching.InvokeMatching;
import net.covers1624.coffeegrinder.bytecode.transform.ClassTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.ClassTransformer;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Parameter;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.quack.collection.ColUtils;
import org.objectweb.asm.Type;

public class ImplicitConstructorCleanup
implements ClassTransformer {
    private ClassTransformContext ctx;

    @Override
    public void transform(ClassDecl cInsn, ClassTransformContext ctx) {
        this.ctx = ctx;
        if (cInsn.getClazz().getDeclType() == ClassType.DeclType.TOP_LEVEL) {
            this.apply(cInsn);
        }
    }

    private void apply(ClassDecl cInsn) {
        ClassType cType = cInsn.getClazz();
        LinkedList constructors = cInsn.getMethodMembers().filter(e -> e.getMethod().isConstructor()).toLinkedList();
        this.ctx.pushStep("Cleanup targeted inner constructor calls " + cType.getName());
        for (MethodDecl constructor : constructors) {
            this.cleanupTargetedInnerConstructorCall(constructor);
        }
        this.ctx.popStep();
        this.ctx.pushStep("Remove redundant super calls " + cType.getName());
        for (MethodDecl constructor : constructors) {
            this.removeRedundantSuperCall(constructor);
        }
        this.ctx.popStep();
        if (cInsn.getClazz().getAccessFlags().get(AccessFlag.RECORD)) {
            this.ctx.pushStep("Cleanup redundant canonical record constructors " + cType.getName());
            this.removeRedundantCanonicalRecordConstructor(cInsn);
            this.ctx.popStep();
        } else {
            this.ctx.pushStep("Remove single empty constructor " + cType.getName());
            this.removeRedundantConstructors(cInsn, constructors);
            this.ctx.popStep();
        }
        MethodDecl staticInit = cInsn.findMethod("<clinit>", Type.getMethodType((String)"()V"));
        if (staticInit != null && ImplicitConstructorCleanup.isEmpty(staticInit)) {
            this.ctx.pushStep("Remove empty static initializer " + cType.getName());
            staticInit.remove();
            this.ctx.popStep();
        }
        for (ClassDecl nestedClass : cInsn.getNestedClasses()) {
            this.apply(nestedClass);
        }
    }

    private void cleanupTargetedInnerConstructorCall(MethodDecl ctor) {
        Invoke invoke = InvokeMatching.matchInvoke(ctor.getBody().getEntryPoint().getFirstChildOrNull(), Invoke.InvokeKind.SPECIAL, "<init>");
        if (invoke == null) {
            return;
        }
        if (TypeSystem.isConstructedViaTargetInstance(invoke.getMethod().getDeclaringClass())) {
            Instruction first = (Instruction)invoke.getArguments().first();
            first.replaceWith(new Nop());
        }
    }

    private void removeRedundantSuperCall(MethodDecl ctor) {
        Invoke invoke = InvokeMatching.getSuperConstructorCall(ctor);
        if (invoke == null) {
            return;
        }
        if (!invoke.getArguments().allMatch(e -> e instanceof Nop)) {
            return;
        }
        invoke.remove();
    }

    private void removeRedundantCanonicalRecordConstructor(ClassDecl cInsn) {
        MethodDecl canonicalCtor = cInsn.canonicalCtor;
        if (canonicalCtor == null) {
            return;
        }
        if (!ImplicitConstructorCleanup.isEmpty(canonicalCtor)) {
            return;
        }
        if (ColUtils.anyMatch(canonicalCtor.getMethod().getParameters(), Parameter::isMandated)) {
            return;
        }
        canonicalCtor.remove();
        cInsn.canonicalCtor = null;
    }

    private void removeRedundantConstructors(ClassDecl cInsn, List<MethodDecl> constructors) {
        if (constructors.size() != 1) {
            return;
        }
        MethodDecl ctor = constructors.get(0);
        if (cInsn.getClazz().getDeclType() == ClassType.DeclType.ANONYMOUS) {
            ctor.remove();
            return;
        }
        if (!ctor.getMethod().getExceptions().isEmpty()) {
            return;
        }
        AccessFlag access = AccessFlag.getAccess(ctor.getMethod().getAccessFlags());
        if (cInsn.getClazz().getDeclType() == ClassType.DeclType.LOCAL ? access != null : !cInsn.getClazz().isEnum() && access != AccessFlag.getAccess(cInsn.getClazz().getAccessFlags())) {
            return;
        }
        if (!ctor.getMethod().getAnnotationSupplier().isEmpty()) {
            return;
        }
        if (!ctor.parameters.allMatch(ParameterVariable::isImplicit)) {
            return;
        }
        if (!ImplicitConstructorCleanup.isEmpty(ctor)) {
            return;
        }
        ctor.remove();
    }

    private static boolean isEmpty(MethodDecl function) {
        BlockContainer body = function.getBody();
        if (body.getEntryPoint().instructions.size() != 1) {
            return false;
        }
        return BranchLeaveMatching.matchReturn(body.getEntryPoint().getFirstChild(), function) != null;
    }
}

