/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import com.google.common.collect.ImmutableList;
import java.util.Objects;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.ClassDecl;
import net.covers1624.coffeegrinder.bytecode.insns.FieldDecl;
import net.covers1624.coffeegrinder.bytecode.insns.FieldReference;
import net.covers1624.coffeegrinder.bytecode.insns.LoadThis;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.ParameterVariable;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.matching.InvokeMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.ClassTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.ClassTransformer;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Field;
import net.covers1624.coffeegrinder.type.Parameter;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.Nullable;

public class InnerClasses
implements ClassTransformer {
    private ClassTransformContext ctx;
    private ClassType outerType;

    @Override
    public void transform(ClassDecl cInsn, ClassTransformContext ctx) {
        this.ctx = ctx;
        cInsn.getClassMembers().forEach(e -> this.processInnerClass((ClassDecl)e, ctx));
    }

    private void processInnerClass(ClassDecl cInsn, ClassTransformContext ctx) {
        if (cInsn.getClazz().isStatic()) {
            return;
        }
        ctx.pushStep("Remove synthetic Outer.this field");
        this.outerType = cInsn.getClazz().getEnclosingClass().orElseThrow(SneakyUtils.notPossible());
        FastStream constructors = cInsn.getMethodMembers().filter(f -> f.getMethod().isConstructor());
        Field thisField = (Field)constructors.map(this::matchOuterThisField).filter(Objects::nonNull).distinct().onlyOrDefault();
        assert (thisField == null || ((ClassType)thisField.getType()).getDeclaration() == this.outerType);
        assert (thisField == null || thisField.isSynthetic());
        constructors.forEach(this::removeOuterThisParam);
        if (thisField != null) {
            cInsn.descendantsMatching(e -> LoadStoreMatching.matchLoadField(e, thisField)).forEach(e -> e.replaceWith(new LoadThis(TypeSystem.makeThisType(this.outerType))));
            ((FieldDecl)cInsn.getFieldMembers().filter(f -> f.getField().equals(thisField)).only()).remove();
        }
        ctx.popStep();
    }

    private void removeOuterThisParam(MethodDecl constructor) {
        Store storeField = LoadStoreMatching.matchStoreField(constructor.getBody().getEntryPoint().getFirstChild());
        if (storeField != null) {
            storeField.remove();
        }
        ParameterVariable thisParam = constructor.parameters.get(0);
        thisParam.makeImplicit();
        ImmutableList.copyOf(thisParam.getReferences()).forEach(e -> Objects.requireNonNull(LoadStoreMatching.matchLoad(e.getParent())).replaceWith(new LoadThis(TypeSystem.makeThisType(this.outerType))));
    }

    @Nullable
    private Field matchOuterThisField(MethodDecl constructor) {
        LocalVariable thisParam = constructor.parameters.get(0);
        Parameter parameter = constructor.getMethod().getParameters().get(0);
        assert (((ClassType)thisParam.getType()).getDeclaration() == this.outerType);
        Instruction first = constructor.getBody().getEntryPoint().getFirstChild();
        Store storeField = LoadStoreMatching.matchStoreField(first);
        if (storeField == null) {
            assert (parameter.isMandated() || parameter.isSynthetic() || InvokeMatching.matchConstructorInvokeSpecial(first, constructor.getMethod().getDeclaringClass()) != null);
            return null;
        }
        FieldReference fieldRef = (FieldReference)storeField.getReference();
        assert (fieldRef.getTarget() instanceof LoadThis);
        assert (LoadStoreMatching.matchLoadLocal(storeField.getValue(), thisParam) != null);
        return fieldRef.getField();
    }
}

