/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.ArrayElementReference;
import net.covers1624.coffeegrinder.bytecode.insns.ClassDecl;
import net.covers1624.coffeegrinder.bytecode.insns.FieldReference;
import net.covers1624.coffeegrinder.bytecode.insns.Invoke;
import net.covers1624.coffeegrinder.bytecode.insns.LdcNumber;
import net.covers1624.coffeegrinder.bytecode.insns.Load;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.insns.Switch;
import net.covers1624.coffeegrinder.bytecode.insns.SwitchTable;
import net.covers1624.coffeegrinder.bytecode.matching.InvokeMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LdcMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.ClassTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.ClassTransformer;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Field;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

public class SwitchOnEnum
implements ClassTransformer {
    @Override
    public void transform(ClassDecl cInsn, ClassTransformContext ctx) {
        if (cInsn.getClazz().getDeclType() != ClassType.DeclType.TOP_LEVEL) {
            return;
        }
        SwitchState switchState = new SwitchState(cInsn);
        for (Switch aSwitch : cInsn.descendantsOfType(Switch.class)) {
            this.transformSwitchOnEnum(cInsn.getClazz(), aSwitch, switchState, ctx);
        }
        if (switchState.switchMapClass == null) {
            return;
        }
        ctx.pushStep("Remove switchmap inner class");
        switchState.switchMapClass.remove();
        ctx.popStep();
    }

    private void transformSwitchOnEnum(ClassType rootClass, Switch aSwitch, SwitchState switchState, ClassTransformContext ctx) {
        Load load = LoadStoreMatching.matchLoad(aSwitch.getValue());
        if (load == null) {
            return;
        }
        ArrayElementReference arrayElemRef = LoadStoreMatching.matchElemRef(load.getReference());
        if (arrayElemRef == null) {
            return;
        }
        Invoke invoke = InvokeMatching.matchInvoke(arrayElemRef.getIndex(), Invoke.InvokeKind.VIRTUAL, "ordinal", Type.getMethodType((String)"()I"));
        if (invoke == null) {
            return;
        }
        FieldReference fieldRef = LoadStoreMatching.matchLoadFieldRef(arrayElemRef.getArray());
        if (fieldRef == null) {
            return;
        }
        Field field = fieldRef.getField();
        ClassType fieldDecl = field.getDeclaringClass();
        if (!fieldDecl.isSynthetic()) {
            return;
        }
        if (!fieldDecl.getEnclosingClass().map(e -> e == rootClass).isPresent()) {
            return;
        }
        Int2ObjectMap<Field> switchMap = switchState.getSwitchMap(field);
        ctx.pushStep("Transform switch on enum");
        Iterator<SwitchTable.SwitchSection> iterator = aSwitch.getSwitchTable().sections.iterator();
        while (iterator.hasNext()) {
            SwitchTable.SwitchSection section = iterator.next();
            Iterator<Instruction> iterator2 = section.values.iterator();
            while (iterator2.hasNext()) {
                Instruction value = iterator2.next();
                if (value instanceof Nop) continue;
                LdcNumber ldc = LdcMatching.matchLdcInt(value);
                assert (ldc != null);
                Field enumField = (Field)switchMap.get(ldc.intValue());
                assert (enumField != null);
                ldc.replaceWith(new FieldReference(enumField));
            }
        }
        load.replaceWith(invoke.getTarget());
        ctx.popStep();
    }

    @Nullable
    private static Store matchStoreElem(Instruction instruction) {
        Store store = LoadStoreMatching.matchStore(instruction);
        if (store == null || !(store.getReference() instanceof ArrayElementReference)) {
            return null;
        }
        return store;
    }

    private static class SwitchState {
        private final ClassDecl rootClass;
        @Nullable
        private ClassDecl switchMapClass;
        @Nullable
        private Map<Field, Int2ObjectMap<Field>> switchMap;

        private SwitchState(ClassDecl rootClass) {
            this.rootClass = rootClass;
        }

        private Int2ObjectMap<Field> getSwitchMap(Field switchMapField) {
            if (this.switchMap == null) {
                this.switchMapClass = (ClassDecl)this.rootClass.getClassMembers().filter(e -> e.getClazz() == switchMapField.getDeclaringClass()).only();
                this.switchMap = this.parseSwitchMap(this.switchMapClass);
            }
            return Objects.requireNonNull(this.switchMap.get(switchMapField));
        }

        private Map<Field, Int2ObjectMap<Field>> parseSwitchMap(ClassDecl switchMapClass) {
            MethodDecl staticInit = switchMapClass.getMethod("<clinit>", Type.getMethodType((String)"()V"));
            HashMap<Field, Int2ObjectMap<Field>> switchMap = new HashMap<Field, Int2ObjectMap<Field>>();
            staticInit.descendantsMatching(SwitchOnEnum::matchStoreElem).forEach(arrStore -> {
                ArrayElementReference elemRef = (ArrayElementReference)arrStore.getReference();
                FieldReference arrayRef = Objects.requireNonNull(LoadStoreMatching.matchLoadFieldRef(elemRef.getArray()));
                Invoke invoke = Objects.requireNonNull(InvokeMatching.matchInvoke(elemRef.getIndex(), Invoke.InvokeKind.VIRTUAL, "ordinal", Type.getMethodType((String)"()I")));
                FieldReference enumFieldRef = Objects.requireNonNull(LoadStoreMatching.matchLoadFieldRef(invoke.getTarget()));
                LdcNumber constantLdc = Objects.requireNonNull(LdcMatching.matchLdcInt(arrStore.getValue()));
                switchMap.computeIfAbsent(arrayRef.getField(), e -> new Int2ObjectArrayMap()).put(constantLdc.intValue(), (Object)enumFieldRef.getField());
            });
            return switchMap;
        }
    }
}

