/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers.generics;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import net.covers1624.coffeegrinder.bytecode.IndexedInstructionCollection;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.AbstractInvoke;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.MethodReference;
import net.covers1624.coffeegrinder.bytecode.insns.New;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.bytecode.insns.ParameterVariable;
import net.covers1624.coffeegrinder.bytecode.insns.Return;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.generics.TarjanDepthFirstIterator;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ArrayType;
import net.covers1624.coffeegrinder.type.CapturedTypeVar;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.ITypeParameterizedMember;
import net.covers1624.coffeegrinder.type.IntersectionType;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.type.NullConstantType;
import net.covers1624.coffeegrinder.type.Parameter;
import net.covers1624.coffeegrinder.type.ParameterizedClass;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.type.RawClass;
import net.covers1624.coffeegrinder.type.ReferenceType;
import net.covers1624.coffeegrinder.type.TypeParameter;
import net.covers1624.coffeegrinder.type.TypeSubstitutions;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.coffeegrinder.type.TypeVariable;
import net.covers1624.coffeegrinder.type.WildcardType;
import net.covers1624.coffeegrinder.util.Util;
import net.covers1624.quack.collection.ColUtils;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BoundSet {
    protected final Map<TypeParameter, InferenceVar> vars = new LinkedHashMap<TypeParameter, InferenceVar>();
    protected final AType infVarRetType;
    protected final Map<InferenceVar, VarBounds<?>> bounds = new LinkedHashMap();
    protected final Map<AbstractInvoke, BoundSet> nestedVars = new LinkedHashMap<AbstractInvoke, BoundSet>();
    protected boolean hasRawArgs;
    @Nullable
    protected String failure = null;
    @Nullable
    private BoundSet parent;
    private int nestedIndex;
    private int numNestedChildren;
    private static final TypeSubstitutions.TypeMapper MAKE_REPRESENTABLE = type -> {
        if (type instanceof CapturedTypeVar) {
            return ((CapturedTypeVar)type).wildcard;
        }
        return type;
    };

    protected BoundSet(BoundSet other) {
        this.vars.putAll(other.vars);
        for (Map.Entry<InferenceVar, VarBounds<?>> entry : other.bounds.entrySet()) {
            this.bounds.put(entry.getKey(), this.copyVarBounds(entry.getValue()));
        }
        this.infVarRetType = other.infVarRetType;
        this.hasRawArgs = other.hasRawArgs;
        this.nestedVars.putAll(other.nestedVars);
        this.failure = other.failure;
        this.parent = other.parent;
        this.nestedIndex = other.nestedIndex;
        this.numNestedChildren = other.numNestedChildren;
    }

    public BoundSet(Iterable<TypeParameter> typeParameters, AType retType) {
        for (TypeParameter param : typeParameters) {
            InferenceVar v = new InferenceVar(param.getName() + "?", param);
            this.vars.put(param, v);
            this.bounds.put(v, this.newVarBounds());
        }
        for (TypeParameter param : typeParameters) {
            this.subtype(this.var(param), this.substInfVars(param.getUpperBound()));
        }
        for (TypeParameter param : typeParameters) {
            this.boundsFor(param).reverseUppers();
        }
        this.infVarRetType = retType instanceof ReferenceType ? this.substInfVars((ReferenceType)retType) : retType;
    }

    protected VarBounds<?> newVarBounds() {
        return new SimpleVarBounds(this);
    }

    protected VarBounds<?> copyVarBounds(VarBounds<?> other) {
        throw new UnsupportedOperationException("This bound set cannot be copied.");
    }

    public void constrainThrown(ReferenceType exType) {
        if (exType instanceof TypeParameter) {
            this.boundsFor((TypeParameter)((TypeParameter)exType)).thrown = true;
        }
    }

    public void constrainAssignable(Instruction insn, AType type) {
        if (!(type instanceof ReferenceType)) {
            return;
        }
        this.assignable(insn, this.substInfVars((ReferenceType)type));
    }

    public void constrainReturnAssignable(ReferenceType polyResultType) {
        this.assignable(this.infVarRetType, (AType)polyResultType);
    }

    protected InferenceVarMapper solve() {
        HashMap<InferenceVar, ReferenceType> solution = new HashMap<InferenceVar, ReferenceType>();
        InferenceVarMapper mapper = p -> solution.getOrDefault(p, p);
        for (List<InferenceVar> list : new TarjanDepthFirstIterator<InferenceVar>(this.bounds.keySet(), v -> this.boundsFor((InferenceVar)v).getDeps())) {
            solution.putAll(this.solveVars(list, mapper));
        }
        assert (this.bounds.size() == solution.size());
        return mapper;
    }

    protected Map<InferenceVar, ReferenceType> solveVars(List<InferenceVar> vars, InferenceVarMapper solved) {
        Map<InferenceVar, ReferenceType> solution = this.solvePhases(vars, solved);
        if (solution.size() == vars.size() && this.check(solution, solved)) {
            return solution;
        }
        return this.solveFreshUpper(vars, solved);
    }

    protected final Map<InferenceVar, ReferenceType> solvePhases(List<InferenceVar> vars, InferenceVarMapper solved) {
        HashMap<InferenceVar, ReferenceType> solution = new HashMap<InferenceVar, ReferenceType>();
        InferenceVarMapper partialSolution = p -> solution.getOrDefault(p, solved.mapType(p));
        for (ResolutionPhase phase : ResolutionPhase.values()) {
            HashMap<InferenceVar, ReferenceType> solvedThisPhase = new HashMap<InferenceVar, ReferenceType>();
            for (InferenceVar var : vars) {
                ReferenceType t;
                if (solution.containsKey(var) || (t = this.solvePhase(phase, this.boundsFor(var), partialSolution)) == null) continue;
                assert (BoundSet.isProper(t));
                solvedThisPhase.put(var, t);
            }
            solution.putAll(solvedThisPhase);
        }
        return solution;
    }

    @Nullable
    protected ReferenceType solvePhase(ResolutionPhase phase, VarBounds<?> bounds, InferenceVarMapper solved) {
        return phase.solve(bounds, solved);
    }

    private boolean check(Map<InferenceVar, ReferenceType> solution, InferenceVarMapper solved) {
        InferenceVarMapper combined = v -> solution.getOrDefault(v, solved.mapType(v));
        return ColUtils.allMatch(solution.keySet(), v -> this.check((InferenceVar)v, combined.substFunc()));
    }

    private boolean check(InferenceVar var, TypeSubstitutions.TypeSubstApplier subst) {
        ReferenceType varResult = (ReferenceType)subst.apply(var);
        VarBounds<?> bounds = this.boundsFor(var);
        return bounds.equalTypes(subst).allMatch(e -> ((ReferenceType)subst.apply(e)).equals(varResult)) && bounds.lowerTypes(subst).allMatch(l -> TypeSystem.isAssignableTo((ReferenceType)subst.apply(l), varResult)) && bounds.upperTypes(subst).allMatch(u -> TypeSystem.isAssignableTo(varResult, (ReferenceType)subst.apply(u)));
    }

    private Map<InferenceVar, ReferenceType> solveFreshUpper(List<InferenceVar> vars, InferenceVarMapper solved) {
        abstract class FreshTypeVar
        extends TypeVariable {
            protected final InferenceVar var;
            protected ReferenceType upper;

            protected FreshTypeVar(BoundSet this$0, InferenceVar var) {
                this.var = var;
                this.upper = TypeSystem.objectType(var);
            }

            @Override
            public ReferenceType getUpperBound() {
                return this.upper;
            }

            abstract void update(InferenceVarMapper var1);

            public String toString() {
                return this.getName();
            }

            @Override
            public String getName() {
                return "ft:" + this.var.getName();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof FreshTypeVar)) {
                    return false;
                }
                FreshTypeVar other = (FreshTypeVar)o;
                return other.var.equals(this.var);
            }

            public int hashCode() {
                return this.var.hashCode();
            }
        }
        ImmutableMap solution = FastStream.of(vars).toImmutableMap(Function.identity(), var -> {
            final ArrayList uppers = this.boundsFor((InferenceVar)var).upperTypes(solved.substFunc()).toList();
            Util.reverse(uppers);
            if (ColUtils.allMatch((Iterable)uppers, BoundSet::isProper)) {
                return TypeSystem.glbJavac(uppers);
            }
            return new FreshTypeVar(this, (InferenceVar)var){
                {
                    super(this$0, var);
                }

                @Override
                void update(InferenceVarMapper freshVars) {
                    this.upper = TypeSystem.glbJavac((Iterable<ReferenceType>)FastStream.of((Iterable)uppers).map((Function)freshVars.substFunc()));
                }
            };
        });
        InferenceVarMapper mapFresh = arg_0 -> BoundSet.lambda$solveFreshUpper$9((Map)solution, arg_0);
        for (ReferenceType t : solution.values()) {
            if (!(t instanceof FreshTypeVar)) continue;
            ((FreshTypeVar)t).update(mapFresh);
        }
        if (this.check((Map<InferenceVar, ReferenceType>)solution, solved)) {
            return solution;
        }
        throw new ResolveFailedException("Fresh type vars failed check");
    }

    protected void addNestedVars(AbstractInvoke expr, BoundSet other) {
        assert (other.parent == null);
        for (Map.Entry<InferenceVar, VarBounds<?>> entry : other.bounds.entrySet()) {
            this.bounds.put(entry.getKey(), entry.getValue().setRoot(this));
        }
        this.nestedVars.put(expr, other);
        other.parent = this;
        other.nestedIndex = this.numNestedChildren++;
        if (other.failure != null) {
            this.fail(other.failure);
        }
    }

    protected VarBounds<?> boundsFor(InferenceVar var) {
        return this.bounds.get(var);
    }

    protected VarBounds<?> boundsFor(TypeParameter param) {
        return this.boundsFor(this.var(param));
    }

    private InferenceVar var(TypeParameter param) {
        return Objects.requireNonNull(this.vars.get(param));
    }

    private ReferenceType subst(TypeParameter param) {
        InferenceVar var = this.vars.get(param);
        return var != null ? var : param;
    }

    private ReferenceType substInfVars(ReferenceType t) {
        return TypeSubstitutions.subst(t, this::subst);
    }

    public static boolean isPoly(Method method) {
        return method.isConstructor() ? method.getDeclaringClass().getDeclaration().hasTypeParameters() : method.hasTypeParameters() && BoundSet.mentionsTypeParam(method.getReturnType(), method);
    }

    @NotNull
    private static ClassType retTypeForConstructor(ClassType c) {
        if (TypeSystem.isFullyDefined(c)) {
            return c;
        }
        ClassType decl = c.getDeclaration();
        assert (decl.hasTypeParameters());
        ParameterizedClass pOuter = c instanceof ParameterizedClass ? ((ParameterizedClass)c).getOuter() : null;
        return new ParameterizedClass(pOuter, decl, (List)SneakyUtils.unsafeCast(decl.getTypeParameters()));
    }

    protected static boolean isProper(AType t) {
        if (t instanceof InferenceVar) {
            return false;
        }
        if (t instanceof ParameterizedClass) {
            return FastStream.of(((ParameterizedClass)t).getTypeArguments()).allMatch(BoundSet::isProper);
        }
        if (t instanceof ArrayType) {
            return BoundSet.isProper(((ArrayType)t).getElementType());
        }
        if (t instanceof WildcardType) {
            return BoundSet.isProper(((WildcardType)t).getUpperBound()) && BoundSet.isProper(((WildcardType)t).getLowerBound());
        }
        if (t instanceof IntersectionType) {
            return ((IntersectionType)t).getDirectSuperTypes().allMatch(BoundSet::isProper);
        }
        return true;
    }

    public static Iterable<TypeParameter> getInferrableTypeParams(Method method) {
        Iterable<TypeParameter> variables = method.getTypeParameters();
        if (method.isConstructor()) {
            variables = Iterables.concat(method.getDeclaringClass().getDeclaration().getTypeParameters(), variables);
        }
        return variables;
    }

    public static boolean mentionsTypeParamFromClassOrOuter(AType t, ClassType clazz) {
        if (BoundSet.mentionsTypeParam(t, clazz)) {
            return true;
        }
        if (!TypeSystem.needsOuterParameterization(clazz)) {
            return false;
        }
        return BoundSet.mentionsTypeParamFromClassOrOuter(t, clazz.getEnclosingClass().orElseThrow(SneakyUtils.notPossible()));
    }

    public static boolean mentionsInferrableTypeParam(AType t, Method m) {
        return BoundSet.mentionsTypeParam(t, m) || m.isConstructor() && BoundSet.mentionsTypeParam(t, m.getDeclaringClass());
    }

    public static boolean mentionsTypeParam(AType t, ITypeParameterizedMember owner) {
        return t instanceof ReferenceType && BoundSet.mentionsTypeParam((ReferenceType)t, owner, e -> false);
    }

    public static boolean mentionsTypeParam(ReferenceType t, ITypeParameterizedMember owner, Predicate<TypeParameter> seen) {
        if (t instanceof TypeParameter) {
            return !seen.test((TypeParameter)t) && (((TypeParameter)t).getOwner() == owner || BoundSet.mentionsTypeParam(t.getSuperType(), owner, p -> p == t || seen.test((TypeParameter)p)));
        }
        if (t instanceof ParameterizedClass) {
            return FastStream.of(((ParameterizedClass)t).getTypeArguments()).anyMatch(e -> BoundSet.mentionsTypeParam(e, owner, seen));
        }
        if (t instanceof ArrayType && ((ArrayType)t).getElementType() instanceof ReferenceType) {
            return BoundSet.mentionsTypeParam((ReferenceType)((ArrayType)t).getElementType(), owner, seen);
        }
        if (t instanceof WildcardType) {
            return BoundSet.mentionsTypeParam(t.getUpperBound(), owner, seen) || BoundSet.mentionsTypeParam(t.getLowerBound(), owner, seen);
        }
        return false;
    }

    public static AType getHierarchyCompatibleType(AType targetType, AType inputType) {
        if (targetType instanceof ReferenceType && inputType instanceof ReferenceType) {
            return BoundSet.getHierarchyCompatibleType((ReferenceType)targetType, (ReferenceType)inputType);
        }
        return targetType;
    }

    public static ReferenceType getHierarchyCompatibleType(ReferenceType targetType, ReferenceType compatibleType) {
        if (targetType instanceof ClassType) {
            return BoundSet.getHierarchyCompatibleType((ClassType)targetType, compatibleType);
        }
        if (targetType instanceof ArrayType && compatibleType instanceof ArrayType) {
            return ((ArrayType)compatibleType).withElementType(BoundSet.getHierarchyCompatibleType(((ArrayType)targetType).getElementType(), ((ArrayType)compatibleType).getElementType()));
        }
        return targetType;
    }

    public static ClassType getHierarchyCompatibleType(ClassType targetType, ReferenceType compatibleType) {
        if (targetType.equals(compatibleType)) {
            return targetType;
        }
        if (!TypeSystem.isGeneric(targetType = targetType.getDeclaration())) {
            return targetType;
        }
        ClassType p = TypeSystem.makeThisType(targetType);
        HashMap<TypeParameter, ReferenceType> mappings = new HashMap<TypeParameter, ReferenceType>();
        for (ReferenceType t : TypeSystem.getCommonDeclaredHierarchy(p, compatibleType)) {
            ClassType c;
            if (!(t instanceof ClassType) || !TypeSystem.isGeneric(c = (ClassType)t)) continue;
            ClassType c1 = TypeSystem.findParameterization(c, p);
            ClassType c2 = TypeSystem.findParameterization(c, compatibleType);
            if (c1 instanceof RawClass || c2 instanceof RawClass) continue;
            TypeSystem.mapTypes(mappings, c1, c2);
        }
        return TypeSubstitutions.subst(p, param -> mappings.getOrDefault(param, WildcardType.createExtends(TypeSystem.objectType(p))));
    }

    public static ReferenceType makeRepresentable(ReferenceType t) {
        return TypeSubstitutions.subst(t, MAKE_REPRESENTABLE);
    }

    protected void assignable(Instruction expr, ReferenceType t) {
        AbstractInvoke invoke;
        if (expr instanceof MethodDecl) {
            MethodDecl decl = (MethodDecl)expr;
            this.assignable(decl, t);
            return;
        }
        if (expr instanceof MethodReference) {
            MethodReference mref = (MethodReference)expr;
            this.assignable(mref, t);
            return;
        }
        ReferenceType resultType = (ReferenceType)expr.getResultType();
        BoundSet polyBounds = null;
        if (expr instanceof AbstractInvoke && BoundSet.isPoly((invoke = (AbstractInvoke)expr).getMethod())) {
            polyBounds = BoundSet.monomorphicBounds(invoke, this::makeNestedBoundSet);
            resultType = (ReferenceType)polyBounds.infVarRetType;
            this.addNestedVars(invoke, polyBounds);
        }
        if (resultType == NullConstantType.INSTANCE) {
            return;
        }
        this.assignable(expr, resultType, t, polyBounds);
    }

    protected void assignable(Instruction expr, ReferenceType resultType, ReferenceType t, @Nullable BoundSet polyBounds) {
        if (resultType instanceof RawClass) {
            this.hasRawArgs = true;
        }
        this.assignable(resultType, t);
    }

    protected abstract BoundSet makeNestedBoundSet(Iterable<TypeParameter> var1, AType var2);

    protected void assignable(MethodDecl lambda, ReferenceType t) {
        if (t instanceof InferenceVar) {
            return;
        }
        Method fMethod = Objects.requireNonNull(t.getFunctionalInterfaceMethod());
        List<Parameter> fParams = fMethod.getParameters();
        ArrayList params = lambda.parameters.filterNot(ParameterVariable::isImplicit).map(LocalVariable::getType).toList();
        assert (fParams.size() == params.size());
        this.lambdaParamsCanReceiveFunctionalInterfaceMethodType(params, fParams);
        if (fMethod.getReturnType() instanceof ReferenceType) {
            ReferenceType retType = (ReferenceType)fMethod.getReturnType();
            this.retTypeAssignable(lambda, BoundSet.upper(retType));
        }
    }

    protected void lambdaParamsCanReceiveFunctionalInterfaceMethodType(List<AType> params, List<Parameter> fParams) {
        for (int i = 0; i < params.size(); ++i) {
            this.assignableStripWildcards(fParams.get(i).getType(), params.get(i));
        }
    }

    protected void retTypeAssignable(MethodDecl lambda, ReferenceType retType) {
        for (Return ret : lambda.getReturns()) {
            this.assignable(ret.getValue(), retType);
        }
    }

    protected void assignable(MethodReference mref, ReferenceType t) {
        boolean instanceTypeIsFirstParam;
        if (t instanceof InferenceVar) {
            return;
        }
        Method fMethod = Objects.requireNonNull(t.getFunctionalInterfaceMethod());
        assert (fMethod.getDeclaration() == mref.getResultType().getDeclaration().getFunctionalInterfaceMethod().getDeclaration());
        if (fMethod.hasTypeParameters()) {
            return;
        }
        List<Parameter> fParams = fMethod.getParameters();
        LinkedList implicitCandidates = BoundSet.getCandidates(mref).toLinkedList();
        boolean isExact = implicitCandidates.size() == 1;
        Method method = mref.getMethod();
        boolean bl = instanceTypeIsFirstParam = !method.isStatic() && !method.isConstructor() && mref.getTarget() instanceof Nop;
        if (!TypeSystem.isFullyDefined(method) || (instanceTypeIsFirstParam || method.isConstructor()) && !TypeSystem.isFullyDefined(method.getDeclaringClass())) {
            return;
        }
        if (isExact) {
            ArrayList params = FastStream.of(method.getParameters()).map(Parameter::getType).toList();
            if (instanceTypeIsFirstParam) {
                params.add(0, method.getDeclaringClass());
            }
            assert (fParams.size() == params.size());
            for (int i = 0; i < params.size(); ++i) {
                this.assignableStripWildcards(fParams.get(i).getType(), (AType)params.get(i));
            }
        } else if (mref.getTarget() instanceof Nop || BoundSet.getCandidates(method.getDeclaringClass(), method.getName()).count() == 1) {
            // empty if block
        }
        if (fMethod.getReturnType() != PrimitiveType.VOID) {
            AType retType = method.isConstructor() ? TypeSystem.makeThisType(method.getDeclaringClass()) : method.getReturnType();
            this.assignableStripWildcards(TypeSystem.capture(retType), fMethod.getReturnType());
        }
    }

    private static FastStream<Method> getCandidates(ReferenceType onType, String name) {
        return FastStream.of(onType.getAllMethods()).filter(e -> e.getName().equals(name));
    }

    private static FastStream<Method> getCandidates(MethodReference mref) {
        return BoundSet.getCandidates(!(mref.getTarget() instanceof Nop) ? (ReferenceType)mref.getTarget().getResultType() : mref.getMethod().getDeclaringClass(), mref.getMethod().getName());
    }

    protected void assignableStripWildcards(AType s, AType t) {
        this.assignable(BoundSet.lower(s), BoundSet.upper(t));
    }

    public static AType upper(AType t) {
        return t instanceof ReferenceType ? BoundSet.upper((ReferenceType)t) : t;
    }

    private static ReferenceType upper(ReferenceType t) {
        if (t instanceof WildcardType) {
            assert (!((WildcardType)t).isSuper());
            t = t.getUpperBound();
        }
        return t;
    }

    public static AType lower(AType t) {
        return t instanceof ReferenceType ? BoundSet.lower((ReferenceType)t) : t;
    }

    public static ReferenceType lower(ReferenceType t) {
        if (t instanceof WildcardType) {
            assert (((WildcardType)t).isSuper());
            t = t.getLowerBound();
        }
        return t;
    }

    private void assignable(AType s, AType t) {
        if (t instanceof PrimitiveType && s instanceof PrimitiveType) {
            assert (TypeSystem.isAssignableTo(s, t));
            return;
        }
        if (s instanceof PrimitiveType) {
            s = TypeSystem.box(TypeSystem.resolver((ReferenceType)t), (PrimitiveType)s);
        }
        if (t instanceof PrimitiveType) {
            t = TypeSystem.box(TypeSystem.resolver((ReferenceType)s), (PrimitiveType)t);
        }
        this.assignable((ReferenceType)s, (ReferenceType)t);
    }

    protected void assignable(ReferenceType s, ReferenceType t) {
        this.subtype(s, t);
    }

    public static <B extends BoundSet> B monomorphicBounds(AbstractInvoke invoke, BiFunction<Iterable<TypeParameter>, AType, B> factory) {
        Method method = invoke.getMethod();
        B b = BoundSet.newBoundSet(invoke, factory);
        for (ReferenceType exception : method.getExceptions()) {
            ((BoundSet)b).constrainThrown(exception);
        }
        IndexedInstructionCollection<Instruction> args = invoke.getArguments();
        List<Parameter> params = method.getParameters();
        for (int i = 0; i < params.size(); ++i) {
            AType type;
            if (args.get(i) instanceof Nop || !BoundSet.mentionsInferrableTypeParam(type = params.get(i).getType(), method)) continue;
            ((BoundSet)b).constrainAssignable(args.get(i), type);
        }
        return b;
    }

    public static <B extends BoundSet> B newBoundSet(AbstractInvoke invoke, BiFunction<Iterable<TypeParameter>, AType, B> factory) {
        Method method = invoke.getMethod();
        Iterable<TypeParameter> variables = BoundSet.getInferrableTypeParams(method);
        AType retType = invoke instanceof New ? BoundSet.retTypeForConstructor(method.getDeclaringClass()) : invoke.getResultType();
        return (B)((BoundSet)factory.apply(variables, retType));
    }

    protected void subtype(ReferenceType s, ReferenceType t) {
        if (t == NullConstantType.INSTANCE) {
            this.fail("Upper bound of null (cannot have a subtype of a type with no lower bound)");
            return;
        }
        if (t instanceof IntersectionType) {
            for (ReferenceType c : t.getDirectSuperTypes()) {
                this.subtype(s, c);
            }
            return;
        }
        if (s instanceof InferenceVar) {
            this.boundsFor((InferenceVar)s).addUpper(t);
        }
        if (t instanceof InferenceVar) {
            this.boundsFor((InferenceVar)t).addLower(s);
        }
        if (s instanceof InferenceVar || t instanceof InferenceVar) {
            return;
        }
        if (s instanceof CapturedTypeVar) {
            this.subtype(s.getUpperBound(), t);
            return;
        }
        if (t instanceof ParameterizedClass) {
            this.argsContainedBy(s, (ParameterizedClass)t);
            return;
        }
        if (t instanceof ArrayType) {
            while (s.getUpperBound() != s) {
                s = s.getUpperBound();
            }
            if (t.equals(s)) {
                return;
            }
            assert (s instanceof ArrayType);
            this.subtype((ReferenceType)((ArrayType)s).getElementType(), (ReferenceType)((ArrayType)t).getElementType());
            return;
        }
        if (!TypeSystem.isAssignableTo(s, t)) {
            this.failProperSubtype(s, t);
        }
    }

    protected void failProperSubtype(ReferenceType s, ReferenceType t) {
        this.fail("Proper types incompatible: " + String.valueOf(s) + " is not a subtype of " + String.valueOf(t));
    }

    private void argsContainedBy(ReferenceType s, ParameterizedClass t) {
        ClassType tOnS = TypeSystem.findParameterizationOrNull(t.getDeclaration(), s);
        if (tOnS == null) {
            this.fail(String.valueOf(s) + " not a subtype of " + String.valueOf(t));
            return;
        }
        if (tOnS instanceof RawClass) {
            return;
        }
        ParameterizedClass p = (ParameterizedClass)tOnS;
        if (t.getOuter() != null) {
            assert (p.getOuter() != null);
            this.argsContainedBy(p.getOuter(), t.getOuter());
        }
        List<ReferenceType> tArgs = t.getTypeArguments();
        List<ReferenceType> sArgs = p.getTypeArguments();
        for (int i = 0; i < tArgs.size(); ++i) {
            ReferenceType tArg = tArgs.get(i);
            ReferenceType sArg = sArgs.get(i);
            this.containedBy(sArg, tArg);
        }
    }

    protected void containedBy(ReferenceType s, ReferenceType t) {
        if (!(t instanceof WildcardType)) {
            this.equal(s, t);
            return;
        }
        if (((WildcardType)t).isSuper()) {
            this.subtype(t.getLowerBound(), s.getLowerBound());
        }
        if (s instanceof WildcardType) {
            s = s.getUpperBound();
        }
        this.subtype(s, t.getUpperBound());
    }

    private void equal(WildcardType s, WildcardType t) {
        if (s.isSuper() == t.isSuper()) {
            this.equal(s.getUpperBound(), t.getUpperBound());
            this.equal(s.getLowerBound(), t.getLowerBound());
            return;
        }
        this.fail(String.valueOf(s) + " not equal to " + String.valueOf(t));
    }

    private void equal(ReferenceType s, ReferenceType t) {
        if (s.equals(t)) {
            return;
        }
        if (s instanceof WildcardType && t instanceof WildcardType) {
            this.equal((WildcardType)s, (WildcardType)t);
            return;
        }
        if (s instanceof WildcardType || t instanceof WildcardType) {
            return;
        }
        if (t instanceof InferenceVar) {
            this.boundsFor((InferenceVar)t).addEqual(s);
        }
        if (s instanceof InferenceVar) {
            this.boundsFor((InferenceVar)s).addEqual(t);
        }
        if (s instanceof InferenceVar || t instanceof InferenceVar) {
            return;
        }
        if (t instanceof ParameterizedClass) {
            ParameterizedClass tParam = (ParameterizedClass)t;
            if (!(s instanceof ParameterizedClass)) {
                this.fail(String.valueOf(s) + " cannot be equal to " + String.valueOf(t));
                return;
            }
            ParameterizedClass sParam = (ParameterizedClass)s;
            if (tParam.getDeclaration() != sParam.getDeclaration()) {
                this.fail(String.valueOf(s) + " cannot be equal to " + String.valueOf(t));
                return;
            }
            List<ReferenceType> tArgs = tParam.getTypeArguments();
            List<ReferenceType> sArgs = sParam.getTypeArguments();
            for (int i = 0; i < tArgs.size(); ++i) {
                this.equal(sArgs.get(i), tArgs.get(i));
            }
            return;
        }
        if (t instanceof ArrayType) {
            if (!(s instanceof ArrayType)) {
                this.fail(String.valueOf(s) + " cannot be equal to " + String.valueOf(t));
                return;
            }
            this.equal((ReferenceType)((ArrayType)s).getElementType(), (ReferenceType)((ArrayType)t).getElementType());
            return;
        }
        this.failProperTypesNotEqual(s, t);
    }

    protected void failProperTypesNotEqual(ReferenceType s, ReferenceType t) {
        this.fail(String.valueOf(s) + " not equal to " + String.valueOf(t));
    }

    protected void fail(String reason) {
        if (this.failure == null) {
            this.failure = reason;
        }
    }

    private void compatibleSupertypes(ReferenceType t1, ReferenceType t2) {
        if (TypeSystem.isObject(t1)) {
            return;
        }
        if (t1 instanceof InferenceVar || t2 instanceof InferenceVar) {
            return;
        }
        for (ReferenceType t : TypeSystem.getCommonDeclaredHierarchy(t1, t2)) {
            ClassType c;
            if (!(t instanceof ClassType) || !TypeSystem.isGeneric(c = (ClassType)t)) continue;
            ClassType c1 = TypeSystem.findParameterization(c, t1);
            ClassType c2 = TypeSystem.findParameterization(c, t2);
            if (c1 instanceof RawClass || c2 instanceof RawClass) continue;
            this.equal(c1, c2);
        }
    }

    private String varNameSuffix() {
        if (this.parent == null) {
            return "";
        }
        return this.parent.varNameSuffix() + this.nestedIndex;
    }

    private static /* synthetic */ ReferenceType lambda$solveFreshUpper$9(Map solution, InferenceVar t) {
        return solution.getOrDefault(t, t);
    }

    protected class InferenceVar
    extends TypeVariable {
        public final String name;
        public final TypeParameter param;

        public InferenceVar(String name, TypeParameter param) {
            this.name = name;
            this.param = param;
        }

        @Override
        public String getName() {
            return this.name + BoundSet.this.varNameSuffix();
        }

        public String toString() {
            return this.getName();
        }

        @Override
        public ReferenceType getUpperBound() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ReferenceType getSuperType() {
            return TypeSystem.objectType(this.param);
        }
    }

    protected static abstract class VarBounds<T> {
        protected final List<T> equalBounds = new ArrayList<T>(6);
        protected final List<T> lowerBounds = new ArrayList<T>(6);
        protected final List<T> upperBounds = new ArrayList<T>(6);
        public boolean thrown;
        private BoundSet root;

        public VarBounds(BoundSet root) {
            this.root = root;
        }

        protected VarBounds(BoundSet root, VarBounds<T> other) {
            this.root = root;
            this.equalBounds.addAll(other.equalBounds);
            this.lowerBounds.addAll(other.lowerBounds);
            this.upperBounds.addAll(other.upperBounds);
            this.thrown = other.thrown;
        }

        protected VarBounds<T> setRoot(BoundSet root) {
            this.root = root;
            return this;
        }

        protected BoundSet getRoot() {
            return this.root;
        }

        protected abstract T makeBound(ReferenceType var1);

        protected abstract ReferenceType getType(T var1);

        protected ReferenceType getResolvedType(T t, TypeSubstitutions.TypeSubstApplier subst) {
            return (ReferenceType)subst.apply(this.getType(t));
        }

        protected boolean dependsOn(T t, InferenceVar v) {
            return this.getType(t).mentions(v);
        }

        protected void boundAdded(T b) {
        }

        protected boolean isEncompassedBy(T b1, T b2) {
            return b1.equals(b2);
        }

        protected <T1, T2> void incorporate(T1 b1, T2 b2, BiConsumer<T1, T2> action) {
            action.accept(b1, b2);
        }

        public final void addEqual(ReferenceType t) {
            T b = this.makeBound(t);
            if (!this.isEncompassedBy(b, this.equalBounds)) {
                this.addEqualBound(b);
            }
        }

        public final void addUpper(ReferenceType t) {
            T b = this.makeBound(t);
            if (!this.isEncompassedBy(b, this.upperBounds)) {
                this.addUpperBound(b);
            }
        }

        public final void addLower(ReferenceType t) {
            T b = this.makeBound(t);
            if (!this.isEncompassedBy(b, this.lowerBounds)) {
                this.addLowerBound(b);
            }
        }

        protected boolean isEncompassedBy(T b, List<T> existingBounds) {
            return ColUtils.anyMatch(existingBounds, b2 -> this.isEncompassedBy(b, b2));
        }

        protected void equal(T t1, T t2) {
            this.root.equal(this.getType(t1), this.getType(t2));
        }

        protected void subtype(T t1, T t2) {
            this.root.subtype(this.getType(t1), this.getType(t2));
        }

        protected void compatibleSupertypes(T t1, T t2) {
            this.root.compatibleSupertypes(this.getType(t1), this.getType(t2));
        }

        protected void addEqualBound(T b) {
            this.add(this.equalBounds, b, (t, equal) -> this.equal(t, equal));
            this.incorporateList(b, this.upperBounds, (t, upper) -> this.subtype(t, upper));
            this.incorporateList(b, this.lowerBounds, (t, lower) -> this.subtype(lower, t));
        }

        protected void addUpperBound(T b) {
            this.add(this.upperBounds, b, (t, upper) -> this.compatibleSupertypes(upper, t));
            this.incorporateList(b, this.equalBounds, (t, equal) -> this.subtype(equal, t));
            this.incorporateList(b, this.lowerBounds, (t, lower) -> this.subtype(lower, t));
        }

        protected void addLowerBound(T b) {
            this.add(this.lowerBounds, b, null);
            this.incorporateList(b, this.equalBounds, (t, equal) -> this.subtype(t, equal));
            this.incorporateList(b, this.upperBounds, (t, upper) -> this.subtype(t, upper));
        }

        protected void add(List<T> bounds, T bound, @Nullable BiConsumer<T, T> func) {
            bounds.add(bound);
            this.boundAdded(bound);
            if (func != null) {
                this.incorporateList(bound, bounds, bounds.size() - 1, func);
            }
        }

        protected <T1, T2> void incorporateList(T1 bound, List<T2> bounds, BiConsumer<T1, T2> func) {
            this.incorporateList(bound, bounds, bounds.size(), func);
        }

        protected <T1, T2> void incorporateList(T1 bound, List<T2> bounds, int count, BiConsumer<T1, T2> func) {
            for (int i = count - 1; i >= 0; --i) {
                this.incorporate(bound, bounds.get(i), func);
            }
        }

        public Iterable<InferenceVar> getDeps() {
            return FastStream.of(this.root.bounds.keySet()).filter(this::dependsOn);
        }

        private boolean dependsOn(InferenceVar v2) {
            return this.activeBounds(this.equalBounds).anyMatch(t -> this.dependsOn(t, v2)) || this.activeBounds(this.upperBounds).anyMatch(t -> this.dependsOn(t, v2)) || this.activeBounds(this.lowerBounds).anyMatch(t -> this.dependsOn(t, v2));
        }

        protected FastStream<T> activeBounds(List<T> list) {
            return FastStream.of(list);
        }

        private FastStream<ReferenceType> resolvedTypes(List<T> list, TypeSubstitutions.TypeSubstApplier subst) {
            return this.activeBounds(list).map(e -> this.getResolvedType(e, subst));
        }

        public FastStream<ReferenceType> equalTypes(TypeSubstitutions.TypeSubstApplier subst) {
            return this.resolvedTypes(this.equalBounds, subst);
        }

        public FastStream<ReferenceType> upperTypes(TypeSubstitutions.TypeSubstApplier subst) {
            return this.resolvedTypes(this.upperBounds, subst);
        }

        public FastStream<ReferenceType> lowerTypes(TypeSubstitutions.TypeSubstApplier subst) {
            return this.resolvedTypes(this.lowerBounds, subst);
        }

        public void reverseUppers() {
            Util.reverse(this.upperBounds);
        }
    }

    protected static class SimpleVarBounds
    extends VarBounds<ReferenceType> {
        public SimpleVarBounds(BoundSet owner) {
            super(owner);
        }

        @Override
        protected ReferenceType makeBound(ReferenceType t) {
            return t;
        }

        @Override
        protected ReferenceType getType(ReferenceType bound) {
            return bound;
        }
    }

    protected static interface InferenceVarMapper
    extends TypeSubstitutions.TypeMapper {
        @Override
        default public ReferenceType mapType(ReferenceType type) {
            return type instanceof InferenceVar ? this.mapParam((InferenceVar)type) : type;
        }

        public ReferenceType mapParam(InferenceVar var1);
    }

    protected static enum ResolutionPhase {
        EQUALS{

            @Override
            @Nullable
            public ReferenceType solve(VarBounds<?> bounds, InferenceVarMapper partialSolution) {
                return (ReferenceType)bounds.equalTypes(partialSolution.substFunc()).filter(BoundSet::isProper).firstOrDefault();
            }
        }
        ,
        LOWER{

            @Override
            @Nullable
            public ReferenceType solve(VarBounds<?> bounds, InferenceVarMapper partialSolution) {
                ReferenceType[] lower = (ReferenceType[])bounds.lowerTypes(partialSolution.substFunc()).filter(BoundSet::isProper).toArray((Object[])new ReferenceType[0]);
                return lower.length > 0 ? TypeSystem.lub(lower) : null;
            }
        }
        ,
        UPPER{

            @Override
            @Nullable
            public ReferenceType solve(VarBounds<?> bounds, InferenceVarMapper partialSolution) {
                ArrayList uppers = bounds.upperTypes(partialSolution.substFunc()).filter(BoundSet::isProper).toList();
                if (!uppers.isEmpty()) {
                    Util.reverse(uppers);
                    ResolutionPhase.checkSingleMostDerivedClassType(uppers);
                    return TypeSystem.glbJavac(uppers);
                }
                return null;
            }
        };


        private static void checkSingleMostDerivedClassType(List<ReferenceType> types) {
            for (int i = 0; i < types.size(); ++i) {
                ReferenceType a = types.get(i);
                for (int j = i; j < types.size(); ++j) {
                    ReferenceType b = types.get(j);
                    if (TypeSystem.isInterface(a) || TypeSystem.isInterface(b) || TypeSystem.isAssignableTo(a, b) || TypeSystem.isAssignableTo(b, a)) continue;
                    throw new ResolveFailedException("Cannot find glb of distinct types " + String.valueOf(a) + " and " + String.valueOf(b));
                }
            }
        }

        @Nullable
        public abstract ReferenceType solve(VarBounds<?> var1, InferenceVarMapper var2);
    }

    protected static class ResolveFailedException
    extends RuntimeException {
        public ResolveFailedException(String message) {
            super(message);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            this.setStackTrace(new StackTraceElement[0]);
            return this;
        }
    }
}

