/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.type;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Function;
import net.covers1624.coffeegrinder.bytecode.AccessFlag;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.type.Parameter;
import net.covers1624.coffeegrinder.type.ReferenceType;
import net.covers1624.coffeegrinder.type.TypeParameter;
import net.covers1624.coffeegrinder.type.TypeSubstitutions;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.util.SneakyUtils;
import org.objectweb.asm.Type;

public class ParameterizedMethod
extends Method {
    private final ClassType outer;
    private final Method prevDecl;
    private final List<TypeParameter> boundTypeParams;
    private final List<ReferenceType> typeArguments;
    private final AType boundReturnType;
    private final List<ReferenceType> boundExceptionTypes;
    private final List<Parameter> parameters;

    public ParameterizedMethod(ClassType outer, Method method, TypeSubstitutions.TypeParamMapper mapper, boolean supplyingArgs) {
        this.outer = outer;
        this.prevDecl = method;
        assert (!(method instanceof ParameterizedMethod) || supplyingArgs && ((ParameterizedMethod)method).getTypeArguments().isEmpty());
        List<TypeParameter> typeParams = method.getTypeParameters();
        if (typeParams.isEmpty()) {
            this.boundTypeParams = ImmutableList.of();
            this.typeArguments = ImmutableList.of();
        } else if (supplyingArgs) {
            this.boundTypeParams = ImmutableList.of();
            this.typeArguments = FastStream.of(typeParams).map((Function)mapper.substFunc()).toImmutableList();
        } else {
            class BoundTypeParameter
            extends TypeParameter {
                ReferenceType upper;

                public BoundTypeParameter(ParameterizedMethod this$0, TypeParameter orig) {
                    super(orig.getName(), orig.getIndex(), this$0);
                    this.upper = orig.getUpperBound();
                }

                @Override
                public ReferenceType getUpperBound() {
                    return this.upper;
                }
            }
            this.typeArguments = ImmutableList.of();
            ImmutableList boundParams = FastStream.of(typeParams).map(orig -> new BoundTypeParameter(this, (TypeParameter)orig)).toImmutableList();
            TypeSubstitutions.TypeParamMapper outer_mapper = mapper;
            mapper = typeParam -> {
                if (typeParam.getOwner() == method) {
                    return (ReferenceType)boundParams.get(typeParam.getIndex());
                }
                return outer_mapper.mapParam(typeParam);
            };
            for (BoundTypeParameter p : boundParams) {
                p.upper = TypeSubstitutions.subst(p.upper, (TypeSubstitutions.TypeMapper)mapper);
            }
            this.boundTypeParams = (List)SneakyUtils.unsafeCast((Object)boundParams);
        }
        this.boundReturnType = TypeSubstitutions.subst(method.getReturnType(), (TypeSubstitutions.TypeMapper)mapper);
        TypeSubstitutions.TypeParamMapper finalMapper = mapper;
        this.parameters = FastStream.of(method.getParameters()).map(e -> new Parameter(e.getName(), this, TypeSubstitutions.subst(e.getType(), (TypeSubstitutions.TypeMapper)finalMapper), e.getRawType(), e.getFlags())).toImmutableList();
        this.boundExceptionTypes = FastStream.of(method.getExceptions()).map(e -> TypeSubstitutions.subst(e, (TypeSubstitutions.TypeMapper)finalMapper)).toImmutableList();
    }

    @Override
    public Type getDescriptor() {
        return this.prevDecl.getDescriptor();
    }

    @Override
    public Object getDefaultAnnotationValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClassType getDeclaringClass() {
        return this.outer;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public AType getReturnType() {
        return this.boundReturnType;
    }

    @Override
    public boolean isConstructor() {
        return this.prevDecl.isConstructor();
    }

    @Override
    public EnumBitSet<AccessFlag> getAccessFlags() {
        return this.prevDecl.getAccessFlags();
    }

    @Override
    public List<ReferenceType> getExceptions() {
        return this.boundExceptionTypes;
    }

    @Override
    public Method getDeclaration() {
        return this.prevDecl.getDeclaration();
    }

    @Override
    public Method asRaw() {
        return this.prevDecl.asRaw();
    }

    @Override
    public String getName() {
        return this.prevDecl.getName();
    }

    public List<ReferenceType> getTypeArguments() {
        return this.typeArguments;
    }

    @Override
    public List<TypeParameter> getTypeParameters() {
        if (!this.typeArguments.isEmpty()) {
            throw new UnsupportedOperationException();
        }
        return this.boundTypeParams;
    }

    @Override
    public boolean hasTypeParameters() {
        return !this.boundTypeParams.isEmpty();
    }

    public boolean isFullyParameterized() {
        return this.getTypeArguments().size() == this.prevDecl.getTypeParameters().size();
    }
}

