package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.*;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.coffeegrinder.util.EnumBitSet;

/**
 * Created by covers1624 on 15/4/21.
 */
@SuppressWarnings ("NotNullFieldNotInitialized")
public final class Invoke extends AbstractInvoke {

    private final InvokeKind kind;
    private final ClassType targetClassType;
    private Method method;

    private AType resultType;

    private final InstructionSlot<Instruction> target = new InstructionSlot<>(this);
    private final IndexedInstructionCollection<Instruction> arguments = new IndexedInstructionCollection<>(this);

    public Invoke(InvokeKind kind, Method method, Instruction target, Iterable<Instruction> args) {
        this(kind, method.getDeclaringClass(), method, target, args);
    }

    public Invoke(InvokeKind kind, ClassType targetClassType, Method method, Instruction target, Iterable<Instruction> args) {
        this.kind = kind;
        this.targetClassType = targetClassType;
        setMethod(method);
        setTarget(target);
        arguments.setValues(args);
    }

    @Override
    public AType getResultType() {
        return resultType;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.MAY_THROW.toSet();
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitInvoke(this, ctx);
    }

    //@formatter:off
    public InvokeKind getKind() { return kind; }
    public ClassType getTargetClassType() { return targetClassType; }
    @Override public Method getMethod() { return method; }
    public Instruction getTarget() { return target.get(); }
    @Override public IndexedInstructionCollection<Instruction> getArguments() { return arguments; }
    public void setTarget(Instruction target) { this.target.set(target); }
    //@formatter:on

    public final void setMethod(Method method) {
        this.method = method;
        setResultType(TypeSystem.capture(method.getReturnType()));
    }

    public void setResultType(AType resultType) {
        this.resultType = resultType;
    }

    public enum InvokeKind {
        VIRTUAL,
        SPECIAL,
        STATIC,
        INTERFACE,
    }
}
