package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;

/**
 * Created by covers1624 on 28/2/21.
 */
public final class LdcBoolean extends LdcInsn {

    private final boolean value;

    public LdcBoolean(boolean value) {
        this.value = value;
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.BOOLEAN;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitLdcBoolean(this, ctx);
    }

    @Override
    public LdcBoolean copy() {
        return new LdcBoolean(value);
    }

    @Override
    public Boolean getRawValue() {
        return value;
    }

    public boolean getValue() {
        return value;
    }
}
