package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.*;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

import static java.util.Objects.requireNonNull;
import static net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching.matchLocalRef;

/**
 * Created by covers1624 on 28/2/21.
 */
public final class Store extends Instruction {

    private final InstructionSlot<Reference> reference = new InstructionSlot<>(this);
    private final InstructionSlot<Instruction> value = new InstructionSlot<>(this);

    public Store(Reference reference, Instruction value) {
        this.reference.set(reference);
        this.value.set(value);
    }

    @Override
    public AType getResultType() {
        return getReference().getType();
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitStore(this, ctx);
    }

    public LocalVariable getVariable() {
        return requireNonNull(matchLocalRef(getReference()), "Not a LocalReference").variable;
    }

    @Override
    protected void onChildModified() {
        super.onChildModified();
        if (isConnected()) {
            getReference().setWrittenTo(true);
        }
    }

    @Override
    protected void onConnected() {
        super.onConnected();
        getReference().setWrittenTo(true);
    }

    public Reference getReference() {
        return reference.get();
    }

    public Instruction getValue() {
        return value.get();
    }
}
