package net.covers1624.coffeegrinder.type;

/**
 * Created by covers1624 on 25/4/22.
 */
public abstract class CapturedTypeVar extends TypeVariable {

    public final TypeParameter orig;
    public final WildcardType wildcard;

    public CapturedTypeVar(TypeParameter orig, WildcardType wildcard) {
        this.orig = orig;
        this.wildcard = wildcard;
    }

    @Override
    public ReferenceType getLowerBound() {
        return wildcard.getLowerBound();
    }

    @Override
    public String getName() {
        return "capture of " + wildcard;
    }

    @Override
    public String toString() {
        return getName();
    }

    public abstract CapturedTypeVar map(TypeSubstitutions.TypeMapper map);
}
