/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionCollection;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.Leave;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;

public final class BlockContainer
extends Instruction {
    public final InstructionCollection<Block> blocks = new InstructionCollection(this);
    private final List<Leave> leaves = new LinkedList<Leave>();
    @Nullable
    private Block entryPoint;

    @Override
    public AType getResultType() {
        throw new UnsupportedOperationException("BlockContainer does not have a result type.");
    }

    @Override
    protected EnumBitSet<InstructionFlag> computeFlags() {
        Object flags = InstructionFlag.NONE.copy();
        Iterator<Block> iterator = this.blocks.iterator();
        while (iterator.hasNext()) {
            Block block = iterator.next();
            ((BitSet)flags).or(block.getFlags());
        }
        if (this.leaves.size() == 0) {
            ((EnumBitSet)flags).set(InstructionFlag.END_POINT_UNREACHABLE);
        } else {
            ((EnumBitSet)flags).clear(InstructionFlag.END_POINT_UNREACHABLE);
        }
        return flags;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    protected void onChildModified() {
        this.setEntryPoint((Block)this.getFirstChildOrNull());
    }

    @Override
    protected void onConnected() {
        super.onConnected();
        if (this.entryPoint != null) {
            this.entryPoint.setEntryPoint(true);
        }
    }

    @Override
    protected void onDisconnected() {
        super.onDisconnected();
        if (this.entryPoint != null) {
            this.entryPoint.setEntryPoint(false);
        }
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitBlockContainer(this, ctx);
    }

    public static BlockContainer findClosestContainer(Instruction insn) {
        while (!(insn instanceof BlockContainer)) {
            insn = insn.getParent();
        }
        return (BlockContainer)insn;
    }

    void addLeave(Leave leave) {
        this.leaves.add(leave);
        this.invalidateFlags();
    }

    void remLeave(Leave leave) {
        this.leaves.remove(leave);
        this.invalidateFlags();
    }

    @Nullable
    public Block getEntryPointOrNull() {
        return this.entryPoint;
    }

    public Block getEntryPoint() {
        return Objects.requireNonNull(this.getEntryPointOrNull());
    }

    public int getLeaveCount() {
        return this.leaves.size();
    }

    public FastStream<Leave> getLeaves() {
        return FastStream.of(this.leaves);
    }

    private void setEntryPoint(@Nullable Block entryPoint) {
        if (this.entryPoint != null && this.isConnected()) {
            this.entryPoint.setEntryPoint(false);
        }
        this.entryPoint = entryPoint;
        if (this.entryPoint != null && this.isConnected()) {
            this.entryPoint.setEntryPoint(true);
        }
    }
}

