/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.matching;

import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.Comparison;
import net.covers1624.coffeegrinder.bytecode.insns.LdcNull;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import org.jetbrains.annotations.Nullable;

public class ComparisonMatching {
    @Nullable
    public static Comparison matchComparison(@Nullable Instruction insn) {
        if (!(insn instanceof Comparison)) {
            return null;
        }
        Comparison comparison = (Comparison)insn;
        return comparison;
    }

    @Nullable
    public static Comparison matchComparison(@Nullable Instruction insn, Comparison.ComparisonKind kind) {
        Comparison comparison = ComparisonMatching.matchComparison(insn);
        if (comparison == null) {
            return null;
        }
        if (comparison.getKind() != kind) {
            return null;
        }
        return comparison;
    }

    @Nullable
    public static Comparison matchComparison(@Nullable Instruction insn, Comparison.ComparisonKind kind, LocalVariable left, LocalVariable right) {
        Comparison comparison = ComparisonMatching.matchComparison(insn, kind);
        if (comparison == null) {
            return null;
        }
        if (LoadStoreMatching.matchLoadLocal(comparison.getLeft(), left) == null) {
            return null;
        }
        if (LoadStoreMatching.matchLoadLocal(comparison.getRight(), right) == null) {
            return null;
        }
        return comparison;
    }

    @Nullable
    public static Comparison matchNotEqualNull(@Nullable Instruction insn, LocalVariable variable) {
        Comparison comparison = ComparisonMatching.matchComparison(insn, Comparison.ComparisonKind.NOT_EQUAL);
        if (comparison == null) {
            return null;
        }
        if (LoadStoreMatching.matchLoadLocal(comparison.getLeft(), variable) == null) {
            return null;
        }
        if (!(comparison.getRight() instanceof LdcNull)) {
            return null;
        }
        return comparison;
    }

    @Nullable
    public static Comparison matchEqualNull(@Nullable Instruction insn, LocalVariable variable) {
        Comparison comparison = ComparisonMatching.matchComparison(insn, Comparison.ComparisonKind.EQUAL);
        if (comparison == null) {
            return null;
        }
        if (LoadStoreMatching.matchLoadLocal(comparison.getLeft(), variable) == null) {
            return null;
        }
        if (!(comparison.getRight() instanceof LdcNull)) {
            return null;
        }
        return comparison;
    }
}

