/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import java.lang.runtime.SwitchBootstraps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.AbstractInvoke;
import net.covers1624.coffeegrinder.bytecode.insns.Cast;
import net.covers1624.coffeegrinder.bytecode.insns.ClassDecl;
import net.covers1624.coffeegrinder.bytecode.insns.DeadCode;
import net.covers1624.coffeegrinder.bytecode.insns.FieldReference;
import net.covers1624.coffeegrinder.bytecode.insns.InstanceOf;
import net.covers1624.coffeegrinder.bytecode.insns.Invoke;
import net.covers1624.coffeegrinder.bytecode.insns.LdcClass;
import net.covers1624.coffeegrinder.bytecode.insns.Load;
import net.covers1624.coffeegrinder.bytecode.insns.LoadThis;
import net.covers1624.coffeegrinder.bytecode.insns.LocalReference;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.New;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.bytecode.insns.ParameterVariable;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.insns.tags.ErrorTag;
import net.covers1624.coffeegrinder.bytecode.matching.InvokeMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.ClassTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.ClassTransformer;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.VariableDeclarations;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.generics.GenericTransform;
import net.covers1624.coffeegrinder.debug.Step;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Field;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.type.Parameter;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

public class LocalClasses
implements ClassTransformer {
    private ClassTransformContext ctx;
    private ClassDecl outer;

    @Override
    public void transform(ClassDecl cInsn, ClassTransformContext ctx) {
        this.ctx = ctx;
        this.outer = cInsn;
        cInsn.getClassMembers().filter(e -> !e.getClazz().isSynthetic() && e.getClazz().getDeclType().isLocalOrAnonymous()).toImmutableList().reverse().forEach(this::process);
    }

    private void process(ClassDecl classDecl) {
        if (classDecl.getClazz().getDeclType() == ClassType.DeclType.ANONYMOUS) {
            this.processAnonClass(classDecl);
        } else {
            this.processLocalClass(classDecl);
        }
    }

    private void processAnonClass(ClassDecl anonClass) {
        FastStream enclosingMembersToSearch;
        ClassType localClazz = anonClass.getClazz();
        if (!localClazz.getEnclosingMethod().isPresent()) {
            enclosingMembersToSearch = FastStream.concat((Iterable[])new Iterable[]{this.outer.getFieldMembers(), FastStream.ofNullable((Object)this.getStaticInit(this.outer))});
        } else {
            Method enclosing = localClazz.getEnclosingMethod().get();
            enclosingMembersToSearch = FastStream.ofNullable((Object)this.outer.findMethod(enclosing));
            if (enclosing.isConstructor() || enclosing.getName().equals("<clinit>")) {
                enclosingMembersToSearch = enclosingMembersToSearch.concat(this.outer.getFieldMembers());
            }
        }
        New construction = (New)enclosingMembersToSearch.flatMap(f -> f.descendantsWhere(e -> LocalClasses.isNew(e, localClazz))).only();
        this.moveAnonClass(anonClass, construction);
    }

    private void processLocalClass(ClassDecl localClass) {
        ClassType localClazz = localClass.getClazz();
        MethodDecl methodInsn = localClazz.getEnclosingMethod().map(this.outer::findMethod).orElseGet(() -> Objects.requireNonNull(this.getStaticInit(this.outer)));
        this.ctx.pushStep(methodInsn.getMethod().getName() + "::" + localClazz.getName(), Step.StepContextType.CLASS);
        LinkedList usages = methodInsn.descendantsToListWhere(e -> this.isUsageOf((Instruction)e, localClazz));
        Optional declPointOpt = FastStream.of(usages).fold(VariableDeclarations::unifyUsages);
        if (!declPointOpt.isPresent()) {
            this.moveUnusedLocalClass(localClass, methodInsn);
            this.ctx.popStep();
            return;
        }
        this.moveLocalClass(localClass, methodInsn, (Instruction)declPointOpt.get());
        if (!localClazz.isInterface() && !localClazz.isEnum()) {
            LinkedList constructions = FastStream.of(usages).filter(e -> LocalClasses.isCtorUsage(e, localClazz)).toLinkedList();
            localClass.descendantsWhere(e -> LocalClasses.isCtorUsage(e, localClazz)).forEach(constructions::add);
            this.replaceSyntheticLocals(localClass, (List)SneakyUtils.unsafeCast((Object)constructions));
        }
        this.ctx.popStep();
    }

    private static boolean isCtorUsage(Instruction insn, ClassType localClazz) {
        return LocalClasses.isNew(insn, localClazz) || InvokeMatching.matchConstructorInvokeSpecial(insn, localClazz) != null;
    }

    @Nullable
    private MethodDecl getStaticInit(ClassDecl outer) {
        return outer.findMethod("<clinit>", Type.getType((String)"()V"));
    }

    private void moveUnusedLocalClass(ClassDecl localClass, MethodDecl methodInsn) {
        this.ctx.pushStep("Inline (unused)");
        methodInsn.getBody().getEntryPoint().instructions.addFirst(new DeadCode(localClass));
        this.ctx.popStep();
    }

    private void moveLocalClass(ClassDecl localClass, MethodDecl methodInsn, Instruction unifiedUsagePoint) {
        while (unifiedUsagePoint.firstAncestorOfType(MethodDecl.class) != methodInsn) {
            unifiedUsagePoint = unifiedUsagePoint.getParent();
        }
        Instruction declPoint = VariableDeclarations.selectDeclarableParent(unifiedUsagePoint);
        this.ctx.pushStep("Inline");
        declPoint.insertBefore(localClass);
        this.ctx.popStep();
    }

    private boolean isUsageOf(Instruction insn, ClassType localClazz) {
        if (LocalClasses.isCtorUsage(insn, localClazz)) {
            return true;
        }
        Instruction instruction = insn;
        Objects.requireNonNull(instruction);
        Instruction instruction2 = instruction;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClassDecl.class, Cast.class, InstanceOf.class, LdcClass.class, LocalVariable.class, LocalReference.class}, (Object)instruction2, n)) {
            case 0 -> {
                ClassDecl cDecl = (ClassDecl)instruction2;
                yield cDecl.getClazz().getDirectSuperTypes().anyMatch(e -> e.mentions(localClazz));
            }
            case 1 -> {
                Cast cast = (Cast)instruction2;
                yield cast.getType().mentions(localClazz);
            }
            case 2 -> {
                InstanceOf ins = (InstanceOf)instruction2;
                yield ins.getType().mentions(localClazz);
            }
            case 3 -> {
                LdcClass ldcClass = (LdcClass)instruction2;
                yield ldcClass.getType().mentions(localClazz);
            }
            case 4 -> {
                LocalVariable lv = (LocalVariable)instruction2;
                if (lv.getKind() == LocalVariable.VariableKind.PARAMETER && this.isUsageOf(lv, localClazz)) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                LocalReference lr = (LocalReference)instruction2;
                if (this.isFirstUsage(lr) && this.isUsageOf(lr.variable, localClazz)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private boolean isFirstUsage(LocalReference insn) {
        return insn.variable.getReferences().get(0) == insn;
    }

    private boolean isUsageOf(LocalVariable var, ClassType decl) {
        AType type = var.getType();
        if (var.getGenericSignature() != null) {
            type = GenericTransform.getVariableGenericType(var, this.ctx.getTypeResolver());
        }
        return type.mentions(decl);
    }

    private void moveAnonClass(ClassDecl anonClass, New construction) {
        this.ctx.pushStep(anonClass.getClazz().getName(), Step.StepContextType.CLASS);
        construction.setAnonymousClassDeclaration(anonClass);
        this.replaceSyntheticLocals(anonClass, Collections.singletonList(construction));
        this.ctx.popStep();
    }

    private static boolean isNew(Instruction insn, ClassType localClazz) {
        if (!(insn instanceof New)) {
            return false;
        }
        New aNew = (New)insn;
        return aNew.getResultType().getDeclaration() == localClazz;
    }

    private void replaceSyntheticLocals(ClassDecl localClass, List<AbstractInvoke> ctorUsages) {
        LinkedList synStores;
        Store synStore;
        LinkedList superCalls = localClass.getMethodMembers().filter(e -> e.getMethod().isConstructor()).map(InvokeMatching::getSuperConstructorCall).filter(Objects::nonNull).toLinkedList();
        assert (!superCalls.isEmpty());
        HashMap<Method, List<AbstractInvoke>> ctorUsageLookup = new HashMap<Method, List<AbstractInvoke>>();
        for (AbstractInvoke invoke : ctorUsages) {
            ctorUsageLookup.computeIfAbsent(invoke.getMethod().getDeclaration(), e -> new LinkedList()).add(invoke);
        }
        while ((synStore = (Store)(synStores = FastStream.of((Iterable)superCalls).map(e -> LoadStoreMatching.matchStoreField(e.getPrevSiblingOrNull())).toLinkedList()).get(0)) != null) {
            Field field = ((FieldReference)synStore.getReference()).getField();
            assert (field.getDeclaringClass() == localClass.getClazz());
            assert (field.isSynthetic());
            assert (FastStream.of((Iterable)synStores).allMatch(e -> LoadStoreMatching.matchStoreField(e, field) != null));
            this.ctx.pushStep(field.getName());
            CapturedVariableProcessor processor = new CapturedVariableProcessor(field, localClass.getClazz(), ctorUsageLookup);
            synStores.forEach(processor::processSynStore);
            if (processor.value == null) {
                assert (ctorUsages.isEmpty());
                processor.value = this.createLocalClassFieldFallback(localClass, field);
            }
            localClass.descendantsMatching(e -> LoadStoreMatching.matchLoadField(e, field)).forEach(e -> e.replaceWith(processor.value.copy()));
            processor.paramUsagesToReplace.forEach(e -> Objects.requireNonNull(LoadStoreMatching.matchLoad(e.getParent())).replaceWith(processor.value.copy()));
            Objects.requireNonNull(localClass.findField(field)).remove();
            this.ctx.popStep();
        }
        if (localClass.getClazz().isEnum()) {
            return;
        }
        localClass.getMethodMembers().filter(e -> e.getMethod().isConstructor()).forEach(ctor -> {
            Iterator iterator = ctor.parameters.iterator();
            while (iterator.hasNext()) {
                ParameterVariable pVar = (ParameterVariable)iterator.next();
                Parameter par = pVar.parameter;
                if (pVar.isImplicit() || !par.isMandated() && !par.isSynthetic()) continue;
                CapturedVariableProcessor processor = new CapturedVariableProcessor(null, localClass.getClazz(), ctorUsageLookup);
                processor.traceAndRemoveSynParam((MethodDecl)ctor, pVar);
                if (processor.value == null) {
                    processor.value = this.createLocalClassFieldFallbackNoField(pVar);
                }
                processor.paramUsagesToReplace.forEach(e -> Objects.requireNonNull(LoadStoreMatching.matchLoad(e.getParent())).replaceWith(processor.value.copy()));
            }
        });
    }

    private Instruction createLocalClassFieldFallback(ClassDecl localClass, Field field) {
        if (field.getName().endsWith("this$0")) {
            return new LoadThis((ClassType)field.getType());
        }
        if (field.getName().startsWith("val$")) {
            String name = field.getName().substring("val$".length());
            MethodDecl method = localClass.firstAncestorOfType(MethodDecl.class);
            FastStream localVars = FastStream.concat((Iterable[])new Iterable[]{method.parameters, method.variables});
            LinkedList vars = localVars.filter(v -> v.getName().equals(name)).toLinkedList();
            if (vars.size() == 1) {
                return new Load(new LocalReference((LocalVariable)vars.get(0)));
            }
        }
        Nop err = new Nop();
        err.setTag(new ErrorTag("unmatched synthetic", field.getName()));
        return err;
    }

    private Instruction createLocalClassFieldFallbackNoField(ParameterVariable pVar) {
        if (pVar.getName().endsWith("this$0")) {
            return new LoadThis((ClassType)pVar.getType());
        }
        Nop err = new Nop();
        err.setTag(new ErrorTag("unmatched synthetic", pVar.getName()));
        return err;
    }

    public static class CapturedVariableProcessor {
        @Nullable
        private final Field field;
        private final ClassType localClass;
        private final Map<Method, List<AbstractInvoke>> ctorUsageLookup;
        private final List<LocalReference> paramUsagesToReplace = new LinkedList<LocalReference>();
        @Nullable
        private Instruction value;

        public CapturedVariableProcessor(@Nullable Field field, ClassType localClass, Map<Method, List<AbstractInvoke>> ctorUsageLookup) {
            this.field = field;
            this.localClass = localClass;
            this.ctorUsageLookup = ctorUsageLookup;
        }

        private void processSynStore(Store synStore) {
            MethodDecl ctor = CapturedVariableProcessor.getContainingFunction(synStore);
            ParameterVariable param = (ParameterVariable)Objects.requireNonNull(LoadStoreMatching.matchLoadLocal(synStore.getValue())).getVariable();
            synStore.remove();
            this.traceAndRemoveSynParam(ctor, param);
        }

        private boolean processThisCtorCall(Instruction insn, int paramIdx) {
            Invoke thisCtorCall = InvokeMatching.matchConstructorInvokeSpecial(insn, this.localClass);
            if (thisCtorCall == null) {
                return false;
            }
            MethodDecl ctor = CapturedVariableProcessor.getContainingFunction(thisCtorCall);
            if (ctor.getMethod().getDeclaringClass() != this.localClass) {
                return false;
            }
            Load passThrough = Objects.requireNonNull(LoadStoreMatching.matchLoadLocal(thisCtorCall.getArguments().get(paramIdx)));
            ParameterVariable param = (ParameterVariable)passThrough.getVariable();
            passThrough.replaceWith(new Nop());
            this.traceAndRemoveSynParam(ctor, param);
            return true;
        }

        private void traceAndRemoveSynParam(MethodDecl ctor, ParameterVariable param) {
            param.makeImplicit();
            assert (param.getStoreCount() == 0);
            this.paramUsagesToReplace.addAll(param.getReferences());
            List<AbstractInvoke> usages = this.ctorUsageLookup.get(ctor.getMethod());
            if (usages == null) {
                return;
            }
            for (AbstractInvoke call : usages) {
                boolean isCtorParamReuse;
                if (this.processThisCtorCall(call, param.pIndex)) continue;
                Instruction value = call.getArguments().get(param.pIndex);
                Load localRef = LoadStoreMatching.matchLoadLocal(value);
                boolean bl = isCtorParamReuse = localRef != null && this.paramUsagesToReplace.remove((LocalReference)localRef.getReference());
                if (!isCtorParamReuse) {
                    this.addValue(value);
                }
                if (this.localClass.getDeclType() == ClassType.DeclType.ANONYMOUS && param.pIndex == 0 && value instanceof LoadThis) {
                    if (param.getLoadCount() != 0 && TypeSystem.isConstructedViaTargetInstance(this.localClass)) {
                        return;
                    }
                    ((New)call).hasEnclosingScopeInstanceParam = true;
                }
                value.replaceWith(new Nop());
            }
        }

        private void addValue(Instruction value) {
            if (this.value == null) {
                this.value = value;
                assert (!this.isSyntheticReuse(value));
            } else assert (this.isSyntheticReuse(value) || CapturedVariableProcessor.loadTargetEqual(this.value, value));
        }

        private static boolean loadTargetEqual(Instruction value1, Instruction value2) {
            boolean bl;
            Instruction instruction = value1;
            Objects.requireNonNull(instruction);
            Instruction instruction2 = instruction;
            int n = 0;
            block4: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LoadThis.class, Load.class}, (Object)instruction2, n)) {
                    case 0: {
                        LoadThis v1 = (LoadThis)instruction2;
                        if (!(value2 instanceof LoadThis)) {
                            n = 1;
                            continue block4;
                        }
                        LoadThis v2 = (LoadThis)value2;
                        bl = v1.getType().equals(v2.getType());
                        break block4;
                    }
                    case 1: {
                        Load l1 = (Load)instruction2;
                        if (!(value2 instanceof Load)) {
                            n = 2;
                            continue block4;
                        }
                        Load l2 = (Load)value2;
                        Load load1 = LoadStoreMatching.matchLoadLocal(l1);
                        Load load2 = LoadStoreMatching.matchLoadLocal(l2);
                        if (load1 != null && load2 != null && load1.getVariable() == load2.getVariable()) {
                            bl = true;
                            break block4;
                        }
                        bl = false;
                        break block4;
                    }
                    default: {
                        bl = false;
                        break block4;
                    }
                }
                break;
            }
            return bl;
        }

        private boolean isSyntheticReuse(Instruction value) {
            return this.field != null && LoadStoreMatching.matchLoadField(value, this.field) != null;
        }

        private static MethodDecl getContainingFunction(Instruction insn) {
            return (MethodDecl)insn.getParent().getParent().getParent();
        }
    }
}

