/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.flow.ControlFlowNode;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.Branch;
import net.covers1624.coffeegrinder.bytecode.insns.LdcBoolean;
import net.covers1624.coffeegrinder.bytecode.insns.WhileLoop;
import net.covers1624.coffeegrinder.bytecode.transform.BlockTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.BlockTransformer;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.TransformerUtils;
import net.covers1624.quack.collection.ColUtils;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;

public class LoopDetection
implements BlockTransformer {
    @Override
    public void transform(Block block, BlockTransformContext ctx) {
        assert (block.getParentOrNull() == ctx.getControlFlowGraph().container);
        ControlFlowNode head = ctx.getControlFlowNode();
        assert (head.block == block);
        LinkedList<Block> backEdges = null;
        for (ControlFlowNode n : head.getPredecessors()) {
            if (!head.dominates(n)) continue;
            if (backEdges == null) {
                backEdges = new LinkedList<Block>();
            }
            backEdges.add(n.getBlock());
        }
        if (backEdges == null) {
            return;
        }
        LinkedList<Block> loop = new LinkedList<Block>();
        Block exitPoint = LoopDetection.extendLoop(head, loop, backEdges);
        ctx.pushTiming("Construct loop");
        this.constructLoop(loop, exitPoint);
        ctx.popTiming();
    }

    private static FastStream<Block> getDominanceFrontier(ControlFlowNode root, Predicate<Block> p) {
        return FastStream.of(root.getDominatorTreeChildren()).flatMap(c -> p.test(c.getBlock()) ? FastStream.of((Object)c.getBlock()) : LoopDetection.getDominanceFrontier(c, p));
    }

    @Nullable
    private static Block extendLoop(ControlFlowNode entryPoint, List<Block> loop, List<Block> backEdges) {
        Block lastBlock;
        Block lastBackEdge;
        BlockContainer container = (BlockContainer)entryPoint.getBlock().getParent();
        Block goodExit = (Block)LoopDetection.getDominanceFrontier(entryPoint, arg_0 -> LoopDetection.lambda$extendLoop$1(container, lastBackEdge = (Block)ColUtils.requireMaxBy(backEdges, Instruction::getBytecodeOffset), arg_0)).maxByOrDefault(Instruction::getBytecodeOffset);
        Block block = lastBlock = goodExit != null ? (Block)goodExit.getPrevSibling() : lastBackEdge;
        while (lastBlock.getParent() != container) {
            lastBlock = lastBlock.getParent().firstAncestorOfType(Block.class);
        }
        Block b = entryPoint.getBlock();
        while (true) {
            loop.add(b);
            if (b == lastBlock) break;
            b = (Block)b.getNextSibling();
        }
        return goodExit;
    }

    private void constructLoop(List<Block> blocks, @Nullable Block exitTargetBlock) {
        Block oldEntryPoint = blocks.remove(0);
        BlockContainer fromContainer = (BlockContainer)oldEntryPoint.getParent();
        assert (oldEntryPoint.getBytecodeOffset() >= 0);
        WhileLoop whileLoop = (WhileLoop)new WhileLoop(new BlockContainer(), new LdcBoolean(true)).withOffsets(oldEntryPoint);
        BlockContainer loopContainer = whileLoop.getBody();
        Block newEntryPoint = (Block)new Block(oldEntryPoint.getSubName("loop")).withOffsets(oldEntryPoint);
        newEntryPoint.instructions.addAll((Iterable<Instruction>)((Object)oldEntryPoint.instructions));
        blocks.add(0, newEntryPoint);
        oldEntryPoint.instructions.add(whileLoop);
        if (exitTargetBlock != null) {
            oldEntryPoint.instructions.add(new Branch(exitTargetBlock));
        }
        TransformerUtils.moveBlocksIntoContainer(blocks, fromContainer, loopContainer, exitTargetBlock);
        for (Branch branch : oldEntryPoint.getBranches().toList()) {
            if (!branch.isDescendantOf(loopContainer)) continue;
            branch.replaceWith(new Branch(newEntryPoint).withOffsets(branch));
        }
    }

    private static /* synthetic */ boolean lambda$extendLoop$1(BlockContainer container, Block lastBackEdge, Block b) {
        return b.getParent() == container && b.getBytecodeOffset() > lastBackEdge.getBytecodeOffset();
    }
}

