/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers.generics;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.Cast;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.MethodReference;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.generics.BoundSet;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ArrayType;
import net.covers1624.coffeegrinder.type.CapturedTypeVar;
import net.covers1624.coffeegrinder.type.ReferenceType;
import net.covers1624.coffeegrinder.type.TypeParameter;
import net.covers1624.coffeegrinder.type.TypeSubstitutions;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.coffeegrinder.type.WildcardType;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;

public class TypeHintBoundSet
extends BoundSet {
    private boolean resolved;

    public TypeHintBoundSet(Iterable<TypeParameter> typeParameters, AType retType) {
        super(typeParameters, retType);
        for (TypeParameter param : typeParameters) {
            this.boundsFor(param).defaultBoundsAdded();
        }
    }

    @Override
    protected BoundSet.InferenceVarMapper solve() {
        this.resolved = true;
        return super.solve();
    }

    @Override
    protected void assignable(Instruction expr, ReferenceType t) {
        if (expr instanceof Cast) {
            Cast cast = (Cast)expr;
            this.assignable(cast.getArgument(), t);
            return;
        }
        super.assignable(expr, t);
    }

    @Override
    protected void subtype(ReferenceType s, ReferenceType t) {
        if (s instanceof BoundSet.InferenceVar) {
            this.boundsFor((BoundSet.InferenceVar)s).incorporateDelayedAssignables(t);
        } else {
            if (t instanceof ArrayType && !(s instanceof ArrayType)) {
                return;
            }
            if (t instanceof WildcardType) {
                return;
            }
        }
        super.subtype(s, t);
    }

    @Override
    protected void retTypeAssignable(MethodDecl lambda, ReferenceType retType) {
    }

    @Override
    protected void assignable(MethodDecl lambda, ReferenceType t) {
        if (t instanceof TypeParameter) {
            return;
        }
        if (t instanceof BoundSet.InferenceVar) {
            this.boundsFor((BoundSet.InferenceVar)t).assigned(lambda);
        }
        super.assignable(lambda, t);
    }

    @Override
    protected void assignable(MethodReference mref, ReferenceType t) {
        if (t instanceof BoundSet.InferenceVar) {
            this.boundsFor((BoundSet.InferenceVar)t).assigned(mref);
        }
        super.assignable(mref, t);
    }

    @Override
    protected void failProperSubtype(ReferenceType s, ReferenceType t) {
    }

    @Override
    protected void failProperTypesNotEqual(ReferenceType s, ReferenceType t) {
    }

    @Override
    protected Map<BoundSet.InferenceVar, ReferenceType> solveVars(List<BoundSet.InferenceVar> vars, BoundSet.InferenceVarMapper solved) {
        Map<BoundSet.InferenceVar, ReferenceType> solution = this.solvePhases(vars, solved);
        for (BoundSet.InferenceVar var : vars) {
            solution.putIfAbsent(var, WildcardType.createExtends(TypeSystem.objectType(var)));
        }
        return solution;
    }

    @Override
    @Nullable
    protected ReferenceType solvePhase(BoundSet.ResolutionPhase phase, BoundSet.VarBounds<?> bounds, BoundSet.InferenceVarMapper solved) {
        ReferenceType upper;
        TypeHintVarBounds hintBounds = (TypeHintVarBounds)bounds;
        assert (hintBounds.wildcardSolution == null);
        ReferenceType t = super.solvePhase(phase, bounds, solved);
        if (t == null) {
            return null;
        }
        hintBounds.wildcardSolution = phase == BoundSet.ResolutionPhase.LOWER ? ((upper = this.solvePhase(BoundSet.ResolutionPhase.UPPER, bounds, solved)) == null || TypeSystem.isObject(upper) ? WildcardType.createSuper(t) : new WildcardType(this, upper, t){

            @Override
            public String getFullName() {
                return "TypeHint Wildcard[" + super.getFullName() + " extends " + this.getUpperBound().getFullName() + "]";
            }
        }) : (phase == BoundSet.ResolutionPhase.UPPER ? WildcardType.createExtends(t) : t);
        return t;
    }

    @Nullable
    public ReferenceType solveAndApplyTo(ReferenceType type) {
        BoundSet.InferenceVarMapper sln;
        if (this.failure != null) {
            return null;
        }
        try {
            sln = this.solve();
        }
        catch (BoundSet.ResolveFailedException ex) {
            return null;
        }
        TypeSubstitutions.TypeParamMapper mapper = p -> {
            BoundSet.InferenceVar var = (BoundSet.InferenceVar)this.vars.get(p);
            if (var == null) {
                return p;
            }
            ReferenceType r = sln.mapParam(var);
            if (r instanceof CapturedTypeVar) {
                r = WildcardType.createExtends(TypeSystem.objectType(r));
            }
            if (!(r instanceof WildcardType)) {
                r = Objects.requireNonNull(this.boundsFor((TypeParameter)p).wildcardSolution);
            }
            return r;
        };
        type = TypeSubstitutions.subst(type, (TypeSubstitutions.TypeMapper)mapper);
        if (type instanceof WildcardType) {
            return type.getUpperBound();
        }
        return type;
    }

    protected TypeHintVarBounds newVarBounds() {
        return new TypeHintVarBounds(this);
    }

    protected TypeHintVarBounds boundsFor(BoundSet.InferenceVar var) {
        return (TypeHintVarBounds)super.boundsFor(var);
    }

    protected TypeHintVarBounds boundsFor(TypeParameter param) {
        return (TypeHintVarBounds)super.boundsFor(param);
    }

    @Override
    protected BoundSet makeNestedBoundSet(Iterable<TypeParameter> vars, AType retType) {
        return new TypeHintBoundSet(vars, retType);
    }

    private static class TypeHintVarBounds
    extends BoundSet.SimpleVarBounds {
        private int nDefaultEq = 0;
        private int nDefaultUpper = 0;
        private int nDefaultLower = 0;
        private final List<BiConsumer<TypeHintBoundSet, ReferenceType>> delayedAssignables = new ArrayList<BiConsumer<TypeHintBoundSet, ReferenceType>>(0);
        @Nullable
        public ReferenceType wildcardSolution;

        public TypeHintVarBounds(TypeHintBoundSet owner) {
            super(owner);
        }

        @Override
        public TypeHintBoundSet getRoot() {
            return (TypeHintBoundSet)super.getRoot();
        }

        @Override
        public FastStream<ReferenceType> equalTypes(TypeSubstitutions.TypeSubstApplier subst) {
            return super.equalTypes(subst).skip(this.getRoot().resolved ? this.nDefaultEq : 0);
        }

        @Override
        public FastStream<ReferenceType> upperTypes(TypeSubstitutions.TypeSubstApplier subst) {
            return super.upperTypes(subst).skip(this.getRoot().resolved ? this.nDefaultUpper : 0);
        }

        @Override
        public FastStream<ReferenceType> lowerTypes(TypeSubstitutions.TypeSubstApplier subst) {
            return super.lowerTypes(subst).skip(this.getRoot().resolved ? this.nDefaultLower : 0);
        }

        public void defaultBoundsAdded() {
            this.nDefaultEq = this.equalBounds.size();
            this.nDefaultUpper = this.upperBounds.size();
            this.nDefaultLower = this.lowerBounds.size();
        }

        public void assigned(MethodReference mref) {
            this.delayedAssignables.add((b, t) -> b.assignable(mref, (ReferenceType)t));
        }

        public void assigned(MethodDecl lambda) {
            this.delayedAssignables.add((b, t) -> b.assignable(lambda, (ReferenceType)t));
        }

        public void incorporateDelayedAssignables(ReferenceType t) {
            for (BiConsumer<TypeHintBoundSet, ReferenceType> f : this.delayedAssignables) {
                f.accept(this.getRoot(), t);
            }
        }
    }
}

