/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers.statement;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.ArrayElementReference;
import net.covers1624.coffeegrinder.bytecode.insns.Binary;
import net.covers1624.coffeegrinder.bytecode.insns.BinaryOp;
import net.covers1624.coffeegrinder.bytecode.insns.CompoundAssignment;
import net.covers1624.coffeegrinder.bytecode.insns.FieldReference;
import net.covers1624.coffeegrinder.bytecode.insns.LdcNumber;
import net.covers1624.coffeegrinder.bytecode.insns.Load;
import net.covers1624.coffeegrinder.bytecode.insns.LocalReference;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.bytecode.insns.PostIncrement;
import net.covers1624.coffeegrinder.bytecode.insns.Reference;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.insns.tags.IIncTag;
import net.covers1624.coffeegrinder.bytecode.matching.AssignmentMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LdcMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformer;
import org.jetbrains.annotations.Nullable;

public class AssignmentExpressions
implements StatementTransformer {
    private StatementTransformContext ctx;

    @Override
    public void transform(Instruction statement, StatementTransformContext ctx) {
        this.ctx = ctx;
        Store store = LoadStoreMatching.matchStoreLocal(statement);
        if (store == null || store.getVariable().getKind() != LocalVariable.VariableKind.STACK_SLOT) {
            return;
        }
        if (this.transformPostIncrementFromIinc(store)) {
            return;
        }
        if (this.transformPostIncrement(store)) {
            this.transform(store, ctx);
            return;
        }
        if (this.transformAssignmentExpression(store)) {
            this.transform(store, ctx);
            return;
        }
        this.tagPotentialIincInline(store);
    }

    private void tagPotentialIincInline(Store store) {
        Load load = LoadStoreMatching.matchLoadLocal(store.getValue());
        if (load == null || load.getVariable().getKind() == LocalVariable.VariableKind.STACK_SLOT) {
            return;
        }
        CompoundAssignment iinc = AssignmentExpressions.matchIInc(store.getPrevSiblingOrNull(), load.getVariable());
        if (iinc == null) {
            return;
        }
        assert (iinc.getTag() != null);
        ((IIncTag)iinc.getTag()).potentialInline = load;
    }

    private boolean transformPostIncrementFromIinc(Store store) {
        Load load = LoadStoreMatching.matchLoadLocal(store.getValue());
        if (load == null) {
            return false;
        }
        CompoundAssignment compoundAssignment = AssignmentExpressions.matchIInc(store.getNextSiblingOrNull(), load.getVariable());
        if (compoundAssignment == null) {
            return false;
        }
        LdcNumber ldc = (LdcNumber)compoundAssignment.getValue();
        if (ldc.intValue() != 1) {
            return false;
        }
        this.ctx.pushStep("Create post increment " + store.getVariable().getUniqueName());
        compoundAssignment.remove();
        load.replaceWith(new PostIncrement(load.getReference(), compoundAssignment.getOp() == BinaryOp.ADD));
        this.ctx.popStep();
        return true;
    }

    public boolean transformPostIncrement(Store store) {
        Load load = LoadStoreMatching.matchLoad(store.getValue());
        if (load == null) {
            return false;
        }
        Store store2 = LoadStoreMatching.matchStore(store.getNextSiblingOrNull());
        if (store2 == null) {
            return false;
        }
        Reference reference = load.getReference();
        if (!AssignmentExpressions.equivalentRefs(reference, store2.getReference())) {
            return false;
        }
        Binary numeric = AssignmentMatching.matchStoreArgBinaryWithPossibleCast(store2);
        if (numeric == null || numeric.getOp() != BinaryOp.ADD && numeric.getOp() != BinaryOp.SUB) {
            return false;
        }
        if (LoadStoreMatching.matchLoadLocal(numeric.getLeft(), store.getVariable()) == null) {
            return false;
        }
        LdcNumber ldc = LdcMatching.matchLdcNumber(numeric.getRight());
        if (ldc == null) {
            return false;
        }
        double value = ldc.getValue().doubleValue();
        if (Math.abs(value) != 1.0) {
            return false;
        }
        this.ctx.pushStep("Create post increment " + store.getVariable().getUniqueName());
        store2.remove();
        load.replaceWith(new PostIncrement(reference, value > 0.0 == (numeric.getOp() == BinaryOp.ADD)));
        this.ctx.popStep();
        return true;
    }

    public boolean transformAssignmentExpression(Store store) {
        LocalVariable storeVariable = store.getVariable();
        if (storeVariable.getLoadCount() == 1) {
            return false;
        }
        Store store2 = LoadStoreMatching.matchStore(store.getNextSiblingOrNull());
        if (store2 == null) {
            return false;
        }
        if (LoadStoreMatching.matchLoadLocal(store2.getValue(), storeVariable) == null) {
            return false;
        }
        this.ctx.pushStep("Create assignment expression " + storeVariable.getUniqueName());
        storeVariable.setType(store2.getResultType());
        store.getValue().replaceWith(new Store(store2.getReference(), store.getValue()));
        store2.remove();
        this.ctx.popStep();
        return true;
    }

    public static boolean equivalentRefs(Reference ref1, Reference ref2) {
        boolean bl;
        Reference reference = ref1;
        Objects.requireNonNull(reference);
        Reference reference2 = reference;
        int n = 0;
        block5: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LocalReference.class, FieldReference.class, ArrayElementReference.class}, (Object)reference2, n)) {
                case 0: {
                    LocalReference r1 = (LocalReference)reference2;
                    if (!(ref2 instanceof LocalReference)) {
                        n = 1;
                        continue block5;
                    }
                    LocalReference r2 = (LocalReference)ref2;
                    if (r1.variable == r2.variable) {
                        bl = true;
                        break block5;
                    }
                    bl = false;
                    break block5;
                }
                case 1: {
                    FieldReference r1 = (FieldReference)reference2;
                    if (!(ref2 instanceof FieldReference)) {
                        n = 2;
                        continue block5;
                    }
                    FieldReference r2 = (FieldReference)ref2;
                    bl = AssignmentExpressions.equivalentRefs(r1, r2);
                    break block5;
                }
                case 2: {
                    ArrayElementReference r1 = (ArrayElementReference)reference2;
                    if (!(ref2 instanceof ArrayElementReference)) {
                        n = 3;
                        continue block5;
                    }
                    ArrayElementReference r2 = (ArrayElementReference)ref2;
                    bl = AssignmentExpressions.equivalentRefs(r1, r2);
                    break block5;
                }
                default: {
                    bl = false;
                    break block5;
                }
            }
            break;
        }
        return bl;
    }

    private static boolean equivalentRefs(FieldReference ref1, FieldReference ref2) {
        return LoadStoreMatching.equivalentFieldDescriptors(ref1.getField(), ref2.getField()) && AssignmentExpressions.equivalentSimpleValues(ref1.getTarget(), ref2.getTarget());
    }

    private static boolean equivalentRefs(ArrayElementReference ref1, ArrayElementReference ref2) {
        return AssignmentExpressions.equivalentSimpleValues(ref1.getArray(), ref2.getArray()) && AssignmentExpressions.equivalentSimpleValues(ref1.getIndex(), ref2.getIndex());
    }

    private static boolean equivalentSimpleValues(Instruction insn1, Instruction insn2) {
        if (insn1.getClass() != insn2.getClass()) {
            return false;
        }
        if (insn1 instanceof Nop) {
            return true;
        }
        if (insn1 instanceof Load) {
            LocalReference localRef1 = LoadStoreMatching.matchLocalRef(((Load)insn1).getReference());
            LocalReference localRef2 = LoadStoreMatching.matchLocalRef(((Load)insn2).getReference());
            return localRef1 != null && localRef2 != null && localRef1.variable == localRef2.variable;
        }
        return false;
    }

    @Nullable
    public static CompoundAssignment matchIInc(@Nullable Instruction insn, LocalVariable variable) {
        if (!(insn instanceof CompoundAssignment)) {
            return null;
        }
        CompoundAssignment compoundAssignment = (CompoundAssignment)insn;
        if (!(insn.getTag() instanceof IIncTag)) {
            return null;
        }
        if (LoadStoreMatching.matchLocalRef(compoundAssignment.getReference(), variable) == null) {
            return null;
        }
        return compoundAssignment;
    }
}

