/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.type;

import java.util.List;
import java.util.function.Function;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ArrayType;
import net.covers1624.coffeegrinder.type.CapturedTypeVar;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Field;
import net.covers1624.coffeegrinder.type.IntersectionType;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.type.NullConstantType;
import net.covers1624.coffeegrinder.type.ParameterizedClass;
import net.covers1624.coffeegrinder.type.ParameterizedField;
import net.covers1624.coffeegrinder.type.ParameterizedMethod;
import net.covers1624.coffeegrinder.type.ReferenceType;
import net.covers1624.coffeegrinder.type.TypeParameter;
import net.covers1624.coffeegrinder.type.TypeVariable;
import net.covers1624.coffeegrinder.type.WildcardType;
import net.covers1624.quack.collection.FastStream;

public class TypeSubstitutions {
    public static AType subst(AType type, TypeMapper mapper) {
        if (type instanceof ReferenceType) {
            return TypeSubstitutions.subst((ReferenceType)type, mapper);
        }
        return type;
    }

    public static ReferenceType subst(ReferenceType type, TypeMapper mapper) {
        if (type == NullConstantType.INSTANCE) {
            return type;
        }
        boolean wasTypeParam = type instanceof TypeParameter;
        type = mapper.mapType(type);
        if (wasTypeParam) {
            return type;
        }
        if (type instanceof CapturedTypeVar) {
            return ((CapturedTypeVar)type).map(mapper);
        }
        if (type instanceof TypeVariable) {
            return type;
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            if (!(arrayType.getElementType() instanceof ReferenceType)) {
                return arrayType;
            }
            ReferenceType elemType = TypeSubstitutions.subst((ReferenceType)arrayType.getElementType(), mapper);
            return arrayType.withElementType(elemType instanceof WildcardType ? elemType.getUpperBound() : elemType);
        }
        if (type instanceof WildcardType) {
            WildcardType wildcard = (WildcardType)type;
            ReferenceType upper = TypeSubstitutions.subst(wildcard.getUpperBound(), mapper);
            ReferenceType lower = TypeSubstitutions.subst(wildcard.getLowerBound(), mapper);
            return new WildcardType(upper instanceof WildcardType ? upper.getUpperBound() : upper, lower instanceof WildcardType ? lower.getLowerBound() : lower);
        }
        if (type instanceof IntersectionType) {
            IntersectionType intersection = (IntersectionType)type;
            return new IntersectionType(intersection.baseType == null ? null : TypeSubstitutions.subst(intersection.baseType, mapper), (List<ClassType>)FastStream.of(intersection.getInterfaces()).map(type1 -> TypeSubstitutions.subst(type1, mapper)).toImmutableList());
        }
        return TypeSubstitutions.subst((ClassType)type, mapper);
    }

    public static ClassType subst(ClassType type, TypeMapper mapper) {
        if (type instanceof ParameterizedClass) {
            ParameterizedClass pClass = (ParameterizedClass)type;
            return new ParameterizedClass(pClass.getOuter() == null ? null : (ParameterizedClass)TypeSubstitutions.subst(pClass.getOuter(), mapper), pClass.getDeclaration(), (List<ReferenceType>)FastStream.of(pClass.getTypeArguments()).map(e -> TypeSubstitutions.subst(e, mapper)).toImmutableList());
        }
        return type;
    }

    public static Field applyOwnerParameterization(ParameterizedClass owner, Field field) {
        if (field.isStatic()) {
            return field;
        }
        AType boundType = TypeSubstitutions.subst(field.getType(), (TypeMapper)owner);
        if (boundType == field.getType()) {
            return field;
        }
        return new ParameterizedField(owner, field, boundType);
    }

    public static Method applyOwnerParameterization(ParameterizedClass owner, Method method) {
        if (method.isStatic()) {
            return method;
        }
        assert (method == method.getDeclaration());
        return new ParameterizedMethod(owner, method, owner, false);
    }

    public static Method parameterize(ClassType owner, Method method, TypeParamMapper mapper) {
        return new ParameterizedMethod(owner, method, mapper, true);
    }

    public static interface TypeMapper {
        public ReferenceType mapType(ReferenceType var1);

        default public TypeSubstApplier substFunc() {
            return t -> TypeSubstitutions.subst(t, this);
        }
    }

    public static interface TypeParamMapper
    extends TypeMapper {
        @Override
        default public ReferenceType mapType(ReferenceType type) {
            return type instanceof TypeParameter ? this.mapParam((TypeParameter)type) : type;
        }

        public ReferenceType mapParam(TypeParameter var1);
    }

    public static interface TypeSubstApplier
    extends Function<ReferenceType, ReferenceType> {
        public static final TypeSubstApplier NONE = e -> e;
    }
}

