/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.type.asm;

import java.lang.annotation.ElementType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.covers1624.coffeegrinder.bytecode.AccessFlag;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.AnnotationData;
import net.covers1624.coffeegrinder.type.AnnotationSupplier;
import net.covers1624.coffeegrinder.type.ArrayType;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Field;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.type.Parameter;
import net.covers1624.coffeegrinder.type.PolymorphicSignatureMethod;
import net.covers1624.coffeegrinder.type.RawClass;
import net.covers1624.coffeegrinder.type.TypeParameter;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.coffeegrinder.type.asm.AsmField;
import net.covers1624.coffeegrinder.type.asm.AsmMethod;
import net.covers1624.coffeegrinder.type.asm.AsmTypeParameter;
import net.covers1624.coffeegrinder.type.asm.ClassSignatureParser;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import net.covers1624.coffeegrinder.util.Util;
import net.covers1624.coffeegrinder.util.asm.TypeParameterParser;
import net.covers1624.coffeegrinder.util.resolver.CachedClassNode;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.util.JavaVersion;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsmClass
extends ClassType {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsmClass.class);
    private static final Type POLYMORPHIC_SIGNATURE = Type.getObjectType((String)"java/lang/invoke/MethodHandle$PolymorphicSignature");
    private static final Type ANNOTATION_TARGET = Type.getObjectType((String)"java/lang/annotation/Target");
    private static final Set<Type> KNOWN_POLYMORPHIC = Set.of(Type.getObjectType((String)"java/lang/invoke/MethodHandle"), Type.getObjectType((String)"java/lang/invoke/VarHandle"));
    private final TypeResolver typeResolver;
    private final CachedClassNode cNode;
    private final Type descriptor;
    private final String name;
    private final String pkg;
    private final String fullName;
    private final Optional<AsmClass> declaringClass;
    private final ClassType.DeclType declType;
    private final EnumBitSet<AccessFlag> accessFlags;
    private final boolean hasTypeParameters;
    @Nullable
    private List<AsmTypeParameter> typeParameters;
    private final Supplier<SignatureInfo> signatureInfo;
    private final Supplier<ClassType> superClass;
    private final Supplier<List<ClassType>> nestedClasses;
    private final Supplier<List<ClassType>> interfaces;
    private final Supplier<List<Field>> fields;
    private final Supplier<List<Method>> methods;
    private final Supplier<Optional<Method>> enclosingMethod;
    private final Supplier<Map<Object, Field>> instanceConstantLookup;
    private final Supplier<Map<Object, Field>> staticConstantLookup;
    private final AnnotationSupplier annotationSupplier;
    private final Supplier<List<ElementType>> annotationTargets;
    private final Supplier<List<ClassType>> permittedSubclasses;
    private final RawClass rawClass;
    private final JavaVersion classVersion;
    private final boolean containsPolymorphicMethods;

    public AsmClass(TypeResolver typeResolver, CachedClassNode cNode) {
        int lastDollar;
        String name;
        String pkg;
        this.typeResolver = typeResolver;
        this.cNode = cNode;
        this.descriptor = Type.getObjectType((String)cNode.getClassName());
        ClassNode pNode = cNode.getPartialNode();
        int lastSlash = pNode.name.lastIndexOf(47);
        if (lastSlash == -1) {
            pkg = "";
            name = pNode.name;
        } else {
            name = pNode.name.substring(lastSlash + 1);
            pkg = pNode.name.substring(0, lastSlash).replace('/', '.');
        }
        Object fullName = pNode.name.replace("/", ".");
        String outerClass = pNode.outerClass;
        if (pNode.outerClass == null && (lastDollar = pNode.name.lastIndexOf("$")) != -1) {
            outerClass = pNode.name.substring(0, lastDollar);
        }
        this.declaringClass = Optional.ofNullable(outerClass != null ? (AsmClass)typeResolver.tryResolveClassDecl(outerClass) : null);
        this.accessFlags = AccessFlag.unpackClass(pNode.access);
        InnerClassNode ownInnerClassNode = (InnerClassNode)FastStream.of((Iterable)pNode.innerClasses).filter(e -> e.name.equals(pNode.name)).onlyOrDefault();
        if (ownInnerClassNode != null) {
            this.accessFlags.clear(AccessFlag.PUBLIC);
            this.accessFlags.clear(AccessFlag.PRIVATE);
            this.accessFlags.clear(AccessFlag.PROTECTED);
            this.accessFlags.or(AccessFlag.unpackClass(ownInnerClassNode.access));
        }
        if (this.declaringClass.isPresent()) {
            InnerClassNode innerNode = (InnerClassNode)FastStream.of((Iterable)this.declaringClass.get().cNode.getPartialNode().innerClasses).filter(e -> e.name.equals(pNode.name)).findFirst().orElseThrow(() -> new IllegalStateException("Class has outerClass attribute, but outer does not have innerClass reference to us. " + pNode.name));
            if (innerNode.innerName == null) {
                this.declType = ClassType.DeclType.ANONYMOUS;
            } else if (innerNode.outerName == null) {
                this.declType = ClassType.DeclType.LOCAL;
                name = innerNode.innerName;
            } else {
                this.declType = ClassType.DeclType.INNER;
                name = innerNode.innerName;
                fullName = this.declaringClass.get().getFullName() + "$" + name;
            }
            this.accessFlags.or(AccessFlag.unpackInnerClass(innerNode.access));
        } else {
            this.declType = ClassType.DeclType.TOP_LEVEL;
        }
        this.name = name;
        this.pkg = pkg;
        this.fullName = fullName;
        this.hasTypeParameters = pNode.signature != null && pNode.signature.charAt(0) == '<';
        this.signatureInfo = Util.singleMemoize(() -> {
            List<Object> list = this.typeParameters = pNode.signature != null ? TypeParameterParser.parse(pNode.signature, this) : List.of();
            if (pNode.signature == null) {
                return SignatureInfo.NONE;
            }
            ClassSignatureParser visitor = ClassSignatureParser.parse(typeResolver, this, pNode.signature);
            return new SignatureInfo(visitor.getSuperClass(), visitor.getInterfaces());
        });
        this.superClass = Util.singleMemoize(() -> {
            if (pNode.signature != null) {
                return Objects.requireNonNull(this.signatureInfo.get().superClass);
            }
            if (pNode.superName == null) {
                throw new UnsupportedOperationException("Object does not have a super type.");
            }
            return typeResolver.resolveClass(pNode.superName);
        });
        this.nestedClasses = Util.singleMemoize(() -> {
            FastStream innerClassStream = pNode.nestMembers != null && !pNode.nestMembers.isEmpty() ? FastStream.of((Iterable)pNode.nestMembers) : FastStream.of((Iterable)pNode.innerClasses).map(e -> e.name);
            return innerClassStream.filter(e -> e.startsWith(pNode.name)).map(typeResolver::resolveClassDecl).filter(e -> e.getEnclosingClass().filter(d -> d == this).isPresent()).toImmutableList();
        });
        this.interfaces = Util.singleMemoize(() -> {
            if (pNode.signature != null) {
                return this.signatureInfo.get().interfaces;
            }
            return FastStream.of(cNode.getInterfaces()).map(typeResolver::resolveClass).toImmutableList();
        });
        this.fields = Util.singleMemoize(() -> FastStream.of((Iterable)pNode.fields).map(e -> new AsmField(typeResolver, this, (FieldNode)e)).toImmutableList());
        this.methods = Util.singleMemoize(() -> FastStream.of((Iterable)pNode.methods).map(e -> new AsmMethod(typeResolver, this, (MethodNode)e)).toImmutableList());
        this.instanceConstantLookup = Util.singleMemoize(() -> FastStream.of((Iterable)this.fields.get()).filter(e -> e.getConstantValue() != null).filter(e -> !e.isStatic()).toImmutableMap(Field::getConstantValue, Function.identity()));
        this.staticConstantLookup = Util.singleMemoize(() -> FastStream.of((Iterable)this.fields.get()).filter(e -> e.getConstantValue() != null).filter(Field::isStatic).toImmutableMap(Field::getConstantValue, Function.identity()));
        this.enclosingMethod = Util.singleMemoize(() -> {
            if (pNode.outerMethod == null) {
                return Optional.empty();
            }
            return this.declaringClass.map(e -> (Method)((Map)e.methodsLookup.get()).get(pNode.outerMethod + pNode.outerMethodDesc));
        });
        this.annotationSupplier = new AnnotationSupplier(typeResolver, Util.safeConcat(pNode.visibleAnnotations, pNode.invisibleAnnotations), Util.safeConcat(pNode.visibleTypeAnnotations, pNode.invisibleTypeAnnotations));
        this.annotationTargets = Util.singleMemoize(() -> {
            if (!this.getAccessFlags().get(AccessFlag.ANNOTATION)) {
                throw new UnsupportedOperationException(this.getFullName() + " is not an annotation.");
            }
            AnnotationData targetAnnotation = (AnnotationData)FastStream.of(this.getAnnotationSupplier().getAnnotations()).filter(e -> e.type.getDescriptor().equals((Object)ANNOTATION_TARGET)).onlyOrDefault();
            if (targetAnnotation == null) {
                return List.of();
            }
            return FastStream.of((Iterable)((List)targetAnnotation.values.get("value"))).map(e -> ElementType.valueOf(e.getName())).toImmutableList();
        });
        this.permittedSubclasses = Util.singleMemoize(() -> {
            if (pNode.permittedSubclasses == null || pNode.permittedSubclasses.isEmpty()) {
                return List.of();
            }
            return FastStream.of((Iterable)pNode.permittedSubclasses).map(typeResolver::resolveClassDecl).toImmutableList();
        });
        this.rawClass = new RawClass(this);
        this.classVersion = JavaVersion.parseFromClass((int)pNode.version);
        this.containsPolymorphicMethods = KNOWN_POLYMORPHIC.contains(this.descriptor);
    }

    public CachedClassNode getNode() {
        return this.cNode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Optional<ClassType> getEnclosingClass() {
        return (Optional)SneakyUtils.unsafeCast(this.declaringClass);
    }

    @Override
    public String getPackage() {
        return this.pkg;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public ClassType getSuperClass() {
        return this.superClass.get();
    }

    @Override
    public List<ClassType> getNestedClasses() {
        return this.nestedClasses.get();
    }

    @Override
    public List<ClassType> getInterfaces() {
        return this.interfaces.get();
    }

    @Override
    public List<Field> getFields() {
        return this.fields.get();
    }

    @Override
    public List<Method> getMethods() {
        return this.methods.get();
    }

    @Override
    public Optional<Method> getEnclosingMethod() {
        return this.enclosingMethod.get();
    }

    @Override
    public AnnotationSupplier getAnnotationSupplier() {
        return this.annotationSupplier;
    }

    @Override
    public List<ElementType> getAnnotationTargets() {
        return this.annotationTargets.get();
    }

    @Override
    public Type getDescriptor() {
        return this.descriptor;
    }

    @Override
    public ClassType getDeclaration() {
        return this;
    }

    @Override
    public ClassType.DeclType getDeclType() {
        return this.declType;
    }

    @Override
    public EnumBitSet<AccessFlag> getAccessFlags() {
        return this.accessFlags;
    }

    @Override
    public ClassType asRaw() {
        return this.rawClass;
    }

    @Override
    public JavaVersion getClassVersion() {
        return this.classVersion;
    }

    @Override
    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    @Override
    public List<ClassType> getPermittedSubclasses() {
        return this.permittedSubclasses.get();
    }

    private Map<Object, Field> getInstanceConstantLookup() {
        return this.instanceConstantLookup.get();
    }

    private Map<Object, Field> getStaticConstantLookup() {
        return this.staticConstantLookup.get();
    }

    @Override
    @Nullable
    public Method resolveMethod(String name, Type desc) {
        Method polyMethod = this.getPolymorphicMethod(name, desc);
        if (polyMethod != null) {
            return polyMethod;
        }
        return super.resolveMethod(name, desc);
    }

    @Nullable
    private Method getPolymorphicMethod(String name, Type desc) {
        if (!this.containsPolymorphicMethods) {
            return null;
        }
        for (Method method : this.getMethods()) {
            if (!method.getName().equals(name) || !AsmClass.isPolymorphicMethod(method)) continue;
            return new PolymorphicSignatureMethod(method, this.typeResolver, desc);
        }
        return null;
    }

    private static boolean isPolymorphicMethod(Method method) {
        if (!method.getAccessFlags().get(AccessFlag.NATIVE)) {
            return false;
        }
        List<Parameter> params = method.getParameters();
        if (params.size() != 1) {
            return false;
        }
        AType first = params.get(0).getType();
        if (!(first instanceof ArrayType)) {
            return false;
        }
        if (!TypeSystem.isObject(((ArrayType)first).getElementType())) {
            return false;
        }
        for (AnnotationData ann : method.getAnnotationSupplier().getAnnotations()) {
            if (!ann.type.getDescriptor().equals((Object)POLYMORPHIC_SIGNATURE)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasTypeParameters() {
        return this.hasTypeParameters;
    }

    @Override
    public List<TypeParameter> getTypeParameters() {
        if (this.typeParameters == null) {
            this.signatureInfo.get();
        }
        return (List)SneakyUtils.unsafeCast(this.typeParameters);
    }

    @Override
    @Nullable
    public Field findConstant(Object value, boolean isStatic) {
        Map<Object, Field> lookup = isStatic ? this.getStaticConstantLookup() : this.getInstanceConstantLookup();
        Field field = lookup.get(value);
        if (field != null) {
            return field;
        }
        return null;
    }

    @Override
    public String toString() {
        String paramString = "<" + FastStream.of(this.getTypeParameters()).map(e -> "_").join(", ") + ">";
        return this.cNode.getClassName() + (String)(this.hasTypeParameters ? paramString : "");
    }

    private static class SignatureInfo {
        public static final SignatureInfo NONE = new SignatureInfo();
        @Nullable
        public final ClassType superClass;
        public final List<ClassType> interfaces;

        private SignatureInfo() {
            this.superClass = null;
            this.interfaces = List.of();
        }

        private SignatureInfo(ClassType superClass, List<ClassType> interfaces) {
            this.superClass = superClass;
            this.interfaces = interfaces;
        }
    }
}

