/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.type.asm;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.covers1624.coffeegrinder.bytecode.AccessFlag;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.AnnotationSupplier;
import net.covers1624.coffeegrinder.type.ArrayType;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.type.Parameter;
import net.covers1624.coffeegrinder.type.ParameterizedClass;
import net.covers1624.coffeegrinder.type.RawMethod;
import net.covers1624.coffeegrinder.type.ReferenceType;
import net.covers1624.coffeegrinder.type.TypeParameter;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.coffeegrinder.type.accessors.AccessorParser;
import net.covers1624.coffeegrinder.type.accessors.SyntheticAccessor;
import net.covers1624.coffeegrinder.type.asm.AnnotationParser;
import net.covers1624.coffeegrinder.type.asm.AsmClass;
import net.covers1624.coffeegrinder.type.asm.AsmTypeParameter;
import net.covers1624.coffeegrinder.type.asm.MethodSignatureParser;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import net.covers1624.coffeegrinder.util.Util;
import net.covers1624.coffeegrinder.util.asm.TypeParameterParser;
import net.covers1624.coffeegrinder.util.resolver.CachedClassNode;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.ParameterNode;

public class AsmMethod
extends Method {
    private final TypeResolver typeResolver;
    private final AsmClass owner;
    private final MethodNode mNode;
    private final boolean isConstructor;
    private final Type desc;
    private final AType returnType;
    private final EnumBitSet<AccessFlag> accessFlags;
    private final Supplier<MethodNode> fullNode;
    private final List<Parameter> parameters;
    private final List<ReferenceType> exceptions;
    private final List<AsmTypeParameter> typeParameters;
    @Nullable
    private final SignatureInfo signatureInfo;
    private final AnnotationSupplier annotationSupplier;
    private final Supplier<Optional<Object>> annotationDefault;
    private final Supplier<Optional<SyntheticAccessor>> accessor;
    private final Supplier<Method> raw;

    AsmMethod(TypeResolver typeResolver, AsmClass owner, MethodNode mNode) {
        this.typeResolver = typeResolver;
        this.owner = owner;
        this.mNode = mNode;
        this.isConstructor = mNode.name.equals("<init>");
        this.desc = Type.getMethodType((String)mNode.desc);
        this.returnType = typeResolver.resolveType(this.desc.getReturnType());
        this.accessFlags = AccessFlag.unpackMethod(mNode.access);
        CachedClassNode cNode = owner.getNode();
        this.fullNode = Util.singleMemoize(() -> cNode.findFullMethod(mNode.name, mNode.desc));
        this.typeParameters = mNode.signature != null ? TypeParameterParser.parse(mNode.signature, this) : List.of();
        this.signatureInfo = mNode.signature == null ? null : this.parseSignatureInfo();
        this.parameters = this.parseParameters();
        this.exceptions = FastStream.of((Iterable)mNode.exceptions).map(typeResolver::resolveClass).toImmutableList();
        assert (this.signatureInfo == null || this.signatureInfo.exceptions.isEmpty() || this.exceptions.size() == this.signatureInfo.exceptions.size());
        this.annotationSupplier = new AnnotationSupplier(typeResolver, Util.safeConcat(mNode.visibleAnnotations, mNode.invisibleAnnotations), Util.safeConcat(mNode.visibleTypeAnnotations, mNode.invisibleTypeAnnotations));
        this.annotationDefault = Util.singleMemoize(() -> {
            if (mNode.annotationDefault == null) {
                return Optional.empty();
            }
            return Optional.of(AnnotationParser.processAnnotationDefault(typeResolver, mNode.annotationDefault));
        });
        this.accessor = Util.singleMemoize(() -> {
            if (!this.isSynthetic()) {
                return Optional.empty();
            }
            return Optional.ofNullable(AccessorParser.parseAccessor(typeResolver, this.getNode()));
        });
        this.raw = Util.singleMemoize(() -> this.signatureInfo != null ? new RawMethod(this, this.returnType, this.exceptions) : this);
    }

    @Nullable
    private SignatureInfo parseSignatureInfo() {
        MethodSignatureParser parser = MethodSignatureParser.parse(this.typeResolver, this, this.mNode.signature);
        SignatureInfo signatureInfo = new SignatureInfo(parser.getReturnType(), parser.getParameters(), parser.getExceptions());
        if (this.hasTypeParameters() || signatureInfo.isGeneric()) {
            return signatureInfo;
        }
        return null;
    }

    private List<Parameter> parseParameters() {
        ImmutableList.Builder builder = ImmutableList.builder();
        Type[] args = this.desc.getArgumentTypes();
        int formalOffset = 0;
        if (this.isConstructor) {
            if (!(this.owner.getDeclType() == ClassType.DeclType.TOP_LEVEL || this.owner.isStatic() || this.owner.getEnclosingMethod().isPresent() && this.owner.getEnclosingMethod().get().isStatic())) {
                ++formalOffset;
            } else if (this.owner.isEnum()) {
                formalOffset += 2;
            }
        }
        int numFormals = this.signatureInfo != null ? this.signatureInfo.parameters.size() : args.length;
        for (int i = 0; i < args.length; ++i) {
            AType type;
            int formalIndex = i >= formalOffset && i < formalOffset + numFormals ? i - formalOffset : -1;
            AType rawType = this.typeResolver.resolveType(args[i]);
            AType aType = type = this.signatureInfo != null && formalIndex != -1 ? this.signatureInfo.parameters.get(formalIndex) : rawType;
            assert (TypeSystem.areErasuresEqual(rawType, type));
            ParameterNode pNode = this.mNode.parameters == null ? null : (ParameterNode)this.mNode.parameters.get(i);
            Object name = pNode != null ? pNode.name : "p_" + i;
            EnumBitSet<AccessFlag> flags = AccessFlag.unpackParameter(pNode != null ? pNode.access : 0);
            builder.add((Object)new Parameter(formalIndex, (String)name, this, type, rawType, flags, new AnnotationSupplier(this.typeResolver, Util.safeConcat(AsmMethod.safeGet(this.mNode.visibleParameterAnnotations, formalIndex), AsmMethod.safeGet(this.mNode.invisibleParameterAnnotations, formalIndex)), Util.safeConcat(this.mNode.visibleTypeAnnotations, this.mNode.invisibleTypeAnnotations))));
        }
        return builder.build();
    }

    @Nullable
    private static <T> T safeGet(@Nullable @Nullable T @Nullable [] arr, int idx) {
        if (arr == null || idx == -1) {
            return null;
        }
        return arr[idx];
    }

    public MethodNode getNode() {
        return this.fullNode.get();
    }

    @Override
    public String getName() {
        return this.mNode.name;
    }

    @Override
    public ClassType getDeclaringClass() {
        return this.owner;
    }

    @Override
    public EnumBitSet<AccessFlag> getAccessFlags() {
        return this.accessFlags;
    }

    @Override
    public AType getReturnType() {
        return this.signatureInfo != null ? this.signatureInfo.returnType : this.returnType;
    }

    @Override
    public Type getDescriptor() {
        return this.desc;
    }

    @Override
    public boolean isConstructor() {
        return this.isConstructor;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    @Override
    public List<ReferenceType> getExceptions() {
        return this.signatureInfo != null && !this.signatureInfo.exceptions.isEmpty() ? this.signatureInfo.exceptions : this.exceptions;
    }

    @Override
    public List<TypeParameter> getTypeParameters() {
        return (List)SneakyUtils.unsafeCast(this.typeParameters);
    }

    @Override
    public Method getDeclaration() {
        return this;
    }

    @Override
    public AnnotationSupplier getAnnotationSupplier() {
        return this.annotationSupplier;
    }

    @Override
    @Nullable
    public Object getDefaultAnnotationValue() {
        return this.annotationDefault.get().orElse(null);
    }

    @Override
    @Nullable
    public SyntheticAccessor getAccessor() {
        return this.accessor.get().orElse(null);
    }

    @Override
    public Method asRaw() {
        return this.raw.get();
    }

    private static class SignatureInfo {
        public final AType returnType;
        public final List<AType> parameters;
        public final List<ReferenceType> exceptions;

        private SignatureInfo(AType returnType, List<AType> parameters, List<ReferenceType> exceptions) {
            this.returnType = returnType;
            this.parameters = parameters;
            this.exceptions = exceptions;
        }

        public boolean isGeneric() {
            return SignatureInfo.isGeneric(Collections.singletonList(this.returnType)) || SignatureInfo.isGeneric(this.parameters) || SignatureInfo.isGeneric(this.exceptions);
        }

        private static boolean isGeneric(List<? extends AType> types) {
            return FastStream.of(types).anyMatch(SignatureInfo::isGeneric);
        }

        private static boolean isGeneric(AType type) {
            return type instanceof TypeParameter || type instanceof ParameterizedClass || type instanceof ArrayType && SignatureInfo.isGeneric(((ArrayType)type).getElementType());
        }
    }
}

