/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.matching;

import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.Binary;
import net.covers1624.coffeegrinder.bytecode.insns.BinaryOp;
import net.covers1624.coffeegrinder.bytecode.insns.LdcBoolean;
import net.covers1624.coffeegrinder.bytecode.insns.LdcNumber;
import org.jetbrains.annotations.Nullable;

public class LdcMatching {
    @Nullable
    public static LdcNumber matchLdcNumber(@Nullable Instruction insn) {
        if (!(insn instanceof LdcNumber)) {
            return null;
        }
        LdcNumber n = (LdcNumber)insn;
        return n;
    }

    @Nullable
    public static LdcNumber matchLdcInt(@Nullable Instruction insn) {
        LdcNumber ldcNumber = LdcMatching.matchLdcNumber(insn);
        if (ldcNumber == null) {
            return null;
        }
        if (!(ldcNumber.getValue() instanceof Integer)) {
            return null;
        }
        return ldcNumber;
    }

    @Nullable
    public static LdcNumber matchLdcInt(@Nullable Instruction insn, int value) {
        LdcNumber ldc = LdcMatching.matchLdcInt(insn);
        if (ldc == null || ldc.getValue().intValue() != value) {
            return null;
        }
        return ldc;
    }

    @Nullable
    public static LdcBoolean matchLdcBoolean(@Nullable Instruction insn) {
        if (!(insn instanceof LdcBoolean)) {
            return null;
        }
        LdcBoolean b = (LdcBoolean)insn;
        return b;
    }

    @Nullable
    public static LdcBoolean matchLdcBoolean(@Nullable Instruction insn, boolean value) {
        LdcBoolean ldc = LdcMatching.matchLdcBoolean(insn);
        if (ldc == null || ldc.getValue() != value) {
            return null;
        }
        return ldc;
    }

    @Nullable
    public static Instruction matchNegation(@Nullable Instruction insn) {
        if (!(insn instanceof Binary)) {
            return null;
        }
        Binary binary = (Binary)insn;
        if (binary.getOp() != BinaryOp.SUB) {
            return null;
        }
        LdcNumber ldc = LdcMatching.matchLdcNumber(binary.getLeft());
        if (ldc == null || ldc.getValue().doubleValue() != 0.0) {
            return null;
        }
        return binary.getRight();
    }
}

