/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import java.util.Objects;
import net.covers1624.coffeegrinder.bytecode.AccessFlag;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.SimpleInsnVisitor;
import net.covers1624.coffeegrinder.bytecode.insns.Assert;
import net.covers1624.coffeegrinder.bytecode.insns.ClassDecl;
import net.covers1624.coffeegrinder.bytecode.insns.FieldDecl;
import net.covers1624.coffeegrinder.bytecode.insns.IfInstruction;
import net.covers1624.coffeegrinder.bytecode.insns.Invoke;
import net.covers1624.coffeegrinder.bytecode.insns.LdcClass;
import net.covers1624.coffeegrinder.bytecode.insns.LogicAnd;
import net.covers1624.coffeegrinder.bytecode.insns.LogicNot;
import net.covers1624.coffeegrinder.bytecode.insns.New;
import net.covers1624.coffeegrinder.bytecode.insns.Throw;
import net.covers1624.coffeegrinder.bytecode.matching.BranchLeaveMatching;
import net.covers1624.coffeegrinder.bytecode.matching.IfMatching;
import net.covers1624.coffeegrinder.bytecode.matching.InvokeMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LogicMatching;
import net.covers1624.coffeegrinder.bytecode.transform.ClassTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.ClassTransformer;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.statement.ExpressionTransforms;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Field;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.coffeegrinder.util.None;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

public class AssertTransform
implements ClassTransformer {
    public static final Type ASSERTION_ERROR_TYPE = Type.getType(AssertionError.class);
    private final Method m_desiredAssertionStatus;
    private final ClassType assertionErrorType;

    public AssertTransform(TypeResolver resolver) {
        ClassType clazzType = resolver.resolveClassDecl(TypeResolver.CLASS_TYPE);
        this.m_desiredAssertionStatus = Objects.requireNonNull(clazzType.resolveMethod("desiredAssertionStatus", Type.getMethodType((String)"()Z")));
        this.assertionErrorType = resolver.resolveClassDecl(ASSERTION_ERROR_TYPE);
    }

    @Override
    public void transform(ClassDecl cInsn, final ClassTransformContext ctx) {
        final FieldDecl assertionField = (FieldDecl)cInsn.getFieldMembers().map(this::matchAssertionsDisabled).filter(Objects::nonNull).firstOrDefault();
        if (assertionField == null) {
            return;
        }
        cInsn.accept(new SimpleInsnVisitor<None>(){

            @Override
            public None visitIfInstruction(IfInstruction ifInsn, None none) {
                Assert assertInsn = AssertTransform.this.processIf(ifInsn, assertionField, ctx);
                if (assertInsn != null) {
                    return assertInsn.accept(this);
                }
                return (None)super.visitIfInstruction(ifInsn, none);
            }
        });
        assertionField.remove();
    }

    @Nullable
    private Assert processIf(IfInstruction ifInsn, FieldDecl assertionField, ClassTransformContext ctx) {
        if (IfMatching.matchNopFalseIf(ifInsn) == null) {
            return null;
        }
        LogicAnd and = LogicMatching.matchLogicAnd(ifInsn.getCondition());
        if (and == null) {
            return null;
        }
        LogicNot not = LogicMatching.matchLogicNot(and.getLeft());
        if (not == null) {
            return null;
        }
        if (LoadStoreMatching.matchLoadField(not.getArgument(), assertionField.getField()) == null) {
            return null;
        }
        Throw throwInsn = BranchLeaveMatching.matchThrow(ifInsn.getTrueInsn());
        if (throwInsn == null) {
            return null;
        }
        Instruction message = null;
        New newInsn = InvokeMatching.matchNew(throwInsn.getArgument(), this.assertionErrorType);
        if (newInsn == null) {
            return null;
        }
        if (newInsn.getArguments().size() > 0) {
            message = newInsn.getArguments().get(0);
        }
        ctx.pushStep("Emit assertion");
        Assert assertInsn = new Assert(new LogicNot(and.getRight()), message);
        ifInsn.replaceWith(assertInsn);
        ExpressionTransforms.runOnExpression(assertInsn.getCondition(), ctx);
        ctx.popStep();
        return assertInsn;
    }

    @Nullable
    private FieldDecl matchAssertionsDisabled(FieldDecl fieldDecl) {
        Field field = fieldDecl.getField();
        ClassType parent = field.getDeclaringClass();
        while (parent.getDeclType() != ClassType.DeclType.TOP_LEVEL) {
            parent = parent.getEnclosingClass().orElseThrow(SneakyUtils.notPossible());
        }
        if (!field.isStatic()) {
            return null;
        }
        if (!field.getAccessFlags().get(AccessFlag.FINAL)) {
            return null;
        }
        if (!field.isSynthetic()) {
            return null;
        }
        if (field.getType() != PrimitiveType.BOOLEAN) {
            return null;
        }
        Instruction value = fieldDecl.getValue();
        LogicNot not = LogicMatching.matchLogicNot(value);
        if (not == null) {
            return null;
        }
        Invoke invoke = InvokeMatching.matchInvoke(not.getArgument(), Invoke.InvokeKind.VIRTUAL, this.m_desiredAssertionStatus);
        if (invoke == null) {
            return null;
        }
        Instruction instruction = invoke.getTarget();
        if (!(instruction instanceof LdcClass)) {
            return null;
        }
        LdcClass ldcClass = (LdcClass)instruction;
        if (((ClassType)ldcClass.getType()).getDeclaration() != parent) {
            return null;
        }
        return fieldDecl;
    }
}

