/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.source;

import java.util.ArrayList;
import java.util.List;

public class LineBuffer {
    public static final LineBuffer EMPTY = LineBuffer.of(List.of());
    public final List<String> lines;

    private LineBuffer(List<String> lines) {
        this.lines = List.copyOf(lines);
    }

    public static LineBuffer of() {
        return EMPTY;
    }

    public static LineBuffer of(Object str) {
        return LineBuffer.of(List.of(str.toString()));
    }

    public static LineBuffer of(List<String> lines) {
        return new LineBuffer(lines);
    }

    public LineBuffer prepend(String prepend) {
        if (prepend.isEmpty()) {
            return this;
        }
        if (this.lines.size() == 1) {
            return LineBuffer.of(prepend + this.lines.get(0));
        }
        ArrayList<String> builder = new ArrayList<String>(this.lines.size());
        builder.add(prepend + this.lines.get(0));
        builder.addAll(this.lines.subList(1, this.lines.size()));
        return LineBuffer.of(builder);
    }

    public LineBuffer append(Object append) {
        String str = append.toString();
        if (this.lines.isEmpty()) {
            return LineBuffer.of(List.of(str));
        }
        if (this.lines.size() == 1) {
            return LineBuffer.of(this.lines.get(0) + str);
        }
        if (str.isEmpty()) {
            return this;
        }
        ArrayList<String> builder = new ArrayList<String>(this.lines.size());
        builder.addAll(this.lines.subList(0, this.lines.size() - 1));
        builder.add(this.lines.get(this.lines.size() - 1) + str);
        return LineBuffer.of(builder);
    }

    public LineBuffer append(LineBuffer other) {
        return this.append("", other);
    }

    public LineBuffer append(String sep, LineBuffer other) {
        if (this.lines.isEmpty()) {
            return other.prepend(sep);
        }
        if (other.lines.isEmpty()) {
            return this.append(sep);
        }
        ArrayList<String> builder = new ArrayList<String>(this.lines.size() + other.lines.size());
        builder.addAll(this.lines.subList(0, this.lines.size() - 1));
        builder.add(this.lines.get(this.lines.size() - 1) + sep + other.lines.get(0));
        builder.addAll(other.lines.subList(1, other.lines.size()));
        return LineBuffer.of(builder);
    }

    public LineBuffer add(String line) {
        ArrayList<String> builder = new ArrayList<String>(this.lines.size() + 1);
        builder.addAll(this.lines);
        builder.add(line);
        return LineBuffer.of(builder);
    }

    public LineBuffer join(LineBuffer other) {
        if (this.lines.isEmpty()) {
            return other;
        }
        if (other.lines.isEmpty()) {
            return this;
        }
        ArrayList<String> builder = new ArrayList<String>(this.lines.size() + other.lines.size());
        builder.addAll(this.lines);
        builder.addAll(other.lines);
        return LineBuffer.of(builder);
    }

    public LineBuffer joinOn(String seperator) {
        return LineBuffer.of(String.join((CharSequence)seperator, this.lines));
    }

    public String toString() {
        return String.join((CharSequence)"\n", this.lines);
    }
}

