/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.type;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ArrayType;
import net.covers1624.coffeegrinder.type.CapturedTypeVar;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.IntegerConstantType;
import net.covers1624.coffeegrinder.type.IntegerConstantUnion;
import net.covers1624.coffeegrinder.type.IntersectionType;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.type.NullConstantType;
import net.covers1624.coffeegrinder.type.ParameterizedClass;
import net.covers1624.coffeegrinder.type.ParameterizedMethod;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.type.RawClass;
import net.covers1624.coffeegrinder.type.ReferenceType;
import net.covers1624.coffeegrinder.type.ReferenceUnionType;
import net.covers1624.coffeegrinder.type.TypeParameter;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.coffeegrinder.type.TypeSubstitutions;
import net.covers1624.coffeegrinder.type.TypeVariable;
import net.covers1624.coffeegrinder.type.WildcardType;
import net.covers1624.quack.collection.ColUtils;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.Nullable;

public class TypeSystem {
    private TypeSystem() {
    }

    public static boolean isSubType(ReferenceType type, ReferenceType decl) {
        if (TypeSystem.getDecl(type).equals(decl)) {
            return true;
        }
        return type.getDirectSuperTypes().anyMatch(e -> TypeSystem.isSubType(e, decl));
    }

    public static boolean isAssignableTo(AType from, AType to) {
        return TypeSystem.isAssignableTo(from, to, true);
    }

    public static boolean isAssignableTo(AType from, AType to, boolean allowUnchecked) {
        if (from instanceof ReferenceType) {
            return to instanceof ReferenceType && TypeSystem.isAssignableTo((ReferenceType)from, (ReferenceType)to, allowUnchecked);
        }
        return TypeSystem.isAssignableToPrimitive(from, to);
    }

    private static boolean isAssignableToPrimitive(AType from, AType to) {
        if (from.equals(to)) {
            return true;
        }
        if (from instanceof IntegerConstantUnion) {
            for (AType aType : ((IntegerConstantUnion)from).getTypes()) {
                if (TypeSystem.isAssignableToPrimitive(aType, to)) continue;
                return false;
            }
            return true;
        }
        if (to instanceof IntegerConstantUnion) {
            return FastStream.of(((IntegerConstantUnion)to).getTypes()).anyMatch(t -> TypeSystem.isAssignableToPrimitive(from, t));
        }
        if (from instanceof IntegerConstantType) {
            int value = ((IntegerConstantType)from).getValue();
            if (to == PrimitiveType.INT || to == PrimitiveType.LONG || to == PrimitiveType.FLOAT || to == PrimitiveType.DOUBLE) {
                return true;
            }
            if (Short.MIN_VALUE <= value && value <= Short.MAX_VALUE && to == PrimitiveType.SHORT) {
                return true;
            }
            if (0 <= value && value <= 65535 && to == PrimitiveType.CHAR) {
                return true;
            }
            return -128 <= value && value <= 127 && to == PrimitiveType.BYTE;
        }
        if (from instanceof PrimitiveType) {
            boolean isFloatTarget;
            if (from == PrimitiveType.VOID) {
                throw new UnsupportedOperationException("VOID should not even be in a place where you're querying implicit convertibility");
            }
            if (!(to instanceof PrimitiveType)) {
                return false;
            }
            if (from == PrimitiveType.FLOAT) {
                return to == PrimitiveType.DOUBLE;
            }
            boolean bl = isFloatTarget = to == PrimitiveType.FLOAT || to == PrimitiveType.DOUBLE;
            if (from == PrimitiveType.INT) {
                return to == PrimitiveType.LONG || isFloatTarget;
            }
            if (from == PrimitiveType.SHORT || from == PrimitiveType.CHAR) {
                return to == PrimitiveType.INT || to == PrimitiveType.LONG || isFloatTarget;
            }
            if (from == PrimitiveType.BYTE) {
                return to == PrimitiveType.SHORT || to == PrimitiveType.INT || to == PrimitiveType.LONG || isFloatTarget;
            }
            if (from == PrimitiveType.LONG) {
                return isFloatTarget;
            }
            return false;
        }
        throw new UnsupportedOperationException("Assigning " + String.valueOf(from) + " to " + String.valueOf(to));
    }

    public static boolean isAssignableTo(ReferenceType from, ReferenceType to) {
        return TypeSystem.isAssignableTo(from, to, true);
    }

    public static boolean isAssignableTo(ReferenceType from, ReferenceType to, boolean allowUnchecked) {
        assert (TypeSystem.isFullyDefined(from));
        assert (TypeSystem.isFullyDefined(to));
        if (from == NullConstantType.INSTANCE) {
            return true;
        }
        if (to == NullConstantType.INSTANCE) {
            return false;
        }
        if (from.equals(to)) {
            return true;
        }
        assert (!(to instanceof ReferenceUnionType)) : "Union types are final. JLS 14.20";
        if (to instanceof ArrayType && from instanceof ArrayType) {
            return TypeSystem.isAssignableTo(((ArrayType)from).getElementType(), ((ArrayType)to).getElementType(), allowUnchecked);
        }
        ReferenceType lower = to.getLowerBound();
        if (lower != to && TypeSystem.isAssignableTo(from, lower, allowUnchecked)) {
            return true;
        }
        if (to instanceof IntersectionType) {
            return to.getDirectSuperTypes().allMatch(e -> TypeSystem.isAssignableTo(from, e, allowUnchecked));
        }
        if (from instanceof ClassType) {
            if (!(to instanceof ClassType)) {
                return false;
            }
            if (((ClassType)from).getDeclaration() == ((ClassType)to).getDeclaration()) {
                if (to instanceof ParameterizedClass) {
                    if (from instanceof ParameterizedClass) {
                        return TypeSystem.areParameterizationsAssignable((ParameterizedClass)from, (ParameterizedClass)to);
                    }
                    return allowUnchecked;
                }
                return true;
            }
        }
        return from.getDirectSuperTypes().anyMatch(e -> TypeSystem.isAssignableTo(e, to, allowUnchecked));
    }

    private static boolean areParameterizationsAssignable(ParameterizedClass pFrom, ParameterizedClass pTo) {
        List<ReferenceType> fromArgs = pFrom.getTypeArguments();
        List<ReferenceType> toArgs = pTo.getTypeArguments();
        for (int i = 0; i < fromArgs.size(); ++i) {
            ReferenceType to;
            ReferenceType from = fromArgs.get(i);
            if (TypeSystem.isContainedBy(from, to = toArgs.get(i))) continue;
            return false;
        }
        if (pFrom.getOuter() != null) {
            return TypeSystem.areParameterizationsAssignable(pFrom.getOuter(), Objects.requireNonNull(pTo.getOuter()));
        }
        return true;
    }

    private static boolean isContainedBy(ReferenceType a, ReferenceType b) {
        if (a.equals(b)) {
            return true;
        }
        if (!TypeSystem.isAssignableTo(b.getLowerBound(), a.getLowerBound(), false)) {
            return false;
        }
        ReferenceType fromUpper = a instanceof WildcardType ? a.getUpperBound() : a;
        ReferenceType toUpper = b instanceof WildcardType ? b.getUpperBound() : b;
        return TypeSystem.isAssignableTo(fromUpper, toUpper, b instanceof WildcardType);
    }

    public static boolean isCastableTo(ReferenceType from, ReferenceType to, boolean allowWidening) {
        ReferenceType toErased;
        if (TypeSystem.isAssignableTo(from, to)) {
            return allowWidening;
        }
        if (from instanceof ArrayType && to instanceof ArrayType) {
            AType fromElem = ((ArrayType)from).getElementType();
            AType toElem = ((ArrayType)to).getElementType();
            if (fromElem instanceof ReferenceType && toElem instanceof ReferenceType) {
                return TypeSystem.isCastableTo((ReferenceType)fromElem, (ReferenceType)toElem, false);
            }
            return false;
        }
        if (from instanceof WildcardType) {
            return TypeSystem.isCastableTo(from.getUpperBound(), to, false);
        }
        if (to instanceof WildcardType) {
            return false;
        }
        if (to instanceof CapturedTypeVar) {
            return false;
        }
        if (from instanceof TypeVariable) {
            return TypeSystem.isCastableTo(from.getUpperBound(), to, false);
        }
        if (to instanceof TypeParameter) {
            return TypeSystem.isCastableTo(from, to.getUpperBound(), true);
        }
        if (from instanceof IntersectionType) {
            return from.getDirectSuperTypes().allMatch(e -> TypeSystem.isCastableTo(e, to, true));
        }
        if (to instanceof IntersectionType) {
            return to.getDirectSuperTypes().allMatch(e -> TypeSystem.isCastableTo(from, e, true));
        }
        if (from instanceof ReferenceUnionType) {
            return TypeSystem.isCastableTo(from.getSuperType(), to, false);
        }
        ReferenceType fromErased = TypeSystem.erase(from);
        boolean upcast = TypeSystem.isAssignableTo(fromErased, toErased = TypeSystem.erase(to));
        if (upcast || TypeSystem.isAssignableTo(toErased, fromErased)) {
            return !TypeSystem.provablyDistinct(upcast ? from : to, upcast ? to : from);
        }
        assert (from instanceof ClassType);
        ClassType fromClass = (ClassType)from;
        ClassType toClass = (ClassType)to;
        if (fromClass.isInterface() && toClass.isInterface()) {
            return true;
        }
        if (!fromClass.isInterface()) {
            if (!toClass.isInterface()) {
                return false;
            }
            if (!fromClass.isFinal()) {
                return true;
            }
            return TypeSystem.isAssignableTo(fromClass, toClass);
        }
        assert (fromClass.isInterface());
        if (!toClass.isFinal()) {
            return true;
        }
        return TypeSystem.isAssignableTo(toClass, fromClass);
    }

    private static boolean provablyDistinct(ReferenceType a, ReferenceType b) {
        if (a instanceof ArrayType) {
            return b instanceof ArrayType && TypeSystem.provablyDistinct((ReferenceType)((ArrayType)a).getElementType(), (ReferenceType)((ArrayType)b).getElementType());
        }
        if (b instanceof ArrayType) {
            return false;
        }
        return TypeSystem.provablyDistinct((ClassType)a, (ClassType)b);
    }

    private static boolean provablyDistinct(ClassType a, ClassType b) {
        if (!(b instanceof ParameterizedClass)) {
            return false;
        }
        if (a.getDeclaration() == b.getDeclaration()) {
            return a instanceof ParameterizedClass && TypeSystem.provablyDistinct((ParameterizedClass)a, (ParameterizedClass)b);
        }
        ClassType captureA = TypeSystem.capture(a);
        ClassType bOnA = TypeSystem.findParameterizationOrNull(b.getDeclaration(), captureA);
        if (!(bOnA instanceof ParameterizedClass)) {
            return false;
        }
        if (!TypeSystem.provablyDistinct((ParameterizedClass)bOnA, (ParameterizedClass)b)) {
            return false;
        }
        return captureA == a || !TypeSystem.canFindConcreteParameterization((ParameterizedClass)a, (ParameterizedClass)b);
    }

    private static boolean canFindConcreteParameterization(ParameterizedClass type, ParameterizedClass ancestor) {
        HashMap<TypeParameter, ReferenceType> mappings = new HashMap<TypeParameter, ReferenceType>();
        ParameterizedClass p = (ParameterizedClass)TypeSystem.makeThisType(type.getDeclaration());
        if (!TypeSystem.mapTypes(mappings, TypeSystem.findParameterization(ancestor.getDeclaration(), p), ancestor)) {
            return false;
        }
        if (ColUtils.anyMatch(mappings.values(), e -> e instanceof WildcardType)) {
            return false;
        }
        return ColUtils.allMatch(mappings.entrySet(), entry -> TypeSystem.isContainedBy((ReferenceType)entry.getValue(), type.getTypeArguments().get(((TypeParameter)entry.getKey()).getIndex())));
    }

    private static boolean provablyDistinct(ParameterizedClass p1, ParameterizedClass p2) {
        List<ReferenceType> args1 = p1.getTypeArguments();
        List<ReferenceType> args2 = p2.getTypeArguments();
        for (int i = 0; i < args1.size(); ++i) {
            ReferenceType arg2;
            ReferenceType arg1 = args1.get(i);
            if (TypeSystem.anyOverlapBetweenTypes(arg1, arg2 = args2.get(i))) continue;
            return true;
        }
        return p1.getOuter() != null && TypeSystem.provablyDistinct(p1.getOuter(), Objects.requireNonNull(p2.getOuter()));
    }

    private static boolean anyOverlapBetweenTypes(ReferenceType a, ReferenceType b) {
        ReferenceType lowerB;
        ReferenceType upperB;
        ReferenceType upperA = TypeSystem.properNonRecursiveUpperBound(a);
        if (!TypeSystem.isCastableTo(upperA, upperB = TypeSystem.properNonRecursiveUpperBound(b), true)) {
            return false;
        }
        ReferenceType lowerA = a instanceof TypeParameter ? NullConstantType.INSTANCE : a.getLowerBound();
        ReferenceType referenceType = lowerB = b instanceof TypeParameter ? NullConstantType.INSTANCE : b.getLowerBound();
        if (lowerA instanceof TypeParameter && TypeSystem.anyOverlapBetweenTypes(lowerA, b)) {
            return true;
        }
        if (lowerB instanceof TypeParameter && TypeSystem.anyOverlapBetweenTypes(a, lowerB)) {
            return true;
        }
        return TypeSystem.isAssignableTo(lowerA, upperB, false) && TypeSystem.isAssignableTo(lowerB, upperA, false);
    }

    private static ReferenceType properNonRecursiveUpperBound(ReferenceType a) {
        ReferenceType upper = a.getUpperBound();
        if (upper instanceof TypeVariable) {
            return TypeSystem.properNonRecursiveUpperBound(upper);
        }
        if (!(a instanceof TypeVariable)) {
            return upper;
        }
        return TypeSubstitutions.subst(upper, t -> {
            if (!(t instanceof TypeVariable)) {
                return t;
            }
            return WildcardType.createExtends(t == a ? TypeSystem.erase(upper, false) : TypeSystem.properNonRecursiveUpperBound(t));
        });
    }

    public static ReferenceType erase(ReferenceType type) {
        return TypeSystem.erase(type, true);
    }

    public static ReferenceType erase(ReferenceType type, boolean toConcreteType) {
        if (type == NullConstantType.INSTANCE) {
            return type;
        }
        if (!toConcreteType && type instanceof IntersectionType) {
            IntersectionType intersection = (IntersectionType)type;
            return new IntersectionType(intersection.baseType == null ? null : TypeSystem.erase(intersection.baseType), (List<ClassType>)FastStream.of(intersection.getInterfaces()).map(TypeSystem::erase).toImmutableList());
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            AType elemType = arrayType.getElementType();
            if (elemType instanceof ReferenceType) {
                return arrayType.withElementType(TypeSystem.erase((ReferenceType)elemType, toConcreteType));
            }
            return type;
        }
        if (type instanceof ClassType) {
            return TypeSystem.erase((ClassType)type);
        }
        return TypeSystem.erase(type.getSuperType(), toConcreteType);
    }

    public static ClassType erase(ClassType type) {
        assert (TypeSystem.isFullyDefined(type));
        return type instanceof ParameterizedClass ? type.asRaw() : type;
    }

    public static ClassType makeThisType(ClassType clazz) {
        if (!TypeSystem.isGeneric(clazz)) {
            return clazz;
        }
        ParameterizedClass parameterizedOuter = null;
        if (TypeSystem.needsOuterParameterization(clazz)) {
            parameterizedOuter = (ParameterizedClass)TypeSystem.makeThisType(clazz.getEnclosingClass().orElseThrow(SneakyUtils.notPossible()));
        }
        return new ParameterizedClass(parameterizedOuter, clazz, (List)SneakyUtils.unsafeCast(clazz.getTypeParameters()));
    }

    public static ReferenceType makeMultiCatchUnion(ReferenceType a, ReferenceType b) {
        if (a.equals(b)) {
            return a;
        }
        LinkedList<ReferenceType> types = new LinkedList<ReferenceType>();
        if (a instanceof ReferenceUnionType) {
            types.addAll(((ReferenceUnionType)a).getTypes());
            if (ColUtils.anyMatch(types, t -> t.equals(b))) {
                return a;
            }
        } else {
            types.add(a);
        }
        assert (ColUtils.allMatch(types, t -> !TypeSystem.isAssignableTo(b, t)));
        assert (!(b instanceof ReferenceUnionType));
        types.add(b);
        return new ReferenceUnionType((List)SneakyUtils.unsafeCast(types));
    }

    public static IntersectionType intersection(ReferenceType upperBound, ClassType interfaceType) {
        assert (TypeSystem.isInterface(interfaceType));
        if (upperBound instanceof IntersectionType) {
            IntersectionType intersection = (IntersectionType)upperBound;
            ArrayList<ClassType> interfaces = new ArrayList<ClassType>(intersection.getInterfaces());
            interfaces.add(interfaceType);
            return new IntersectionType(intersection.baseType, List.copyOf(interfaces));
        }
        if (TypeSystem.isInterface(upperBound)) {
            return new IntersectionType(null, List.of((ClassType)upperBound, interfaceType));
        }
        return new IntersectionType(upperBound, List.of(interfaceType));
    }

    public static ReferenceType glb(ReferenceType a, ReferenceType b) {
        if (TypeSystem.isObject(a)) {
            return b;
        }
        if (TypeSystem.isAssignableTo(a, b)) {
            return a;
        }
        if (TypeSystem.isAssignableTo(b, a)) {
            return b;
        }
        assert (!(b instanceof IntersectionType));
        if (TypeSystem.isInterface(b)) {
            ArrayList interfaces;
            ReferenceType baseType;
            if (a instanceof IntersectionType) {
                IntersectionType intersection = (IntersectionType)a;
                baseType = intersection.baseType;
                interfaces = FastStream.of(intersection.getInterfaces()).filter(i -> !TypeSystem.isAssignableTo(b, i)).toList();
            } else if (TypeSystem.isInterface(a)) {
                baseType = null;
                interfaces = new ArrayList(2);
                interfaces.add((ClassType)a);
            } else {
                baseType = a;
                interfaces = new ArrayList(1);
            }
            interfaces.add((ClassType)b);
            return new IntersectionType(baseType, interfaces);
        }
        if (TypeSystem.isInterface(a)) {
            return TypeSystem.intersection(b, (ClassType)a);
        }
        if (a instanceof IntersectionType) {
            IntersectionType intersection = (IntersectionType)a;
            assert (intersection.baseType == null || TypeSystem.isAssignableTo(b, intersection.baseType));
            return new IntersectionType(b, intersection.getInterfaces());
        }
        throw new IllegalArgumentException("Cannot find glb of " + String.valueOf(a) + " and " + String.valueOf(b));
    }

    public static ReferenceType glb(Iterable<ReferenceType> types) {
        return (ReferenceType)FastStream.of(types).fold(TypeSystem::glb).orElseThrow(() -> new IllegalArgumentException("No elements supplied."));
    }

    public static ReferenceType glbJavac(ReferenceType a, ReferenceType b) {
        if (b instanceof IntersectionType) {
            return (ReferenceType)b.getDirectSuperTypes().fold((Object)a, TypeSystem::glbJavac);
        }
        if (TypeSystem.isAssignableTo(b, a)) {
            return b;
        }
        if (TypeSystem.isAssignableTo(a, TypeSystem.erase(b))) {
            return a;
        }
        return TypeSystem.glb(a, b);
    }

    public static ReferenceType glbJavac(Iterable<ReferenceType> types) {
        return (ReferenceType)FastStream.of(types).fold(TypeSystem::glbJavac).orElseThrow(() -> new IllegalArgumentException("No elements supplied."));
    }

    public static ReferenceType lub(ReferenceType ... types) {
        return TypeSystem.lub(RecursiveLCTACache.NONE, types);
    }

    public static ReferenceType lub(RecursiveLCTACache cache, ReferenceType ... types) {
        boolean allReferenceArrays = true;
        for (ReferenceType type : types) {
            if (type instanceof ArrayType && !(((ArrayType)type).getElementType() instanceof PrimitiveType)) continue;
            allReferenceArrays = false;
            break;
        }
        if (allReferenceArrays) {
            ReferenceType[] elemTypes = new ReferenceType[types.length];
            for (int i = 0; i < types.length; ++i) {
                elemTypes[i] = (ReferenceType)((ArrayType)types[i]).getElementType();
            }
            return ((ArrayType)types[0]).withElementType(TypeSystem.lub(cache, elemTypes));
        }
        LinkedList<ReferenceType> mec = TypeSystem.getCommonDeclaredHierarchy(types);
        TypeSystem.recoverGenericCandidates(cache, mec, types);
        return TypeSystem.glb(mec);
    }

    private static void recoverGenericCandidates(RecursiveLCTACache cache, LinkedList<ReferenceType> mec, ReferenceType ... types) {
        ListIterator<ReferenceType> iterator = mec.listIterator();
        while (iterator.hasNext()) {
            ReferenceType c = (ReferenceType)iterator.next();
            if (!(c instanceof ClassType)) continue;
            iterator.set(TypeSystem.recoverGenericCandidates(cache, (ClassType)c, types));
        }
    }

    private static ReferenceType recoverGenericCandidates(RecursiveLCTACache cache, ClassType decl, ReferenceType[] types) {
        if (!TypeSystem.isGeneric(decl)) {
            return decl;
        }
        ClassType p = Objects.requireNonNull(TypeSystem.findParameterization(decl, types[0]));
        for (int i = 1; i < types.length; ++i) {
            p = TypeSystem.lcp(cache, p, Objects.requireNonNull(TypeSystem.findParameterization(decl, types[i])));
        }
        return p;
    }

    private static ClassType lcp(RecursiveLCTACache cache, ClassType c1, ClassType c2) {
        if (c1.equals(c2)) {
            return c1;
        }
        if (c1 instanceof RawClass) {
            return c1;
        }
        if (c2 instanceof RawClass) {
            return c2;
        }
        return TypeSystem.lcp(cache, (ParameterizedClass)c1, (ParameterizedClass)c2);
    }

    private static ParameterizedClass lcp(RecursiveLCTACache cache, ParameterizedClass c1, ParameterizedClass c2) {
        assert (c1.getDeclaration() == c2.getDeclaration());
        List<ReferenceType> args1 = c1.getTypeArguments();
        List<ReferenceType> args2 = c2.getTypeArguments();
        ArrayList<ReferenceType> args = new ArrayList<ReferenceType>(args1.size());
        for (int i = 0; i < args1.size(); ++i) {
            ReferenceType t1 = args1.get(i);
            ReferenceType t2 = args2.get(i);
            args.add(TypeSystem.lcta(cache, t1, t2));
        }
        ParameterizedClass outer = c1.getOuter() == null ? null : TypeSystem.lcp(cache, c1.getOuter(), Objects.requireNonNull(c2.getOuter()));
        return new ParameterizedClass(outer, c1.getDeclaration(), args);
    }

    private static ReferenceType lcta(RecursiveLCTACache cache, final ReferenceType t1, final ReferenceType t2) {
        ReferenceType t2Bound;
        ReferenceType t1Bound = t1 instanceof CapturedTypeVar ? ((CapturedTypeVar)t1).wildcard : t1;
        ReferenceType referenceType = t2Bound = t2 instanceof CapturedTypeVar ? ((CapturedTypeVar)t2).wildcard : t2;
        if (TypeSystem.isContainedBy(t1Bound, t2Bound)) {
            return t2Bound;
        }
        if (TypeSystem.isContainedBy(t2Bound, t1Bound)) {
            return t1Bound;
        }
        if (t1 instanceof WildcardType) {
            return TypeSystem.lcta(cache, t1.getUpperBound(), t2);
        }
        if (t2 instanceof WildcardType) {
            return TypeSystem.lcta(cache, t1, t2.getUpperBound());
        }
        ReferenceType cached = cache.lookup(t1, t2);
        if (cached != null) {
            return WildcardType.createExtends(TypeSystem.objectType(t1));
        }
        class InfiniteWildcard
        extends WildcardType {
            InfiniteWildcard() {
                super(NullConstantType.INSTANCE, NullConstantType.INSTANCE);
            }

            @Override
            public boolean isInfinite() {
                return true;
            }

            @Override
            public String getFullName() {
                return "? extends lub(" + String.valueOf(t1) + "," + String.valueOf(t2) + ")";
            }
        }
        InfiniteWildcard result = new InfiniteWildcard();
        result.upperBound = TypeSystem.lub((ReferenceType a, ReferenceType b) -> a.equals(t1) && b.equals(t2) ? result : cache.lookup(a, b), t1, t2);
        return WildcardType.createExtends(result.upperBound);
    }

    private static void intersect(LinkedList<ReferenceType> a, List<ReferenceType> b) {
        a.removeIf(t -> !ColUtils.anyMatch((Iterable)b, t::equals));
    }

    private static LinkedList<ReferenceType> minimal(LinkedList<ReferenceType> types) {
        LinkedList<ReferenceType> minimal = new LinkedList<ReferenceType>();
        block0: while (!types.isEmpty()) {
            ReferenceType t = types.removeFirst();
            for (ReferenceType t2 : types) {
                if (!TypeSystem.isSubType(t2, t)) continue;
                continue block0;
            }
            minimal.addLast(t);
        }
        return minimal;
    }

    public static LinkedList<ReferenceType> getCommonDeclaredHierarchy(ReferenceType ... types) {
        LinkedList<ReferenceType> h = TypeSystem.getDeclaredHierarchy(types[0]);
        for (int i = 1; i < types.length; ++i) {
            TypeSystem.intersect(h, TypeSystem.getDeclaredHierarchy(types[i]));
        }
        return TypeSystem.minimal(h);
    }

    private static LinkedList<ReferenceType> getDeclaredHierarchy(ReferenceType type) {
        LinkedList<ReferenceType> l = new LinkedList<ReferenceType>();
        TypeSystem.getDeclaredHierarchy(l, type);
        return l;
    }

    private static void getDeclaredHierarchy(LinkedList<ReferenceType> l, ReferenceType type) {
        if (type instanceof ClassType) {
            type = ((ClassType)type).getDeclaration();
        }
        if (l.contains(type)) {
            return;
        }
        for (ReferenceType superType : type.getDirectSuperTypes()) {
            TypeSystem.getDeclaredHierarchy(l, superType);
        }
        l.add(type);
    }

    public static boolean mapTypes(Map<TypeParameter, ReferenceType> mappings, ReferenceType t1, ReferenceType t2) {
        if (t1 instanceof TypeParameter) {
            assert (!mappings.containsKey(t1) || mappings.get(t1).equals(t2));
            mappings.put((TypeParameter)t1, t2);
            return true;
        }
        if (t1 instanceof ArrayType) {
            if (!(t2 instanceof ArrayType)) {
                return false;
            }
            return TypeSystem.mapTypes(mappings, (ReferenceType)((ArrayType)t1).getElementType(), (ReferenceType)((ArrayType)t2).getElementType());
        }
        if (t1 instanceof ParameterizedClass) {
            if (!(t2 instanceof ParameterizedClass)) {
                return false;
            }
            List<ReferenceType> p1 = ((ParameterizedClass)t1).getTypeArguments();
            List<ReferenceType> p2 = ((ParameterizedClass)t2).getTypeArguments();
            boolean ret = true;
            for (int i = 0; i < p1.size(); ++i) {
                ret &= TypeSystem.mapTypes(mappings, p1.get(i), p2.get(i));
            }
            return ret;
        }
        return t1.equals(t2);
    }

    public static ClassType box(TypeResolver resolver, PrimitiveType type) {
        return resolver.resolveClass(type.getBoxedClass());
    }

    @Nullable
    public static PrimitiveType unbox(ReferenceType type) {
        return PrimitiveType.UNBOX_LOOKUP.get(type.getFullName());
    }

    public static boolean isFullyDefined(ReferenceType type) {
        if (type instanceof WildcardType) {
            return false;
        }
        if (type instanceof ClassType) {
            return TypeSystem.isFullyDefined((ClassType)type);
        }
        return true;
    }

    public static boolean isFullyDefined(ClassType type) {
        if (type instanceof ParameterizedClass) {
            return ((ParameterizedClass)type).isFullyParameterized();
        }
        return !TypeSystem.isGeneric(type);
    }

    public static boolean isFullyDefined(Method method) {
        if (method instanceof ParameterizedMethod) {
            return ((ParameterizedMethod)method).isFullyParameterized();
        }
        return !method.hasTypeParameters();
    }

    public static boolean isConstructedViaTargetInstance(ClassType clazz) {
        if (clazz.getDeclType() == ClassType.DeclType.ANONYMOUS) {
            return TypeSystem.isConstructedViaTargetInstance(clazz.getSuperClass());
        }
        if (clazz.getDeclType() != ClassType.DeclType.INNER) {
            return false;
        }
        if (clazz.isStatic()) {
            return false;
        }
        return clazz.getEnclosingClass().isPresent();
    }

    public static boolean needsOuterParameterization(ClassType clazz) {
        return clazz.getDeclType() == ClassType.DeclType.INNER && !clazz.isStatic() && TypeSystem.isGeneric(clazz.getEnclosingClass().orElseThrow(SneakyUtils.notPossible()));
    }

    public static boolean isGeneric(ClassType clazz) {
        return clazz.hasTypeParameters() || TypeSystem.needsOuterParameterization(clazz);
    }

    public static boolean areErasuresEqual(AType a, AType b) {
        return a.equals(b) || a instanceof ReferenceType && b instanceof ReferenceType && TypeSystem.erase((ReferenceType)a).equals(TypeSystem.erase((ReferenceType)b));
    }

    public static boolean isInterface(ReferenceType t) {
        return t instanceof ClassType && ((ClassType)t).isInterface();
    }

    public static boolean isIntegerConstant(AType type) {
        return type instanceof IntegerConstantType || type instanceof IntegerConstantUnion;
    }

    public static ClassType findParameterization(ClassType decl, ReferenceType inType) {
        return Objects.requireNonNull(TypeSystem.findParameterizationOrNull(decl, inType));
    }

    @Nullable
    public static ClassType findParameterizationOrNull(ClassType decl, ReferenceType inType) {
        if (TypeSystem.getDecl(inType) == decl) {
            return (ClassType)inType;
        }
        return (ClassType)inType.getDirectSuperTypes().map(e -> TypeSystem.findParameterizationOrNull(decl, e)).filter(Objects::nonNull).firstOrDefault();
    }

    public static boolean isObject(AType type) {
        return type instanceof ClassType && type.getFullName().equals("java.lang.Object");
    }

    public static boolean isString(AType type) {
        return type instanceof ClassType && type.getFullName().equals("java.lang.String");
    }

    public static ClassType objectType(ReferenceType type) {
        return TypeSystem.isObject(type) ? (ClassType)type : TypeSystem.objectType(type.getSuperType());
    }

    public static TypeResolver resolver(ReferenceType type) {
        return TypeSystem.objectType(type).getTypeResolver();
    }

    public static AType capture(AType type) {
        return type instanceof ReferenceType ? TypeSystem.capture((ReferenceType)type) : type;
    }

    public static ReferenceType capture(ReferenceType type) {
        return type instanceof ParameterizedClass ? TypeSystem.capture((ParameterizedClass)type) : type;
    }

    public static ClassType capture(ClassType type) {
        return type instanceof ParameterizedClass ? TypeSystem.capture((ParameterizedClass)type) : type;
    }

    public static ParameterizedClass capture(ParameterizedClass type) {
        return type.capture();
    }

    private static ReferenceType getDecl(ReferenceType e) {
        return e instanceof ClassType ? ((ClassType)e).getDeclaration() : e;
    }

    static interface RecursiveLCTACache {
        public static final RecursiveLCTACache NONE = (a, b) -> null;

        @Nullable
        public ReferenceType lookup(ReferenceType var1, ReferenceType var2);
    }
}

