package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.*;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

/**
 * Created by covers1624 on 23/11/21.
 */
public final class TryWithResources extends TryInstruction {

    private final InstructionSlot<Instruction> resource = new InstructionSlot<>(this);
    private final InstructionSlot<BlockContainer> tryBody = new InstructionSlot<>(this);

    public TryWithResources(Instruction resource, BlockContainer body) {
        setResource(resource);
        setTryBody(body);
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.VOID;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitTryWithResources(this, ctx);
    }

    //@formatter:off
    public Instruction getResource() { return resource.get(); }
    public void setResource(Instruction resource) { this.resource.set(resource); }
    @Override public BlockContainer getTryBody() { return tryBody.get(); }
    @Override public void setTryBody(BlockContainer tryBody) { this.tryBody.set(tryBody); }
    //@formatter:on
}
