package net.covers1624.coffeegrinder.bytecode.matching;

import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.IfInstruction;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import org.jetbrains.annotations.Nullable;

/**
 * Created by covers1624 on 27/4/21.
 */
public class IfMatching {

    /**
     * Matches a single {@link IfInstruction}.
     *
     * @param insn The {@link Instruction} to match.
     * @return The {@link IfInstruction} or <code>null</code>.
     */
    @Nullable
    public static IfInstruction matchIf(@Nullable Instruction insn) {
        if (!(insn instanceof IfInstruction ifInsn)) return null;

        return ifInsn;
    }

    /**
     * Matches a single {@link IfInstruction} with a {@link Nop} instruction as its false
     * branch target.
     *
     * @param insn The {@link Instruction} to match.
     * @return The {@link IfInstruction} or <code>null</code>.
     */
    @Nullable
    public static IfInstruction matchNopFalseIf(@Nullable Instruction insn) {
        IfInstruction ifInsn = matchIf(insn);
        if (ifInsn == null || !(ifInsn.getFalseInsn() instanceof Nop)) return null;
        return ifInsn;
    }
}
