package net.covers1624.coffeegrinder.bytecode.matching;

import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.LogicAnd;
import net.covers1624.coffeegrinder.bytecode.insns.LogicNot;
import net.covers1624.coffeegrinder.bytecode.insns.LogicOr;
import org.jetbrains.annotations.Nullable;

/**
 * Created by covers1624 on 21/7/21.
 */
public class LogicMatching {

    /**
     * Matches the given instruction against a Logical not expression.
     *
     * @param insn The Instruction to match.
     * @return The {@link LogicNot} or {@code null}.
     */
    @Nullable
    public static LogicNot matchLogicNot(@Nullable Instruction insn) {
        if (!(insn instanceof LogicNot l)) return null;

        return l;
    }

    /**
     * Matches the given instruction against a Logical and expression.
     *
     * @param insn The Instruction to match.
     * @return The {@link LogicAnd} or {@code null}.
     */
    @Nullable
    public static LogicAnd matchLogicAnd(@Nullable Instruction insn) {
        if (!(insn instanceof LogicAnd l)) return null;

        return l;
    }

    /**
     * Matches the given instruction against a Logical or expression.
     *
     * @param insn The Instruction to match.
     * @return The {@link LogicOr} or {@code null}.
     */
    @Nullable
    public static LogicOr matchLogicOr(@Nullable Instruction insn) {
        if (!(insn instanceof LogicOr l)) return null;

        return l;
    }
}
