package net.covers1624.coffeegrinder.bytecode.transform;

import net.covers1624.coffeegrinder.bytecode.InvariantVisitor;
import net.covers1624.coffeegrinder.bytecode.insns.Block;

import java.util.List;

/**
 * Created by covers1624 on 21/7/21.
 */
public class BlockStatementTransform implements BlockTransformer {

    private final String name;
    private final List<StatementTransformer> transforms;

    private BlockStatementTransform(String name, List<StatementTransformer> transforms) {
        this.name = name;
        this.transforms = transforms;
    }

    public static BlockStatementTransform of(String name, StatementTransformer... transforms) {
        return new BlockStatementTransform(name, List.of(transforms));
    }

    @Override
    public void transform(Block block, BlockTransformContext bCtx) {
        StatementTransformContext ctx = new StatementTransformContext(bCtx, block);

        while (ctx.moveNext()) {
            for (StatementTransformer transform : transforms) {
                transform.transform(ctx.current(), ctx);

                InvariantVisitor.checkInvariants(ctx.current());

                if (ctx.skipRequested) {
                    ctx.skipRequested = false;
                    break;
                }
            }
        }

        InvariantVisitor.checkInvariants(block);
    }

    @Override
    public String getName() {
        return name;
    }
}
