package net.covers1624.coffeegrinder.bytecode.transform;

import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;

/**
 * A transform that runs on a sequence of statements within a block.
 * <p>
 * Interleaving different statement-combining transforms on a per-statement level
 * improves the detection of nested constructs.
 * For example, array initializers can assume each element assignment was already
 * reduced to a single statement even if the element contains a high-level construct
 * detected by a different transform.
 * <p>
 * Created by covers1624 on 21/7/21.
 */
public interface StatementTransformer {

    /**
     * Runs the transform on the statements within a block.
     * <p>
     * This transform may only modify instructions after and including the provided position.
     * The transform will run from over the block backwards.
     * <p>
     * Instructions prior to the current position must not be modified.
     * It is valid to read such instructions, but not recommended as those have not been transformed yet.
     * <p>
     * This function is only called on control-flow blocks with unreachable end-points.
     * This, the last instruction in the block must always have the {@link InstructionFlag#END_POINT_UNREACHABLE} flag.
     *
     * @param block The block being transformed.
     * @param pos   The position to transform.
     * @param ctx   The context.
     */
    void transform(Instruction statement, StatementTransformContext ctx);

}
