package net.covers1624.coffeegrinder.bytecode.transform.transformers.generics;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import org.jetbrains.annotations.NotNull;

import java.util.*;
import java.util.function.Function;

import static net.covers1624.quack.util.SneakyUtils.unsafeCast;

public class TarjanDepthFirstIterator<T> implements Iterable<List<T>>, Iterator<List<T>> {

    private final Function<T, Iterable<T>> successors;
    private final Object2IntMap<T> ids = new Object2IntOpenHashMap<>();
    private final T[] elements;
    private final int[] dfn;
    private final int[] low;
    private final int[] stack;
    private final BitSet onStack;
    private int top;

    private int index;
    private final LinkedList<List<T>> next = new LinkedList<>();

    public TarjanDepthFirstIterator(Collection<T> nodes, Function<T, Iterable<T>> successors) {
        this.successors = successors;
        int t = 0;
        elements = unsafeCast(new Object[nodes.size()]);
        for (T node : nodes) {
            ids.put(node, t);
            elements[t] = node;
            t++;
        }

        final int n = nodes.size();
        dfn = new int[n];
        low = new int[n];
        stack = new int[n];
        onStack = new BitSet(n);
        top = -1;
    }

    @NotNull
    @Override
    public Iterator<List<T>> iterator() {
        return this;
    }

    private void push(int i) {
        stack[++top] = i;
        onStack.set(i);
    }

    private void pop() {
        onStack.clear(stack[top--]);
    }

    private void dfs(int now) {
        if (dfn[now] == 0) {
            dfs(now, 1);
        }
    }

    private void dfs(int now, int depth) {
        dfn[now] = depth;
        low[now] = depth;
        push(now);
        for (T each : successors.apply(elements[now])) {
            int to = ids.getInt(each);
            if (dfn[to] != 0) {
                if (low[now] > dfn[to]) {
                    low[now] = dfn[to];
                }
            } else {
                dfs(to, depth + 1);
                if (low[now] > low[to]) {
                    low[now] = low[to];
                }
            }
        }

        if (dfn[now] != low[now]) {
            return;
        }

        if (stack[top] == now) {
            pop();
            next.addLast(List.of(elements[now]));
            return;
        }

        ImmutableList.Builder<T> builder = ImmutableList.builder();
        while (true) {
            final int t = stack[top];
            builder.add(elements[t]);
            pop();
            if (t == now) {
                break;
            }
        }
        next.addLast(builder.build());
    }

    @Override
    public boolean hasNext() {
        while (index < elements.length && next.isEmpty()) {
            dfs(index++);
        }

        return !next.isEmpty();
    }

    @Override
    public List<T> next() {
        return next.removeFirst();
    }
}
