package net.covers1624.coffeegrinder.type;

/**
 * Created by covers1624 on 22/12/21.
 */
public class WildcardType extends ReferenceType {

    protected ReferenceType upperBound;
    private final ReferenceType lowerBound;

    protected WildcardType(ReferenceType upperBound, ReferenceType lowerBound) {
        this.upperBound = upperBound;
        this.lowerBound = lowerBound;
    }

    @Override
    public ReferenceType getUpperBound() {
        return upperBound;
    }

    @Override
    public ReferenceType getLowerBound() {
        return lowerBound;
    }

    @Override
    public ReferenceType getSuperType() {
        return upperBound;
    }

    public boolean isSuper() {
        return lowerBound != NullConstantType.INSTANCE;
    }

    public boolean isInfinite() {
        return false;
    }

    public static WildcardType createExtends(ReferenceType upperBound) {
        return new WildcardType(upperBound, NullConstantType.INSTANCE);
    }

    public static WildcardType createSuper(ReferenceType lowerBound) {
        return new WildcardType(TypeSystem.objectType(lowerBound), lowerBound);
    }

    @Override
    public String getName() {
        return "?";
    }

    @Override
    public String getFullName() {
        if (isSuper()) return "? super " + getLowerBound().getFullName();
        if (TypeSystem.isObject(upperBound)) return "?";
        return "? extends " + getUpperBound().getFullName();
    }

    @Override
    public String toString() {
        return getFullName();
    }

    @Override
    public boolean mentions(ReferenceType type) {
        return super.mentions(type) || getUpperBound().mentions(type) || getLowerBound().mentions(type);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof WildcardType other)) return false;

        return upperBound.equals(other.upperBound) && lowerBound.equals(other.lowerBound);
    }

    @Override
    public int hashCode() {
        int result = upperBound.hashCode();
        result = 31 * result + lowerBound.hashCode();
        return result;
    }
}
