/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import java.util.LinkedList;
import java.util.Objects;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.Branch;
import net.covers1624.coffeegrinder.bytecode.insns.FieldReference;
import net.covers1624.coffeegrinder.bytecode.insns.IfInstruction;
import net.covers1624.coffeegrinder.bytecode.insns.Leave;
import net.covers1624.coffeegrinder.bytecode.insns.Load;
import net.covers1624.coffeegrinder.bytecode.insns.LogicAnd;
import net.covers1624.coffeegrinder.bytecode.insns.LogicNot;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.bytecode.insns.Ternary;
import net.covers1624.coffeegrinder.bytecode.matching.BlockMatching;
import net.covers1624.coffeegrinder.bytecode.matching.BranchLeaveMatching;
import net.covers1624.coffeegrinder.bytecode.matching.IfMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LogicMatching;
import net.covers1624.coffeegrinder.bytecode.transform.BlockTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.BlockTransformer;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.statement.ExpressionTransforms;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.statement.Inlining;
import net.covers1624.coffeegrinder.type.Field;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;

public class ConditionDetection
implements BlockTransformer {
    private BlockTransformContext ctx;

    @Override
    public void transform(Block block, BlockTransformContext ctx) {
        this.ctx = ctx;
        IfInstruction ifInsn = IfMatching.matchIf(block.instructions.secondToLastOrDefault());
        if (ifInsn != null) {
            this.handleIfInstruction(block, ifInsn);
        } else {
            ConditionDetection.inlineExitBranch(block, ctx);
        }
    }

    private void handleIfInstruction(Block block, IfInstruction ifInsn) {
        this.invertIf(ifInsn);
        while (this.inlineTrueBranch(ifInsn) || ConditionDetection.inlineExitBranch(block, this.ctx)) {
            boolean needsInvert = this.prepareShortCircuitOr(ifInsn) || this.prepareInvertedTernary(ifInsn);
            this.tryMergeTrueExitWithFallthrough(block, ifInsn);
            this.introduceShortCircuit(ifInsn);
            this.produceTernary(ifInsn);
            if (!needsInvert) continue;
            this.invertIf(ifInsn);
        }
        this.mergeExitsForInline(block, ifInsn);
    }

    private boolean prepareInvertedTernary(IfInstruction ifInsn) {
        Block ternaryThenCond = BlockMatching.matchBlock(ifInsn.getTrueInsn());
        if (ternaryThenCond == null) {
            return false;
        }
        IfInstruction thenIf = Inlining.matchWithPotentialInline(ternaryThenCond.getFirstChildOrNull(), new LinkedList<Runnable>(), this.ctx, IfMatching::matchNopFalseIf);
        if (thenIf == null) {
            return false;
        }
        IfInstruction elseIf = Inlining.matchWithPotentialInline(ifInsn.getNextSiblingOrNull(), new LinkedList<Runnable>(), this.ctx, IfMatching::matchNopFalseIf);
        if (elseIf == null) {
            return false;
        }
        if (!BranchLeaveMatching.compatibleExitInstruction(thenIf.getTrueInsn(), elseIf.getNextSiblingOrNull())) {
            return false;
        }
        if (!BranchLeaveMatching.compatibleExitInstruction(thenIf.getNextSiblingOrNull(), elseIf.getTrueInsn())) {
            return false;
        }
        this.ctx.pushStep("Prepare inverted ternary");
        this.invertIf(elseIf);
        this.ctx.popStep();
        return true;
    }

    private boolean inlineTrueBranch(IfInstruction ifInsn) {
        int nextInsnBytecodeOffset;
        if (!ConditionDetection.canInline(ifInsn.getTrueInsn())) {
            return false;
        }
        assert (IfMatching.matchNopFalseIf(ifInsn) != null);
        Block targetBlock = ((Branch)ifInsn.getTrueInsn()).getTargetBlock();
        Instruction fallthrough = ifInsn.getNextSibling();
        int n = nextInsnBytecodeOffset = !(fallthrough instanceof Branch) && !(fallthrough instanceof Leave) ? fallthrough.getBytecodeOffset() : -1;
        if (nextInsnBytecodeOffset >= 0 && nextInsnBytecodeOffset < targetBlock.getBytecodeOffset()) {
            return false;
        }
        this.ctx.pushStep("Inline true-branch");
        ifInsn.setTrueInsn(targetBlock);
        if (targetBlock.instructions.size() == 1) {
            targetBlock.replaceWith(targetBlock.getFirstChild());
        }
        this.ctx.popStep();
        return true;
    }

    public static boolean inlineExitBranch(Block block, BlockTransformContext ctx) {
        Instruction exitInsn = ConditionDetection.getExit(block);
        if (!ConditionDetection.canInline(exitInsn)) {
            return false;
        }
        ctx.pushStep("Inline exit-branch");
        Block targetBlock = ((Branch)exitInsn).getTargetBlock();
        ((Instruction)block.instructions.last()).remove();
        block.instructions.addAll((Iterable<Instruction>)((Object)targetBlock.instructions));
        targetBlock.remove();
        ctx.popStep();
        return true;
    }

    private static boolean canInline(Instruction exitInsn) {
        Branch branch = BranchLeaveMatching.matchBranch(exitInsn);
        if (branch == null) {
            return false;
        }
        Block targetBlock = branch.getTargetBlock();
        if (targetBlock.getIncomingEdgeCount() != 1) {
            return false;
        }
        Block parentBlock = (Block)exitInsn.ancestorsOfType(Block.class).filter(b -> b.getParent() instanceof BlockContainer).first();
        return parentBlock.getNextSiblingOrNull() == targetBlock;
    }

    private void mergeExitsForInline(Block block, IfInstruction ifInsn) {
        if (IfMatching.matchNopFalseIf(ifInsn) == null) {
            return;
        }
        Block nextBlock = (Block)block.getNextSiblingOrNull();
        if (nextBlock == null) {
            return;
        }
        if (!nextBlock.getBranches().allMatch(b -> b.isDescendantOf(block))) {
            return;
        }
        this.moveBranchExitsTowardsRoot(block, nextBlock);
        ConditionDetection.inlineExitBranch(block, this.ctx);
    }

    private void moveBranchExitsTowardsRoot(Block block, Block targetBlock) {
        if (!block.hasFlag(InstructionFlag.END_POINT_UNREACHABLE)) {
            return;
        }
        for (Instruction insn = block.getLastChild(); insn != null; insn = insn.getPrevSiblingOrNull()) {
            Branch trueExit;
            IfInstruction ifInsn = IfMatching.matchNopFalseIf(insn);
            if (ifInsn == null) continue;
            Instruction instruction = ifInsn.getTrueInsn();
            if (instruction instanceof Block) {
                Block trueBlock = (Block)instruction;
                this.moveBranchExitsTowardsRoot(trueBlock, targetBlock);
            }
            if ((trueExit = BranchLeaveMatching.matchBranch(ConditionDetection.tryGetExit(ifInsn.getTrueInsn()), targetBlock)) == null) continue;
            if (BranchLeaveMatching.compatibleExitInstruction(ConditionDetection.tryGetExit(block), trueExit)) {
                this.mergeTrueExitWithFallthrough(block, ifInsn);
                continue;
            }
            this.moveTrueExitToFallthrough(block, ifInsn);
        }
    }

    private void moveTrueExitToFallthrough(Block block, IfInstruction ifInsn) {
        this.ctx.pushStep("Move true exit to fallthrough");
        this.ctx.pushStep("Introduce else");
        ifInsn.setFalseInsn(block.extractRange(ifInsn.getNextSibling(), block.getLastChild()));
        this.ctx.popStep();
        Instruction exit = ConditionDetection.getExit(ifInsn.getTrueInsn());
        ConditionDetection.ensureParentIsBlock(exit);
        block.instructions.add(exit);
        this.ctx.popStep();
    }

    private void tryMergeTrueExitWithFallthrough(Block block, IfInstruction ifInsn) {
        Instruction exit;
        if (IfMatching.matchNopFalseIf(ifInsn) == null) {
            return;
        }
        Instruction trueExit = ConditionDetection.tryGetExit(ifInsn.getTrueInsn());
        if (BranchLeaveMatching.compatibleExitInstruction(trueExit, exit = ConditionDetection.tryGetExit(block))) {
            this.mergeTrueExitWithFallthrough(block, ifInsn);
        }
    }

    private void mergeTrueExitWithFallthrough(Block block, IfInstruction ifInsn) {
        this.ctx.pushStep("Merge true exit with fallthrough");
        if (ifInsn != block.instructions.secondToLastOrDefault()) {
            assert (ifInsn.getFalseInsn() instanceof Nop);
            this.ctx.pushStep("Introduce else");
            ifInsn.setFalseInsn(block.extractRange(ifInsn.getNextSibling(), block.getLastChild().getPrevSibling()));
            this.ctx.popStep();
        }
        Instruction exit = ConditionDetection.getExit(ifInsn.getTrueInsn());
        ConditionDetection.ensureParentIsBlock(exit);
        exit.remove();
        this.ctx.popStep();
    }

    private boolean prepareShortCircuitOr(IfInstruction ifInsn) {
        Branch elseBranch = BranchLeaveMatching.matchBranch(ifInsn.getNextSibling());
        if (elseBranch == null) {
            return false;
        }
        Block trueBlock = BlockMatching.matchBlock(ifInsn.getTrueInsn());
        if (trueBlock == null || ConditionDetection.tryGetExit(trueBlock) == null) {
            return false;
        }
        IfInstruction trueIf = Inlining.matchWithPotentialInline(trueBlock.getFirstChildOrNull(), new LinkedList<Runnable>(), this.ctx, IfMatching::matchNopFalseIf);
        if (trueIf == null || BranchLeaveMatching.matchBranch(trueIf.getTrueInsn(), elseBranch.getTargetBlock()) == null) {
            return false;
        }
        this.ctx.pushStep("Prepare short-circuit or");
        this.invertIf(trueIf);
        this.ctx.popStep();
        return true;
    }

    private void introduceShortCircuit(IfInstruction ifInsn) {
        if (IfMatching.matchNopFalseIf(ifInsn) == null) {
            return;
        }
        if (!(ifInsn.getTrueInsn() instanceof Block)) {
            return;
        }
        Block trueBlock = (Block)ifInsn.getTrueInsn();
        LinkedList<Runnable> extraTransforms = new LinkedList<Runnable>();
        IfInstruction nestedIf = Inlining.matchWithPotentialInline(trueBlock.getFirstChildOrNull(), extraTransforms, this.ctx, IfMatching::matchNopFalseIf);
        if (nestedIf == null) {
            return;
        }
        if (nestedIf.getNextSiblingOrNull() != null) {
            return;
        }
        if (this.isAssertion(nestedIf)) {
            return;
        }
        this.ctx.pushStep("Introduce short-circuit");
        extraTransforms.forEach(Runnable::run);
        ifInsn.setCondition(new LogicAnd(ifInsn.getCondition(), nestedIf.getCondition()));
        ifInsn.setTrueInsn(nestedIf.getTrueInsn());
        ExpressionTransforms.runOnExpression(ifInsn.getCondition(), this.ctx);
        this.ctx.popStep();
    }

    private boolean isAssertion(IfInstruction ifInsn) {
        LogicAnd and = LogicMatching.matchLogicAnd(ifInsn.getCondition());
        if (and == null) {
            return false;
        }
        LogicNot not = LogicMatching.matchLogicNot(and.getLeft());
        if (not == null) {
            return false;
        }
        Load load = LoadStoreMatching.matchLoadField(not.getArgument());
        if (load == null) {
            return false;
        }
        Field field = ((FieldReference)load.getReference()).getField();
        return field.isSynthetic() && field.getName().equals("$assertionsDisabled");
    }

    private void produceTernary(IfInstruction ifInsn) {
        Block trueBlock = BlockMatching.matchBlock(ifInsn.getTrueInsn());
        if (trueBlock == null) {
            return;
        }
        LinkedList<Runnable> extraTransforms = new LinkedList<Runnable>();
        IfInstruction thenIf = Inlining.matchWithPotentialInline(trueBlock.getFirstChildOrNull(), extraTransforms, this.ctx, IfMatching::matchNopFalseIf);
        if (thenIf == null || thenIf.getNextSiblingOrNull() != null) {
            return;
        }
        Block falseBlock = BlockMatching.matchBlock(ifInsn.getFalseInsn());
        if (falseBlock == null) {
            return;
        }
        IfInstruction elseIf = Inlining.matchWithPotentialInline(falseBlock.getFirstChildOrNull(), extraTransforms, this.ctx, IfMatching::matchNopFalseIf);
        if (elseIf == null || elseIf.getNextSiblingOrNull() != null) {
            return;
        }
        if (!BranchLeaveMatching.compatibleExitInstruction(thenIf.getTrueInsn(), elseIf.getTrueInsn())) {
            return;
        }
        this.ctx.pushStep("Produce ternary");
        extraTransforms.forEach(Runnable::run);
        ifInsn.setCondition(new Ternary(ifInsn.getCondition(), thenIf.getCondition(), elseIf.getCondition()));
        ifInsn.setTrueInsn((Instruction)FastStream.of((Object[])new Instruction[]{thenIf.getTrueInsn(), elseIf.getTrueInsn()}).maxBy(Instruction::getBytecodeOffset));
        ifInsn.setFalseInsn(new Nop());
        this.ctx.popStep();
    }

    private void invertIf(IfInstruction ifInsn) {
        ConditionDetection.invertIf(ifInsn, this.ctx);
    }

    public static void invertIf(IfInstruction ifInsn, MethodTransformContext ctx) {
        Instruction thenInsn;
        Block block = (Block)ifInsn.getParent();
        ctx.pushStep("Invert if");
        assert (ifInsn.getParentOrNull() == block);
        assert (ifInsn.getFalseInsn() instanceof Nop);
        ConditionDetection.getExit(ifInsn.getTrueInsn());
        Instruction elseInsn = ConditionDetection.getExit(block);
        if (ifInsn.getNextSibling() != elseInsn) {
            elseInsn = block.extractRange(ifInsn.getNextSibling(), elseInsn);
        }
        if ((thenInsn = ifInsn.getTrueInsn()) instanceof Block) {
            Block thenBlock = (Block)thenInsn;
            block.instructions.addAll((Iterable<Instruction>)((Object)thenBlock.instructions));
        } else {
            block.instructions.add(thenInsn);
        }
        ifInsn.setTrueInsn(elseInsn);
        ifInsn.setCondition(new LogicNot(ifInsn.getCondition()));
        ExpressionTransforms.runOnExpression(ifInsn.getCondition(), ctx);
        ctx.popStep();
    }

    private static void ensureParentIsBlock(Instruction insn) {
        if (insn.getParent() instanceof Block) {
            return;
        }
        Block b = new Block();
        b.instructions.add(insn);
        insn.replaceWith(b);
    }

    @Nullable
    private static Instruction tryGetExit(@Nullable Instruction insn) {
        Instruction exitInsn = insn;
        if (insn instanceof Block) {
            exitInsn = insn.getLastChildOrNull();
        }
        if (exitInsn != null && exitInsn.hasFlag(InstructionFlag.END_POINT_UNREACHABLE)) {
            return exitInsn;
        }
        return null;
    }

    private static Instruction getExit(Instruction insn) {
        return Objects.requireNonNull(ConditionDetection.tryGetExit(insn));
    }
}

