/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.source;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.covers1624.coffeegrinder.bytecode.AccessFlag;
import net.covers1624.coffeegrinder.bytecode.insns.ClassDecl;
import net.covers1624.coffeegrinder.source.EscapeUtils;
import net.covers1624.coffeegrinder.source.LineBuffer;
import net.covers1624.coffeegrinder.source.NumericConstantPrinter;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.AnnotationData;
import net.covers1624.coffeegrinder.type.AnnotationSupplier;
import net.covers1624.coffeegrinder.type.ArrayType;
import net.covers1624.coffeegrinder.type.CapturedTypeVar;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Field;
import net.covers1624.coffeegrinder.type.IntegerConstantType;
import net.covers1624.coffeegrinder.type.IntegerConstantUnion;
import net.covers1624.coffeegrinder.type.IntersectionType;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.type.NullConstantType;
import net.covers1624.coffeegrinder.type.ParameterizedClass;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.type.ReferenceType;
import net.covers1624.coffeegrinder.type.ReferenceUnionType;
import net.covers1624.coffeegrinder.type.TypeAnnotationData;
import net.covers1624.coffeegrinder.type.TypeParameter;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.coffeegrinder.type.TypeVariable;
import net.covers1624.coffeegrinder.type.WildcardType;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;

public class ImportCollector {
    @Nullable
    private final TypeResolver typeResolver;
    @Nullable
    private NumericConstantPrinter constantPrinter;
    private final LinkedList<ClassType> scopeStack = new LinkedList();
    private final LinkedList<HashSet<String>> variableNameStack = new LinkedList();
    private final List<String> imports = new ArrayList<String>();
    private final Set<String> aliases = new HashSet<String>();
    private final Map<String, String> aliasLookup = new HashMap<String, String>();
    @Nullable
    private ClassType topLevelClass;

    public ImportCollector(@Nullable TypeResolver typeResolver) {
        this.typeResolver = typeResolver;
    }

    public void setConstantPrinter(NumericConstantPrinter printer) {
        this.constantPrinter = printer;
    }

    @Nullable
    public NumericConstantPrinter getConstantPrinter() {
        return this.constantPrinter;
    }

    public List<String> getImports(@Nullable ClassDecl context) {
        return FastStream.of(this.imports).sorted().filter(e -> context == null || !e.equals(context.getClazz().getFullName())).toLinkedList();
    }

    public void setTopLevelClass(ClassType topLevelClass) {
        this.topLevelClass = topLevelClass;
        this.collect(topLevelClass);
    }

    public void pushScope(ClassType type) {
        this.scopeStack.push(type);
    }

    public void popScope() {
        this.scopeStack.pop();
    }

    public void pushVariableScope() {
        this.variableNameStack.push(new HashSet());
    }

    public boolean isVariableInScope(String variableName) {
        for (HashSet hashSet : this.variableNameStack) {
            if (!hashSet.contains(variableName)) continue;
            return true;
        }
        return false;
    }

    public void pushVariableName(String name) {
        Set namesForStack = this.variableNameStack.peek();
        assert (namesForStack != null);
        namesForStack.add(name);
    }

    public void popVariableScope() {
        this.variableNameStack.pop();
    }

    public String collectSimpleTypeParam(TypeParameter parameter) {
        if (TypeSystem.isObject(parameter.getUpperBound())) {
            return parameter.getName();
        }
        return parameter.getName() + " extends " + this.collect(parameter.getUpperBound(), TypeAnnotationData.EMPTY);
    }

    public String collectTypeParam(TypeParameter parameter, AnnotationSupplier supplier) {
        String ann = this.typeAnnotations(supplier.getTypeAnnotations(AnnotationSupplier.TypeAnnotationLocation.TYPE_PARAMETER, null, parameter.getIndex()));
        TypeAnnotationData boundAnnotation = supplier.getTypeAnnotations(AnnotationSupplier.TypeAnnotationLocation.TYPE_PARAMETER_BOUND, parameter.getUpperBound(), parameter.getIndex());
        if (TypeSystem.isObject(parameter.getUpperBound()) && boundAnnotation.isEmpty()) {
            return ann + parameter.getName();
        }
        return ann + parameter.getName() + " extends " + this.collect(parameter.getUpperBound(), boundAnnotation);
    }

    public final LineBuffer annotations(Iterable<AnnotationData> annotations) {
        LineBuffer buffer = LineBuffer.of();
        for (AnnotationData annotation : annotations) {
            buffer = buffer.join(this.annotation(annotation));
        }
        return buffer;
    }

    private String typeAnnotations(TypeAnnotationData data) {
        if (data.isEmpty()) {
            return "";
        }
        LineBuffer buffer = this.annotations(data.annotations);
        String str = buffer.joinOn(" ").toString();
        if (str.isEmpty()) {
            return "";
        }
        return str + " ";
    }

    private LineBuffer annotation(AnnotationData data) {
        LineBuffer buffer = LineBuffer.of("@").append(this.collect(data.type()));
        if (data.isEmpty()) {
            return buffer;
        }
        buffer = buffer.append(" (");
        if (data.isSingleElement()) {
            buffer = buffer.append(this.annotationValue(data.values().get("value")));
        } else {
            boolean first = true;
            for (Map.Entry<String, Object> entry : data.values().entrySet()) {
                if (!first) {
                    buffer = buffer.append(", ");
                }
                first = false;
                buffer = buffer.append(entry.getKey()).append(" = ").append(this.annotationValue(entry.getValue()));
            }
        }
        buffer = buffer.append(")");
        return buffer;
    }

    public LineBuffer annotationValue(Object obj) {
        Object object = obj;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClassType.class, ArrayType.class, String.class, Character.class, Number.class, AnnotationData.class, Field.class, List.class}, (Object)object2, n)) {
            case 0 -> {
                ClassType classType = (ClassType)object2;
                yield LineBuffer.of(this.collect(classType)).append(".class");
            }
            case 1 -> {
                ArrayType arrayType = (ArrayType)object2;
                yield LineBuffer.of(this.collect(arrayType)).append(".class");
            }
            case 2 -> {
                String s = (String)object2;
                yield LineBuffer.of("\"").append(EscapeUtils.escapeChars(s)).append("\"");
            }
            case 3 -> {
                Character c = (Character)object2;
                yield LineBuffer.of("'").append(EscapeUtils.escapeChar(c.charValue())).append("'");
            }
            case 4 -> {
                Number number = (Number)object2;
                if (this.constantPrinter != null) {
                    yield this.constantPrinter.printNumber(number);
                }
                yield LineBuffer.of(obj.toString());
            }
            case 5 -> {
                AnnotationData annotationData = (AnnotationData)object2;
                yield this.annotation(annotationData);
            }
            case 6 -> {
                Field field = (Field)object2;
                yield LineBuffer.of(this.collect(field.getDeclaringClass())).append(".").append(field.getName());
            }
            case 7 -> {
                List list = (List)object2;
                if (list.isEmpty()) {
                    yield LineBuffer.of("{}");
                }
                if (list.size() == 1) {
                    yield LineBuffer.of(this.annotationValue(list.getFirst()));
                }
                LineBuffer buffer = LineBuffer.of("{");
                boolean first = true;
                for (Object o : list) {
                    if (!first) {
                        buffer = buffer.append(", ");
                    }
                    first = false;
                    buffer = buffer.append(this.annotationValue(o));
                }
                yield buffer.append("}");
            }
            default -> LineBuffer.of(obj.toString());
        };
    }

    public String collect(AType type) {
        return this.collect(type, TypeAnnotationData.EMPTY);
    }

    public String collect(AType type, TypeAnnotationData annotations) {
        String annRet = this.typeAnnotations(annotations);
        if (type instanceof PrimitiveType || type instanceof IntegerConstantType || type instanceof IntegerConstantUnion || type instanceof NullConstantType) {
            return annRet + type.getFullName();
        }
        if (type instanceof ArrayType) {
            return this.collect(((ArrayType)type).getElementType(), annotations.step(TypeAnnotationData.Target.ARRAY_ELEMENT)) + ImportCollector.padStart(annRet) + "[]";
        }
        if (type instanceof CapturedTypeVar) {
            return "capture of " + this.collect(((CapturedTypeVar)type).wildcard, TypeAnnotationData.EMPTY);
        }
        if (type instanceof TypeVariable) {
            return annRet + type.getName();
        }
        if (type instanceof ReferenceUnionType) {
            return annRet + FastStream.of(((ReferenceUnionType)type).getTypes()).map(this::collect).join(" | ");
        }
        if (type instanceof IntersectionType) {
            IntersectionType intersection = (IntersectionType)type;
            return annRet + intersection.getDirectSuperTypes().map(this::collect).join(" & ");
        }
        if (type instanceof WildcardType) {
            WildcardType arg = (WildcardType)type;
            TypeAnnotationData wildcardData = annotations.step(TypeAnnotationData.Target.WILDCARD_BOUND);
            if (arg.isInfinite()) {
                return "...";
            }
            if (arg.isSuper()) {
                return annRet + "? super " + this.collect(arg.getLowerBound(), wildcardData);
            }
            if (TypeSystem.isObject(arg.getUpperBound()) && wildcardData.isEmpty()) {
                return annRet + "?";
            }
            return annRet + "? extends " + this.collect(arg.getUpperBound(), wildcardData);
        }
        assert (type instanceof ClassType) : "Unhandled type: " + type.getClass().getName();
        return this.collect((ClassType)type, annotations);
    }

    public String collect(ClassType type) {
        return this.collect(type, TypeAnnotationData.EMPTY);
    }

    public String collect(ClassType type, TypeAnnotationData annotations) {
        return this.collect(type, annotations, false, false);
    }

    public String collect(ClassType type, TypeAnnotationData annotations, boolean targeted, boolean inferredTypeArgs) {
        String annRet = this.typeAnnotations(annotations);
        if (type instanceof ParameterizedClass) {
            Object ret;
            ParameterizedClass pClass = (ParameterizedClass)type;
            if (targeted) {
                ret = pClass.getName();
            } else if (pClass.getDeclType() != ClassType.DeclType.LOCAL && pClass.getOuter() != null) {
                ret = this.collect(pClass.getOuter(), annotations.step(TypeAnnotationData.Target.OUTER_TYPE)) + "." + annRet + pClass.getName();
                annRet = "";
            } else {
                annRet = "";
                ret = this.collect(pClass.getDeclaration(), annotations);
            }
            List<ReferenceType> typeArguments = pClass.getTypeArguments();
            if (!typeArguments.isEmpty()) {
                if (inferredTypeArgs) {
                    ret = (String)ret + "<>";
                } else {
                    StringBuilder b = new StringBuilder("<");
                    for (int i = 0; i < typeArguments.size(); ++i) {
                        if (i != 0) {
                            b.append(", ");
                        }
                        b.append(this.collect(typeArguments.get(i), annotations.step(TypeAnnotationData.Target.TYPE_ARGUMENT, i)));
                    }
                    b.append(">");
                    ret = (String)ret + String.valueOf(b);
                }
            }
            return annRet + (String)ret;
        }
        if (targeted || type.getDeclType().isLocalOrAnonymous()) {
            return type.getName();
        }
        Optional<ClassType> outerClass = type.getEnclosingClass();
        if (outerClass.isPresent()) {
            TypeAnnotationData outerAnnotations = annotations.step(TypeAnnotationData.Target.OUTER_TYPE);
            if (outerAnnotations.isEmpty() && !this.isTypeHidden(type) && this.scopeStack.contains(outerClass.get())) {
                return annRet + type.getName();
            }
            return this.collect(outerClass.get(), outerAnnotations) + "." + annRet + type.getName();
        }
        String fullName = type.getFullName();
        boolean hidden = this.isTypeHidden(type);
        if (hidden) {
            return annRet + fullName;
        }
        String alias = this.aliasLookup.get(fullName);
        if (alias != null) {
            return annRet + alias;
        }
        alias = type.getName();
        if (!this.aliases.add(alias)) {
            alias = fullName;
        } else if (!this.isImplicitlyImported(type)) {
            this.imports.add(fullName);
        }
        this.aliasLookup.put(fullName, alias);
        return annRet + alias;
    }

    public boolean isTypeHidden(ClassType type) {
        if (this.isVariableInScope(type.getName())) {
            return true;
        }
        if (this.findFieldInScope(type.getName()) != null) {
            return true;
        }
        ClassType foundInner = this.findInnerInScope(type.getName());
        return foundInner != null && !foundInner.equals(type.getDeclaration());
    }

    public boolean isFieldHidden(@Nullable ClassType target, Field field) {
        if (this.isVariableInScope(field.getName())) {
            return true;
        }
        FieldInScope found = this.findFieldInScope(field.getName());
        if (found != null) {
            return target != null && found.scope != target || found.field != field.getDeclaration();
        }
        return true;
    }

    public boolean doesStaticFieldRequireQualifier(@Nullable ClassType targetClassType, Field field) {
        return this.isFieldHidden(null, field) || targetClassType != null && !this.scopeStack.contains(targetClassType);
    }

    public boolean isMethodHidden(ClassType targetClassType, String methodName) {
        if (this.scopeStack.isEmpty()) {
            return true;
        }
        assert (this.scopeStack.contains(targetClassType));
        for (ClassType scope : this.scopeStack) {
            if (scope == targetClassType) {
                return false;
            }
            if (ImportCollector.findMethodInHierarchy(scope, methodName) == null) continue;
            return true;
        }
        throw new IllegalStateException();
    }

    public boolean doesStaticMethodRequireQualifier(ClassType targetClassType, String methodName) {
        return !this.scopeStack.contains(targetClassType) || this.isMethodHidden(targetClassType, methodName);
    }

    @Nullable
    private FieldInScope findFieldInScope(String name) {
        for (ClassType scope : this.scopeStack) {
            Field found = ImportCollector.findFieldInHierarchy(scope, name);
            if (found == null) continue;
            return new FieldInScope(scope, found);
        }
        return null;
    }

    @Nullable
    private ClassType findInnerInScope(String name) {
        for (ClassType scope : this.scopeStack) {
            ClassType innerClass = this.findInnerInHierarchy(scope, name);
            if (innerClass == null) continue;
            return innerClass;
        }
        return null;
    }

    private boolean isImplicitlyImported(ClassType type) {
        String packageScope;
        String pkg = type.getPackage();
        String string = packageScope = this.topLevelClass != null ? this.topLevelClass.getPackage() : null;
        if (packageScope != null) {
            if (packageScope.equals(pkg)) {
                return true;
            }
            if (this.typeResolver != null && this.typeResolver.classExists(packageScope + "." + type.getName())) {
                return false;
            }
        }
        return pkg.equals("java.lang");
    }

    @Nullable
    private ClassType findInnerInHierarchy(ClassType type, String name) {
        for (ClassType nestedClass : type.getNestedClasses()) {
            if (!nestedClass.getName().equals(name)) continue;
            return nestedClass;
        }
        return (ClassType)type.getDirectSuperTypes().map(e -> this.findInnerInHierarchy(e.getDeclaration(), name)).filter(Objects::nonNull).firstOrDefault();
    }

    @Nullable
    private static Field findFieldInHierarchy(ClassType type, String name) {
        for (Field field : type.getDeclaration().getFields()) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return (Field)type.getDirectSuperTypes().map(e -> ImportCollector.findFieldInHierarchy(e, name)).filter(Objects::nonNull).filterNot(e -> e.getAccessFlags().get(AccessFlag.PRIVATE)).firstOrDefault();
    }

    @Nullable
    private static Method findMethodInHierarchy(ClassType type, String name) {
        for (Method method : type.getDeclaration().getMethods()) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        return (Method)type.getDirectSuperTypes().map(e -> ImportCollector.findMethodInHierarchy(e, name)).filter(Objects::nonNull).firstOrDefault();
    }

    private static String padStart(String str) {
        return str.isEmpty() ? str : " " + str;
    }

    private record FieldInScope(ClassType scope, Field field) {
    }
}

