/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.type;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.covers1624.coffeegrinder.type.AnnotationData;
import org.jetbrains.annotations.Nullable;

public class TypeAnnotationData {
    public static final TypeAnnotationData EMPTY;
    @Nullable
    private final Target target;
    public final List<AnnotationData> annotations = new LinkedList<AnnotationData>();
    private TypeAnnotationData outer = EMPTY;
    private TypeAnnotationData[] children = new TypeAnnotationData[0];

    public TypeAnnotationData() {
        this(null);
    }

    public TypeAnnotationData(@Nullable Target target) {
        this.target = target;
    }

    public TypeAnnotationData getChild(int i) {
        return i < this.children.length ? this.children[i] : EMPTY;
    }

    public void setChild(int i, TypeAnnotationData child) {
        assert (this != EMPTY) : "Unable to set a child of empty";
        if (i >= this.children.length) {
            int prevLen = this.children.length;
            this.children = Arrays.copyOf(this.children, i + 1);
            Arrays.fill(this.children, prevLen, i + 1, EMPTY);
        }
        this.children[i] = child;
    }

    public TypeAnnotationData getLeftMost() {
        if (this.outer != EMPTY) {
            return this.outer;
        }
        TypeAnnotationData child = this.getChild(0);
        if (child.target == Target.ARRAY_ELEMENT) {
            return child.getLeftMost();
        }
        return this;
    }

    public TypeAnnotationData step(Target target) {
        if (target == Target.OUTER_TYPE) {
            return this.outer;
        }
        return this.step(target, 0);
    }

    public TypeAnnotationData step(Target target, int index) {
        assert (target != Target.OUTER_TYPE) : "OUTER_TYPE is not applicable with an index.";
        TypeAnnotationData child = this.getChild(index);
        assert (child == EMPTY || child.target == target) : "Got: " + String.valueOf((Object)child.target) + " expected: " + String.valueOf((Object)target);
        return child;
    }

    public TypeAnnotationData addStep(Target target) {
        if (target == Target.OUTER_TYPE) {
            if (this.outer == EMPTY) {
                this.outer = new TypeAnnotationData(target);
            }
            return this.outer;
        }
        return this.addStep(target, 0);
    }

    public TypeAnnotationData addStep(Target target, int index) {
        assert (target != Target.OUTER_TYPE) : "OUTER_TYPE is not applicable with an index.";
        TypeAnnotationData child = this.getChild(index);
        if (child == EMPTY) {
            child = new TypeAnnotationData(target);
            this.setChild(index, child);
        } else assert (child.target == target);
        return child;
    }

    public boolean isEmpty() {
        return this.annotations.isEmpty() && this.children.length == 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeAnnotationData that = (TypeAnnotationData)o;
        if (this.target != that.target) {
            return false;
        }
        if (!this.annotations.equals(that.annotations)) {
            return false;
        }
        return Arrays.equals(this.children, that.children);
    }

    static {
        TypeAnnotationData.EMPTY.outer = EMPTY = new TypeAnnotationData();
    }

    public static enum Target {
        ARRAY_ELEMENT,
        OUTER_TYPE,
        WILDCARD_BOUND,
        TYPE_ARGUMENT;

    }
}

